/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.ModuleLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.GenerateMultifileFacadesKt;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.UpdateConstantFacadePropertyReferences;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.UpdateFunctionCallSites;
import ksp.org.jetbrains.kotlin.config.JvmAnalysisFlags;
import ksp.org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;

@PhaseDescription(name="GenerateMultifileFacades", description="Generate JvmMultifileClass facades, based on the information provided by FileClassLowering")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/GenerateMultifileFacades;", "Lksp/org/jetbrains/kotlin/backend/common/ModuleLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irModule", "Lksp/org/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nGenerateMultifileFacades.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateMultifileFacades.kt\norg/jetbrains/kotlin/backend/jvm/lower/GenerateMultifileFacades\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n1261#2,4:356\n*S KotlinDebug\n*F\n+ 1 GenerateMultifileFacades.kt\norg/jetbrains/kotlin/backend/jvm/lower/GenerateMultifileFacades\n*L\n65#1:356,4\n*E\n"})
public final class GenerateMultifileFacades
implements ModuleLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public GenerateMultifileFacades(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrModuleFragment irModule) {
        void $this$associateTo$iv;
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        Map functionDelegates = new LinkedHashMap();
        boolean shouldGeneratePartHierarchy = this.context.getConfig().getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getInheritMultifileParts());
        irModule.getFiles().addAll(GenerateMultifileFacadesKt.access$generateMultifileFacades(irModule, this.context, shouldGeneratePartHierarchy, functionDelegates));
        new UpdateFunctionCallSites(functionDelegates).lower(irModule);
        new UpdateConstantFacadePropertyReferences(this.context, shouldGeneratePartHierarchy).lower(irModule);
        this.context.getMultifileFacadesToAdd().clear();
        Iterable iterable = functionDelegates.entrySet();
        Map<IrSimpleFunction, IrSimpleFunction> destination$iv = this.context.getMultifileFacadeMemberToPartMember();
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map<IrSimpleFunction, IrSimpleFunction> map = destination$iv;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            IrSimpleFunction member = (IrSimpleFunction)entry.getKey();
            IrSimpleFunction newMember = (IrSimpleFunction)entry.getValue();
            entry = TuplesKt.to((Object)newMember, (Object)member);
            map.put((IrSimpleFunction)entry.getFirst(), (IrSimpleFunction)entry.getSecond());
        }
    }
}

