/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.nio.charset.Charset;
import ksp.org.jetbrains.annotations.Nullable;

public final class Murmur3_32Hash {
    public static final Murmur3_32Hash MURMUR3_32 = new Murmur3_32Hash(0);
    private static final int CHUNK_SIZE = 4;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private final int seed;

    public Murmur3_32Hash(int seed) {
        this.seed = seed;
    }

    public int hashInt(int input) {
        int k1 = Murmur3_32Hash.mixK1(input);
        int h1 = Murmur3_32Hash.mixH1(this.seed, k1);
        return Murmur3_32Hash.fMix(h1, 4);
    }

    public int hashLong(long input) {
        int low = (int)input;
        int high = (int)(input >>> 32);
        int k1 = Murmur3_32Hash.mixK1(low);
        int h1 = Murmur3_32Hash.mixH1(this.seed, k1);
        k1 = Murmur3_32Hash.mixK1(high);
        h1 = Murmur3_32Hash.mixH1(h1, k1);
        return Murmur3_32Hash.fMix(h1, 8);
    }

    public int hashUnencodedChars(CharSequence input) {
        int h1 = this.seed;
        for (int i = 1; i < input.length(); i += 2) {
            int k1 = input.charAt(i - 1) | input.charAt(i) << 16;
            k1 = Murmur3_32Hash.mixK1(k1);
            h1 = Murmur3_32Hash.mixH1(h1, k1);
        }
        if ((input.length() & 1) == 1) {
            int k1 = input.charAt(input.length() - 1);
            k1 = Murmur3_32Hash.mixK1(k1);
            h1 ^= k1;
        }
        return Murmur3_32Hash.fMix(h1, 2 * input.length());
    }

    public int hashString(CharSequence input) {
        return this.hashString(input, 0, input.length());
    }

    public int hashString(CharSequence input, int start, int end) {
        int k1;
        int h1 = this.seed;
        int i = start;
        int len = 0;
        while (i + 4 <= end) {
            char c0 = input.charAt(i);
            char c1 = input.charAt(i + 1);
            char c2 = input.charAt(i + 2);
            char c3 = input.charAt(i + 3);
            if (c0 >= '\u0080' || c1 >= '\u0080' || c2 >= '\u0080' || c3 >= '\u0080') break;
            k1 = c0 | c1 << 8 | c2 << 16 | c3 << 24;
            k1 = Murmur3_32Hash.mixK1(k1);
            h1 = Murmur3_32Hash.mixH1(h1, k1);
            i += 4;
            len += 4;
        }
        long buffer = 0L;
        int shift = 0;
        while (i < end) {
            char c = input.charAt(i);
            if (c < '\u0080') {
                buffer |= (long)c << shift;
                shift += 8;
                ++len;
            } else if (c < '\u0800') {
                buffer |= Murmur3_32Hash.charToTwoUtf8Bytes(c) << shift;
                shift += 16;
                len += 2;
            } else if (c < '\ud800' || c > '\udfff') {
                buffer |= Murmur3_32Hash.charToThreeUtf8Bytes(c) << shift;
                shift += 24;
                len += 3;
            } else {
                int codePoint = Character.codePointAt(input, i);
                if (codePoint == c) {
                    byte[] bytes = input.toString().getBytes(Charset.forName("UTF-8"));
                    return this.hashBytes(bytes, 0, bytes.length);
                }
                ++i;
                buffer |= Murmur3_32Hash.codePointToFourUtf8Bytes(codePoint) << shift;
                len += 4;
            }
            if (shift >= 32) {
                k1 = Murmur3_32Hash.mixK1((int)buffer);
                h1 = Murmur3_32Hash.mixH1(h1, k1);
                buffer >>>= 32;
                shift -= 32;
            }
            ++i;
        }
        int k12 = Murmur3_32Hash.mixK1((int)buffer);
        return Murmur3_32Hash.fMix(h1 ^= k12, len);
    }

    public int hashBytes(byte[] input, int off, int len) {
        int k1;
        Murmur3_32Hash.checkPositionIndexes(off, off + len, input.length);
        int h1 = this.seed;
        int i = 0;
        while (i + 4 <= len) {
            k1 = Murmur3_32Hash.mixK1(Murmur3_32Hash.getIntLittleEndian(input, off + i));
            h1 = Murmur3_32Hash.mixH1(h1, k1);
            i += 4;
        }
        k1 = 0;
        int shift = 0;
        while (i < len) {
            k1 ^= Murmur3_32Hash.toInt(input[off + i]) << shift;
            ++i;
            shift += 8;
        }
        return Murmur3_32Hash.fMix(h1 ^= Murmur3_32Hash.mixK1(k1), len);
    }

    private static int getIntLittleEndian(byte[] input, int offset) {
        return Murmur3_32Hash.fromBytes(input[offset + 3], input[offset + 2], input[offset + 1], input[offset]);
    }

    private static int fromBytes(byte b1, byte b2, byte b3, byte b4) {
        return b1 << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    private static int mixK1(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private static int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return h1;
    }

    private static int fMix(int h1, int length) {
        h1 ^= length;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    private static long codePointToFourUtf8Bytes(int codePoint) {
        return (0xF0L | (long)(codePoint >>> 18)) & 0xFFL | (0x80L | (long)(0x3F & codePoint >>> 12)) << 8 | (0x80L | (long)(0x3F & codePoint >>> 6)) << 16 | (0x80L | (long)(0x3F & codePoint)) << 24;
    }

    private static long charToThreeUtf8Bytes(char c) {
        return (0x1E0 | c >>> 12) & 0xFF | (0x80 | 0x3F & c >>> 6) << 8 | (0x80 | 0x3F & c) << 16;
    }

    private static long charToTwoUtf8Bytes(char c) {
        return (0x3C0 | c >>> 6) & 0xFF | (0x80 | 0x3F & c) << 8;
    }

    private static int toInt(byte value2) {
        return value2 & 0xFF;
    }

    private static void checkPositionIndexes(int start, int end, int size) {
        if (start < 0 || end < start || end > size) {
            throw new IndexOutOfBoundsException(Murmur3_32Hash.badPositionIndexes(start, end, size));
        }
    }

    private static String badPositionIndex(int index, int size, @Nullable String desc) {
        if (index < 0) {
            return desc + " (" + index + ") must not be negative";
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return desc + " (" + index + ") must not be greater than size (" + size + ")";
    }

    private static String badPositionIndexes(int start, int end, int size) {
        if (start < 0 || start > size) {
            return Murmur3_32Hash.badPositionIndex(start, size, "start index");
        }
        if (end < 0 || end > size) {
            return Murmur3_32Hash.badPositionIndex(end, size, "end index");
        }
        return "end index (" + end + ") must not be less than start index (" + start + ")";
    }
}

