/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.editor.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.application.ex.ApplicationManagerEx;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.editor.event.DocumentEvent;
import ksp.com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import ksp.com.intellij.openapi.editor.ex.RangeMarkerEx;
import ksp.com.intellij.openapi.editor.impl.DocumentImpl;
import ksp.com.intellij.openapi.editor.impl.IntervalTreeImpl;
import ksp.com.intellij.openapi.editor.impl.RangeMarkerImpl;
import ksp.com.intellij.openapi.editor.impl.RedBlackTree;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.util.DocumentEventUtil;
import ksp.com.intellij.util.SmartList;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

class RangeMarkerTree<T extends RangeMarkerEx>
extends IntervalTreeImpl<T>
implements PrioritizedDocumentListener {
    private static final int DUPLICATE_LIMIT = 30;

    RangeMarkerTree(@NotNull Document document) {
        if (document == null) {
            RangeMarkerTree.$$$reportNull$$$0(0);
        }
        document.addDocumentListener(this);
    }

    RangeMarkerTree() {
    }

    @Override
    public int getPriority() {
        return 40;
    }

    @Override
    protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<T> i1, @NotNull IntervalTreeImpl.IntervalNode<T> i2) {
        boolean stickyR2;
        boolean greedyR2;
        int o2Length;
        boolean greedyL2;
        if (i1 == null) {
            RangeMarkerTree.$$$reportNull$$$0(1);
        }
        if (i2 == null) {
            RangeMarkerTree.$$$reportNull$$$0(2);
        }
        RMNode o1 = (RMNode)i1;
        RMNode o2 = (RMNode)i2;
        boolean greedyL1 = o1.isGreedyToLeft();
        if (greedyL1 != (greedyL2 = o2.isGreedyToLeft())) {
            return greedyL1 ? -1 : 1;
        }
        int o1Length = o1.intervalEnd() - o1.intervalStart();
        int d = o1Length - (o2Length = o2.intervalEnd() - o2.intervalStart());
        if (d != 0) {
            return d;
        }
        boolean greedyR1 = o1.isGreedyToRight();
        if (greedyR1 != (greedyR2 = o2.isGreedyToRight())) {
            return greedyR1 ? -1 : 1;
        }
        boolean stickyR1 = o1.isStickingToRight();
        if (stickyR1 != (stickyR2 = o2.isStickingToRight())) {
            return stickyR1 ? -1 : 1;
        }
        return 0;
    }

    void dispose(@NotNull Document document) {
        if (document == null) {
            RangeMarkerTree.$$$reportNull$$$0(3);
        }
        document.removeDocumentListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RMNode<T> addInterval(@NotNull T interval, int start, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        if (interval == null) {
            RangeMarkerTree.$$$reportNull$$$0(4);
        }
        ((RangeMarkerImpl)interval).setValid(true);
        RMNode node = (RMNode)super.addInterval(interval, start, end, greedyToLeft, greedyToRight, stickingToRight, layer);
        if (DEBUG && node.intervals.size() > 30 && !ApplicationManagerEx.isInStressTest() && ApplicationManager.getApplication().isUnitTestMode()) {
            this.l.readLock().lock();
            try {
                String msg = this.errMsg(node);
                if (msg != null) {
                    LOG.warn(msg);
                }
            }
            finally {
                this.l.readLock().unlock();
            }
        }
        RMNode rMNode = node;
        if (rMNode == null) {
            RangeMarkerTree.$$$reportNull$$$0(5);
        }
        return rMNode;
    }

    @NonNls
    private String errMsg(@NotNull RMNode<T> node) {
        if (node == null) {
            RangeMarkerTree.$$$reportNull$$$0(6);
        }
        System.gc();
        AtomicInteger alive = new AtomicInteger();
        node.processAliveKeys(t -> {
            alive.incrementAndGet();
            return true;
        });
        if (alive.get() > 30) {
            return "Too many range markers (" + alive + ") registered for interval " + node;
        }
        return null;
    }

    @Override
    @NotNull
    protected RMNode<T> createNewNode(@NotNull T key, int start, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        if (key == null) {
            RangeMarkerTree.$$$reportNull$$$0(7);
        }
        return new RMNode<T>(this, key, start, end, greedyToLeft, greedyToRight, stickingToRight);
    }

    @Override
    protected RMNode<T> lookupNode(@NotNull T key) {
        if (key == null) {
            RangeMarkerTree.$$$reportNull$$$0(8);
        }
        return ((RangeMarkerImpl)key).myNode;
    }

    @Override
    protected void setNode(@NotNull T key, IntervalTreeImpl.IntervalNode<T> intervalNode) {
        if (key == null) {
            RangeMarkerTree.$$$reportNull$$$0(9);
        }
        ((RangeMarkerImpl)key).myNode = (RMNode)intervalNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerTree.$$$reportNull$$$0(10);
        }
        List toInvalidate = Collections.emptyList();
        this.l.writeLock().lock();
        try {
            if (this.size() != 0) {
                toInvalidate = this.updateMarkersOnChange(e);
                if (DocumentEventUtil.isMoveInsertion(e)) {
                    toInvalidate = ContainerUtil.concat(toInvalidate, this.reTargetMarkersOnChange(e));
                }
                IntervalTreeImpl.IntervalNode root = this.getRoot();
                assert (root == null || root.maxEnd + root.delta <= e.getDocument().getTextLength()) : "Root: " + root + "; root.maxEnd=" + root.maxEnd + "; root.delta=" + root.delta + "; e.getDocument().getTextLength()=" + e.getDocument().getTextLength() + "; event: " + e;
            }
        }
        finally {
            this.l.writeLock().unlock();
            this.fireAfterRemoved(toInvalidate);
        }
    }

    @NotNull
    private List<T> updateMarkersOnChange(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerTree.$$$reportNull$$$0(11);
        }
        this.checkMax(true);
        this.incModCount();
        SmartList affected = new SmartList();
        int start = e.getOffset();
        int oldLength = e.getOldLength();
        int newLength = e.getNewLength();
        this.collectAffectedMarkersAndShiftSubtrees(this.getRoot(), start, start + oldLength, newLength - oldLength, affected);
        this.checkMax(false);
        if (!affected.isEmpty()) {
            return this.updateAffectedNodes(e, 0, affected);
        }
        List list = Collections.emptyList();
        if (list == null) {
            RangeMarkerTree.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private List<T> updateAffectedNodes(@NotNull DocumentEvent e, int reTargetShift, @NotNull List<? extends IntervalTreeImpl.IntervalNode<T>> affected) {
        if (e == null) {
            RangeMarkerTree.$$$reportNull$$$0(13);
        }
        if (affected == null) {
            RangeMarkerTree.$$$reportNull$$$0(14);
        }
        ArrayList invalidated = affected.isEmpty() ? Collections.emptyList() : new ArrayList(affected.size());
        for (int i = affected.size() - 1; i >= 0; --i) {
            IntervalTreeImpl.IntervalNode<T> node = affected.get(i);
            int startOffset = node.intervalStart();
            int endOffset = node.intervalEnd();
            this.removeNode(node);
            this.checkMax(false);
            node.setParent(null);
            node.setLeft(null);
            node.setRight(null);
            node.setValid(true);
            if (reTargetShift == 0) {
                node.clearDelta();
                assert (node.intervalStart() == startOffset);
                assert (node.intervalEnd() == endOffset);
                continue;
            }
            node.changeDelta(reTargetShift);
            this.pushDelta(node);
        }
        this.checkMax(true);
        for (IntervalTreeImpl.IntervalNode<T> node : affected) {
            RangeMarkerImpl marker = RangeMarkerTree.getAnyNodeMarker(node, invalidated);
            if (marker == null) continue;
            if (reTargetShift == 0) {
                marker.onDocumentChanged(e);
            } else {
                marker.onReTarget(e);
            }
            if (marker.isValid()) {
                this.findOrInsertWithIntervals(node);
            } else {
                node.setValid(false);
                ((RMNode)node).onRemoved();
            }
            if (node.isValid()) continue;
            node.processAliveKeys(t -> invalidated.add(t));
        }
        this.checkMax(true);
        ArrayList arrayList = invalidated;
        if (arrayList == null) {
            RangeMarkerTree.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Nullable
    private static <T extends RangeMarkerEx> RangeMarkerImpl getAnyNodeMarker(@NotNull IntervalTreeImpl.IntervalNode<T> node, @NotNull List<? super T> invalidated) {
        if (node == null) {
            RangeMarkerTree.$$$reportNull$$$0(16);
        }
        if (invalidated == null) {
            RangeMarkerTree.$$$reportNull$$$0(17);
        }
        List keys2 = node.intervals;
        for (int i = keys2.size() - 1; i >= 0; --i) {
            Supplier key = keys2.get(i);
            RangeMarkerEx t = (RangeMarkerEx)key.get();
            RangeMarkerImpl marker = (RangeMarkerImpl)t;
            if (marker == null) continue;
            if (marker.isValid()) {
                return marker;
            }
            node.removeIntervalInternal(i);
            invalidated.add(t);
        }
        return null;
    }

    private void findOrInsertWithIntervals(IntervalTreeImpl.IntervalNode<T> node) {
        IntervalTreeImpl.IntervalNode<T> insertedNode = this.findOrInsert(node);
        if (insertedNode != node) {
            insertedNode.addIntervalsFrom(node);
        }
    }

    void collectAffectedMarkersAndShiftSubtrees(@Nullable IntervalTreeImpl.IntervalNode<T> root, int start, int end, int lengthDelta, @NotNull List<? super IntervalTreeImpl.IntervalNode<T>> affected) {
        if (affected == null) {
            RangeMarkerTree.$$$reportNull$$$0(18);
        }
        if (root == null) {
            return;
        }
        this.pushDelta(root);
        int maxEnd = root.maxEnd;
        assert (root.isValid());
        boolean hasAliveKeys = root.hasAliveKey(false);
        if (!hasAliveKeys) {
            affected.add(root);
        }
        if (start <= maxEnd) {
            if (end < root.intervalStart()) {
                root.changeDelta(lengthDelta);
                RedBlackTree.Node left = root.getLeft();
                if (left != null) {
                    ((IntervalTreeImpl.IntervalNode)left).changeDelta(-lengthDelta);
                }
                this.pushDelta(root);
                this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)left, start, end, lengthDelta, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
                this.correctMax(root, 0);
            } else {
                if (start <= root.intervalEnd()) {
                    if (hasAliveKeys) {
                        affected.add(root);
                    }
                    root.setValid(false);
                }
                this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root.getLeft(), start, end, lengthDelta, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
                this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root.getRight(), start, end, lengthDelta, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
                this.correctMax(root, 0);
            }
        }
    }

    @NotNull
    private List<T> reTargetMarkersOnChange(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerTree.$$$reportNull$$$0(19);
        }
        this.checkMax(true);
        SmartList affected = new SmartList();
        int moveStart = e.getMoveOffset();
        int moveEnd = moveStart + e.getNewLength();
        this.collectNodesToRetarget(this.getRoot(), moveStart, moveEnd, affected);
        if (!affected.isEmpty()) {
            return this.updateAffectedNodes(e, e.getOffset() - e.getMoveOffset(), affected);
        }
        List list = Collections.emptyList();
        if (list == null) {
            RangeMarkerTree.$$$reportNull$$$0(20);
        }
        return list;
    }

    private void collectNodesToRetarget(@Nullable IntervalTreeImpl.IntervalNode<T> root, int start, int end, @NotNull List<? super IntervalTreeImpl.IntervalNode<T>> affected) {
        if (affected == null) {
            RangeMarkerTree.$$$reportNull$$$0(21);
        }
        if (root == null) {
            return;
        }
        this.pushDelta(root);
        int maxEnd = root.maxEnd;
        assert (root.isValid());
        if (start > maxEnd) {
            return;
        }
        this.collectNodesToRetarget((IntervalTreeImpl.IntervalNode<T>)root.getLeft(), start, end, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
        if (start <= root.intervalStart() && root.intervalEnd() <= end) {
            affected.add(root);
        }
        if (end < root.intervalStart()) {
            return;
        }
        this.collectNodesToRetarget((IntervalTreeImpl.IntervalNode<T>)root.getRight(), start, end, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
    }

    @Override
    void beforeRemove(@NotNull T markerEx, @NotNull IntervalTreeImpl.IntervalNode<T> node) {
        if (markerEx == null) {
            RangeMarkerTree.$$$reportNull$$$0(22);
        }
        if (node == null) {
            RangeMarkerTree.$$$reportNull$$$0(23);
        }
        super.beforeRemove(markerEx, node);
        ((RangeMarkerImpl)markerEx).storeOffsetsBeforeDying(node);
    }

    void copyRangeMarkersTo(@NotNull DocumentImpl document, int tabSize) {
        if (document == null) {
            RangeMarkerTree.$$$reportNull$$$0(24);
        }
        ArrayList oldMarkers = new ArrayList(this.size());
        this.processAll(r -> oldMarkers.add(r));
        for (RangeMarkerEx r2 : oldMarkers) {
            TextRange newRange = ((RangeMarkerImpl)r2).reCalcTextRangeAfterReload(document, tabSize);
            RMNode<RangeMarkerEx> node = ((RangeMarkerImpl)r2).myNode;
            if (node == null) continue;
            int startOffset = newRange.getStartOffset();
            int endOffset = newRange.getEndOffset();
            if (r2.isValid() && TextRange.isProperRange(startOffset, endOffset) && endOffset <= document.getTextLength()) {
                document.registerRangeMarker(r2, startOffset, endOffset, r2.isGreedyToLeft(), r2.isGreedyToRight(), 0);
                continue;
            }
            ((RMNode)node).invalidateUnderLock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 12: 
            case 15: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 12: 
            case 15: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interval";
                break;
            }
            case 5: 
            case 12: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/editor/impl/RangeMarkerTree";
                break;
            }
            case 6: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affected";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidated";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerEx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/editor/impl/RangeMarkerTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addInterval";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "updateMarkersOnChange";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "updateAffectedNodes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "reTargetMarkersOnChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compareEqualStartIntervals";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addInterval";
                break;
            }
            case 5: 
            case 12: 
            case 15: 
            case 20: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "errMsg";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNewNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lookupNode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateMarkersOnChange";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateAffectedNodes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAnyNodeMarker";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedMarkersAndShiftSubtrees";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "reTargetMarkersOnChange";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectNodesToRetarget";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "beforeRemove";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "copyRangeMarkersTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 12: 
            case 15: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class RMNode<T extends RangeMarkerEx>
    extends IntervalTreeImpl.IntervalNode<T> {
        private static final byte EXPAND_TO_LEFT_FLAG = 8;
        private static final byte EXPAND_TO_RIGHT_FLAG = 16;
        static final byte STICK_TO_RIGHT_FLAG = 32;

        RMNode(@NotNull RangeMarkerTree<T> rangeMarkerTree, @NotNull T key, int start, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight) {
            if (rangeMarkerTree == null) {
                RMNode.$$$reportNull$$$0(0);
            }
            if (key == null) {
                RMNode.$$$reportNull$$$0(1);
            }
            super(rangeMarkerTree, key, start, end);
            this.setFlag((byte)8, greedyToLeft);
            this.setFlag((byte)16, greedyToRight);
            this.setFlag((byte)32, stickingToRight);
        }

        boolean isGreedyToLeft() {
            return this.isFlagSet((byte)8);
        }

        boolean isGreedyToRight() {
            return this.isFlagSet((byte)16);
        }

        boolean isStickingToRight() {
            return this.isFlagSet((byte)32);
        }

        void onRemoved() {
        }

        @Override
        public String toString() {
            return (this.isGreedyToLeft() ? "[" : "(") + this.intervalStart() + "," + this.intervalEnd() + (this.isGreedyToRight() ? "]" : ")");
        }

        void invalidate() {
            this.setValid(false);
            IntervalTreeImpl tree = this.getTree();
            tree.assertUnderWriteLock();
            this.processAliveKeys((? super E markerEx) -> {
                tree.beforeRemove(markerEx, this);
                tree.setNode(markerEx, null);
                return true;
            });
        }

        private void invalidateUnderLock() {
            List toInvalidate = Collections.emptyList();
            Lock l = this.getTree().l.writeLock();
            l.lock();
            try {
                this.invalidate();
            }
            finally {
                l.unlock();
                this.getTree().fireAfterRemoved(toInvalidate);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rangeMarkerTree";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
            }
            objectArray[1] = "ksp/com/intellij/openapi/editor/impl/RangeMarkerTree$RMNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

