/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.Call;
import ksp.org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import ksp.org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import ksp.org.jetbrains.kotlin.psi.KtTypeProjection;
import ksp.org.jetbrains.kotlin.resolve.calls.CallTransformer;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallCheckerKt;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/OperatorCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "Companion", "frontend"})
public final class OperatorCallChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        boolean isConventionOperator;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = resolvedCall2.getResultingDescriptor();
        FunctionDescriptor functionDescriptor = object instanceof FunctionDescriptor ? (FunctionDescriptor)object : null;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (!OperatorCallChecker.Companion.checkNotErrorOrDynamic(functionDescriptor2)) {
            return;
        }
        KtExpression ktExpression = resolvedCall2.getCall().getCalleeExpression();
        object = ktExpression != null ? (KtElement)ktExpression : resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNull(object);
        Object element2 = object;
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
        Call call3 = call2;
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall && call3 instanceof CallTransformer.CallForImplicitInvoke && ((CallTransformer.CallForImplicitInvoke)call3).itIsVariableAsFunctionCall) {
            Call call4 = ((CallTransformer.CallForImplicitInvoke)call3).getOuterCall();
            Intrinsics.checkNotNullExpressionValue((Object)call4, (String)"getOuterCall(...)");
            Call outerCall = call4;
            if (CallResolverUtilKt.isConventionCall(outerCall)) {
                DeclarationDescriptor declarationDescriptor = functionDescriptor2.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
                String string2 = DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                String containingDeclarationName = string2;
                context2.getTrace().report(Errors.PROPERTY_AS_OPERATOR.on(reportOn, functionDescriptor2, containingDeclarationName));
            } else if (OperatorCallChecker.Companion.isWrongCallWithExplicitTypeArguments((VariableAsFunctionResolvedCall)((Object)resolvedCall2), outerCall)) {
                context2.getTrace().report(Errors.TYPE_ARGUMENTS_NOT_ALLOWED.on((KtElement)((PsiElement)((KtElement)reportOn)), "on implicit invoke call"));
            }
        }
        if (call3.getCallElement() instanceof KtDestructuringDeclarationEntry || call3 instanceof CallTransformer.CallForImplicitInvoke) {
            if (!functionDescriptor2.isOperator()) {
                Companion.report(reportOn, functionDescriptor2, context2.getTrace());
            }
            return;
        }
        boolean bl = isConventionOperator = element2 instanceof KtOperationReferenceExpression && ((KtOperationReferenceExpression)element2).isConventionOperator();
        if (isConventionOperator) {
            OperatorCallCheckerKt.access$checkModConvention(functionDescriptor2, context2.getLanguageVersionSettings(), context2.getTrace(), reportOn);
        }
        if ((isConventionOperator || element2 instanceof KtArrayAccessExpression) && !functionDescriptor2.isOperator()) {
            Companion.report(reportOn, functionDescriptor2, context2.getTrace());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/OperatorCallChecker$Companion;", "", "<init>", "()V", "report", "", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "sink", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkNotErrorOrDynamic", "", "functionDescriptor", "isWrongCallWithExplicitTypeArguments", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/VariableAsFunctionResolvedCall;", "outerCall", "Lksp/org/jetbrains/kotlin/psi/Call;", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final void report(@NotNull PsiElement reportOn, @NotNull FunctionDescriptor descriptor2, @NotNull DiagnosticSink sink) {
            Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!this.checkNotErrorOrDynamic(descriptor2)) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            DeclarationDescriptor containingDeclaration = declarationDescriptor;
            String string2 = DescriptorUtilsKt.getFqNameUnsafe(containingDeclaration).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            String containingDeclarationName = string2;
            sink.report(Errors.OPERATOR_MODIFIER_REQUIRED.on(reportOn, descriptor2, containingDeclarationName));
        }

        private final boolean checkNotErrorOrDynamic(FunctionDescriptor functionDescriptor) {
            return !DynamicCallsKt.isDynamic(functionDescriptor) && !ErrorUtils.isError(functionDescriptor);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isWrongCallWithExplicitTypeArguments(VariableAsFunctionResolvedCall resolvedCall2, Call outerCall) {
            List<KtTypeProjection> list = outerCall.getTypeArguments();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeArguments(...)");
            if (((Collection)list).isEmpty()) return false;
            boolean bl = true;
            if (!bl) return false;
            List<TypeParameterDescriptor> list2 = resolvedCall2.getFunctionCall().getCandidateDescriptor().getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getTypeParameters(...)");
            if (((Collection)list2).isEmpty()) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            boolean bl3 = true;
            boolean passedTypeArgumentsToInvoke = bl3;
            if (!passedTypeArgumentsToInvoke) return false;
            List<TypeParameterDescriptor> list3 = resolvedCall2.getVariableCall().getCandidateDescriptor().getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getTypeParameters(...)");
            if (((Collection)list3).isEmpty()) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

