/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.interpreter.transformer;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.constant.ConstantValue;
import ksp.org.jetbrains.kotlin.constant.ErrorValue;
import ksp.org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import ksp.org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import ksp.org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrScript;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrVariable;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBranch;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBreak;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCatch;
import ksp.org.jetbrains.kotlin.ir.expressions.IrClassReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrComposite;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConst;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrContinue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import ksp.org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetClass;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetField;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrLoop;
import ksp.org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrReturn;
import ksp.org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSetField;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSetValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import ksp.org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrThrow;
import ksp.org.jetbrains.kotlin.ir.expressions.IrTry;
import ksp.org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrVararg;
import ksp.org.jetbrains.kotlin.ir.expressions.IrWhen;
import ksp.org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import ksp.org.jetbrains.kotlin.ir.interpreter.checker.IrInterpreterChecker;
import ksp.org.jetbrains.kotlin.ir.interpreter.checker.IrInterpreterCheckerData;
import ksp.org.jetbrains.kotlin.ir.interpreter.transformer.IrConstTransformerKt;
import ksp.org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001:\u0001#B\u0083\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000f\u0012\u001e\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000f\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0014\u0010\u001b\u001a\u00020\u0019*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\f\u0010\u001c\u001a\u00020\u0015*\u00020\u0019H\u0004J\u0014\u0010\u001d\u001a\u00020\u0019*\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0015H\u0004J\f\u0010\u001f\u001a\u00020\u0012*\u00020\u0019H\u0004J\u0018\u0010 \u001a\u00020\u0012*\u00020\u00192\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lksp/org/jetbrains/kotlin/ir/interpreter/transformer/IrConstTransformer;", "", "interpreter", "Lksp/org/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "mode", "Lksp/org/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "checker", "Lksp/org/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterChecker;", "evaluatedConstTracker", "Lksp/org/jetbrains/kotlin/constant/EvaluatedConstTracker;", "inlineConstTracker", "Lksp/org/jetbrains/kotlin/incremental/components/InlineConstTracker;", "onWarning", "Lkotlin/Function3;", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "Lksp/org/jetbrains/kotlin/ir/expressions/IrErrorExpression;", "", "onError", "suppressExceptions", "", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterChecker;Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function3;Z)V", "warningIfError", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "original", "reportIfError", "canBeInterpreted", "interpret", "failAsError", "saveInConstTracker", "reportInlinedJavaConst", "result", "Lksp/org/jetbrains/kotlin/ir/expressions/IrConst;", "Data", "ir.interpreter"})
public abstract class IrConstTransformer {
    @NotNull
    private final IrInterpreter interpreter;
    @NotNull
    private final IrFile irFile;
    @NotNull
    private final EvaluationMode mode;
    @NotNull
    private final IrInterpreterChecker checker;
    @Nullable
    private final EvaluatedConstTracker evaluatedConstTracker;
    @Nullable
    private final InlineConstTracker inlineConstTracker;
    @NotNull
    private final Function3<IrFile, IrElement, IrErrorExpression, Unit> onWarning;
    @NotNull
    private final Function3<IrFile, IrElement, IrErrorExpression, Unit> onError;
    private final boolean suppressExceptions;

    public IrConstTransformer(@NotNull IrInterpreter interpreter2, @NotNull IrFile irFile, @NotNull EvaluationMode mode, @NotNull IrInterpreterChecker checker, @Nullable EvaluatedConstTracker evaluatedConstTracker, @Nullable InlineConstTracker inlineConstTracker, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onWarning, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onError, boolean suppressExceptions) {
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        Intrinsics.checkNotNullParameter(onWarning, (String)"onWarning");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        this.interpreter = interpreter2;
        this.irFile = irFile;
        this.mode = mode;
        this.checker = checker;
        this.evaluatedConstTracker = evaluatedConstTracker;
        this.inlineConstTracker = inlineConstTracker;
        this.onWarning = onWarning;
        this.onError = onError;
        this.suppressExceptions = suppressExceptions;
    }

    private final IrExpression warningIfError(IrExpression $this$warningIfError, IrExpression original) {
        if ($this$warningIfError instanceof IrErrorExpression) {
            this.onWarning.invoke((Object)this.irFile, (Object)original, (Object)$this$warningIfError);
            return original;
        }
        return $this$warningIfError;
    }

    private final IrExpression reportIfError(IrExpression $this$reportIfError, IrExpression original) {
        if ($this$reportIfError instanceof IrErrorExpression) {
            this.onError.invoke((Object)this.irFile, (Object)original, (Object)$this$reportIfError);
            return this.mode instanceof EvaluationMode.OnlyIntrinsicConst ? (IrExpression)IrConstImpl.Companion.constNull($this$reportIfError.getStartOffset(), $this$reportIfError.getEndOffset(), $this$reportIfError.getType()) : original;
        }
        return $this$reportIfError;
    }

    protected final boolean canBeInterpreted(@NotNull IrExpression $this$canBeInterpreted) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$canBeInterpreted, (String)"<this>");
        try {
            bl = (Boolean)$this$canBeInterpreted.accept(this.checker, new IrInterpreterCheckerData(this.irFile, this.mode, this.interpreter.getIrBuiltIns()));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            if (this.suppressExceptions) {
                return false;
            }
            throw new AssertionError("Error occurred while optimizing an expression:\n" + DumpIrTreeKt.dump$default($this$canBeInterpreted, null, 1, null), e);
        }
        return bl;
    }

    @NotNull
    protected final IrExpression interpret(@NotNull IrExpression $this$interpret, boolean failAsError) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)$this$interpret, (String)"<this>");
        try {
            irExpression = this.interpreter.interpret($this$interpret, this.irFile);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            if (this.suppressExceptions) {
                return $this$interpret;
            }
            throw new AssertionError("Error occurred while optimizing an expression:\n" + DumpIrTreeKt.dump$default($this$interpret, null, 1, null), e);
        }
        IrExpression result2 = irExpression;
        this.saveInConstTracker(result2);
        if (result2 instanceof IrConst) {
            this.reportInlinedJavaConst($this$interpret, (IrConst)result2);
        }
        return failAsError ? this.reportIfError(result2, $this$interpret) : this.warningIfError(result2, $this$interpret);
    }

    protected final void saveInConstTracker(@NotNull IrExpression $this$saveInConstTracker) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$saveInConstTracker, (String)"<this>");
            EvaluatedConstTracker evaluatedConstTracker = this.evaluatedConstTracker;
            if (evaluatedConstTracker == null) break block0;
            evaluatedConstTracker.save($this$saveInConstTracker.getStartOffset(), $this$saveInConstTracker.getEndOffset(), IrDeclarationsKt.getNameWithPackage(this.irFile), $this$saveInConstTracker instanceof IrErrorExpression ? (ConstantValue)ErrorValue.Companion.create(((IrErrorExpression)$this$saveInConstTracker).getDescription()) : IrTreeBuildUtilsKt.toConstantValue($this$saveInConstTracker));
        }
    }

    private final void reportInlinedJavaConst(IrExpression $this$reportInlinedJavaConst, IrConst<?> result2) {
        IrVisitorsKt.acceptVoid($this$reportInlinedJavaConst, new IrElementVisitorVoid(this, result2){
            final /* synthetic */ IrConstTransformer this$0;
            final /* synthetic */ IrConst<?> $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
            }

            public void visitElement(IrElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                IrVisitorsKt.acceptChildrenVoid(element2, this);
            }

            private final void report(IrField field) {
                block0: {
                    InlineConstTracker inlineConstTracker = IrConstTransformer.access$getInlineConstTracker$p(this.this$0);
                    if (inlineConstTracker == null) break block0;
                    IrConstTransformerKt.reportOnIr(inlineConstTracker, IrConstTransformer.access$getIrFile$p(this.this$0), field, this.$result);
                }
            }

            public void visitGetField(IrGetField expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.report((IrField)expression2.getSymbol().getOwner());
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrDeclarationBase irDeclarationBase = UtilsKt.getProperty(expression2.getSymbol().getOwner());
                if (irDeclarationBase != null && (irDeclarationBase = irDeclarationBase.getBackingField()) != null) {
                    IrDeclarationBase backingField = irDeclarationBase;
                    boolean bl = false;
                    this.report((IrField)backingField);
                }
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitElement(IrElement element2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element2, data);
            }

            public void visitDeclaration(IrDeclarationBase declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
            }

            public void visitDeclaration(IrDeclarationBase declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
            }

            public void visitValueParameter(IrValueParameter declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
            }

            public void visitValueParameter(IrValueParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
            }

            public void visitClass(IrClass declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
            }

            public void visitClass(IrClass declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
            }

            public void visitAnonymousInitializer(IrAnonymousInitializer declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
            }

            public void visitAnonymousInitializer(IrAnonymousInitializer declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
            }

            public void visitTypeParameter(IrTypeParameter declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
            }

            public void visitTypeParameter(IrTypeParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
            }

            public void visitFunction(IrFunction declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
            }

            public void visitFunction(IrFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
            }

            public void visitConstructor(IrConstructor declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
            }

            public void visitConstructor(IrConstructor declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
            }

            public void visitEnumEntry(IrEnumEntry declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
            }

            public void visitEnumEntry(IrEnumEntry declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
            }

            public void visitErrorDeclaration(IrErrorDeclaration declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
            }

            public void visitErrorDeclaration(IrErrorDeclaration declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
            }

            public void visitField(IrField declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
            }

            public void visitField(IrField declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
            }

            public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
            }

            public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
            }

            public void visitModuleFragment(IrModuleFragment declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
            }

            public void visitModuleFragment(IrModuleFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
            }

            public void visitProperty(IrProperty declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
            }

            public void visitProperty(IrProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
            }

            public void visitScript(IrScript declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data);
            }

            public void visitScript(IrScript declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
            }

            public void visitSimpleFunction(IrSimpleFunction declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
            }

            public void visitSimpleFunction(IrSimpleFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
            }

            public void visitTypeAlias(IrTypeAlias declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
            }

            public void visitTypeAlias(IrTypeAlias declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
            }

            public void visitVariable(IrVariable declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
            }

            public void visitVariable(IrVariable declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
            }

            public void visitPackageFragment(IrPackageFragment declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
            }

            public void visitPackageFragment(IrPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
            }

            public void visitExternalPackageFragment(IrExternalPackageFragment declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
            }

            public void visitExternalPackageFragment(IrExternalPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
            }

            public void visitFile(IrFile declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
            }

            public void visitFile(IrFile declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
            }

            public void visitExpression(IrExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
            }

            public void visitExpression(IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitBody(IrBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
            }

            public void visitBody(IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitExpressionBody(IrExpressionBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
            }

            public void visitExpressionBody(IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitBlockBody(IrBlockBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
            }

            public void visitBlockBody(IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitDeclarationReference(IrDeclarationReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
            }

            public void visitDeclarationReference(IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitMemberAccess(IrMemberAccessExpression<?> expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
            }

            public void visitMemberAccess(IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitFunctionAccess(IrFunctionAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
            }

            public void visitFunctionAccess(IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitConstructorCall(IrConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
            }

            public void visitConstructorCall(IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitSingletonReference(IrGetSingletonValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
            }

            public void visitSingletonReference(IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitGetObjectValue(IrGetObjectValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
            }

            public void visitGetObjectValue(IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetEnumValue(IrGetEnumValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
            }

            public void visitGetEnumValue(IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitRawFunctionReference(IrRawFunctionReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
            }

            public void visitRawFunctionReference(IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitContainerExpression(IrContainerExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
            }

            public void visitContainerExpression(IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitBlock(IrBlock expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
            }

            public void visitBlock(IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitComposite(IrComposite expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
            }

            public void visitComposite(IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitReturnableBlock(IrReturnableBlock expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2, data);
            }

            public void visitReturnableBlock(IrReturnableBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2);
            }

            public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
            }

            public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock) {
                IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock);
            }

            public void visitSyntheticBody(IrSyntheticBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
            }

            public void visitSyntheticBody(IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitBreakContinue(IrBreakContinue jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
            }

            public void visitBreakContinue(IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreak(IrBreak jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
            }

            public void visitBreak(IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitContinue(IrContinue jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
            }

            public void visitContinue(IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitCall(IrCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
            }

            public void visitCallableReference(IrCallableReference<?> expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
            }

            public void visitCallableReference(IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitFunctionReference(IrFunctionReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
            }

            public void visitFunctionReference(IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitPropertyReference(IrPropertyReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
            }

            public void visitPropertyReference(IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
            }

            public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitClassReference(IrClassReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
            }

            public void visitClassReference(IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitConst(IrConst<?> expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
            }

            public void visitConst(IrConst<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public void visitConstantValue(IrConstantValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
            }

            public void visitConstantValue(IrConstantValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
            }

            public void visitConstantPrimitive(IrConstantPrimitive expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
            }

            public void visitConstantPrimitive(IrConstantPrimitive expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
            }

            public void visitConstantObject(IrConstantObject expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
            }

            public void visitConstantObject(IrConstantObject expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
            }

            public void visitConstantArray(IrConstantArray expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
            }

            public void visitConstantArray(IrConstantArray expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
            }

            public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
            }

            public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDynamicExpression(IrDynamicExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
            }

            public void visitDynamicExpression(IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
            }

            public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
            }

            public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitEnumConstructorCall(IrEnumConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
            }

            public void visitEnumConstructorCall(IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitErrorExpression(IrErrorExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
            }

            public void visitErrorExpression(IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorCallExpression(IrErrorCallExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
            }

            public void visitErrorCallExpression(IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitFieldAccess(IrFieldAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
            }

            public void visitFieldAccess(IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitGetField(IrGetField expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
            }

            public void visitSetField(IrSetField expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
            }

            public void visitSetField(IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitFunctionExpression(IrFunctionExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
            }

            public void visitFunctionExpression(IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitGetClass(IrGetClass expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
            }

            public void visitGetClass(IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
            }

            public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitLoop(IrLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop, data);
            }

            public void visitLoop(IrLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop);
            }

            public void visitWhileLoop(IrWhileLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop, data);
            }

            public void visitWhileLoop(IrWhileLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop);
            }

            public void visitDoWhileLoop(IrDoWhileLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop, data);
            }

            public void visitDoWhileLoop(IrDoWhileLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop);
            }

            public void visitReturn(IrReturn expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
            }

            public void visitReturn(IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitStringConcatenation(IrStringConcatenation expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
            }

            public void visitStringConcatenation(IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitSuspensionPoint(IrSuspensionPoint expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
            }

            public void visitSuspensionPoint(IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspendableExpression(IrSuspendableExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
            }

            public void visitSuspendableExpression(IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitThrow(IrThrow expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
            }

            public void visitThrow(IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitTry(IrTry aTry, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
            }

            public void visitTry(IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitCatch(IrCatch aCatch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
            }

            public void visitCatch(IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitTypeOperator(IrTypeOperatorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
            }

            public void visitTypeOperator(IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitValueAccess(IrValueAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
            }

            public void visitValueAccess(IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
            }

            public void visitGetValue(IrGetValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
            }

            public void visitGetValue(IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitSetValue(IrSetValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
            }

            public void visitSetValue(IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitVararg(IrVararg expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
            }

            public void visitVararg(IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitSpreadElement(IrSpreadElement spread, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
            }

            public void visitSpreadElement(IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitWhen(IrWhen expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
            }

            public void visitWhen(IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitBranch(IrBranch branch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
            }

            public void visitBranch(IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitElseBranch(IrElseBranch branch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
            }

            public void visitElseBranch(IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }
        });
    }

    public static final /* synthetic */ InlineConstTracker access$getInlineConstTracker$p(IrConstTransformer $this) {
        return $this.inlineConstTracker;
    }

    public static final /* synthetic */ IrFile access$getIrFile$p(IrConstTransformer $this) {
        return $this.irFile;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/ir/interpreter/transformer/IrConstTransformer$Data;", "", "inConstantExpression", "", "<init>", "(Z)V", "getInConstantExpression", "()Z", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "ir.interpreter"})
    public static final class Data {
        private final boolean inConstantExpression;

        public Data(boolean inConstantExpression) {
            this.inConstantExpression = inConstantExpression;
        }

        public /* synthetic */ Data(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean getInConstantExpression() {
            return this.inConstantExpression;
        }

        public final boolean component1() {
            return this.inConstantExpression;
        }

        @NotNull
        public final Data copy(boolean inConstantExpression) {
            return new Data(inConstantExpression);
        }

        public static /* synthetic */ Data copy$default(Data data, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = data.inConstantExpression;
            }
            return data.copy(bl);
        }

        @NotNull
        public String toString() {
            return "Data(inConstantExpression=" + this.inConstantExpression + ')';
        }

        public int hashCode() {
            return Boolean.hashCode(this.inConstantExpression);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            return this.inConstantExpression == data.inConstantExpression;
        }

        public Data() {
            this(false, 1, null);
        }
    }
}

