/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmIrSerializer;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.FileClassLoweringKt;
import ksp.org.jetbrains.kotlin.backend.jvm.serialization.JvmGlobalDeclarationTable;
import ksp.org.jetbrains.kotlin.backend.jvm.serialization.JvmIrSerializerSession;
import ksp.org.jetbrains.kotlin.backend.jvm.serialization.proto.JvmIr;
import ksp.org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import ksp.org.jetbrains.kotlin.config.CompilerConfiguration;
import ksp.org.jetbrains.kotlin.config.JVMConfigurationKeys;
import ksp.org.jetbrains.kotlin.config.JvmSerializeIrMode;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/JvmIrSerializerImpl;", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmIrSerializer;", "configuration", "Lksp/org/jetbrains/kotlin/config/CompilerConfiguration;", "<init>", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "declarationTable", "Lksp/org/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "serializeIrFile", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "serializeTopLevelIrClass", "irClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "makeSerializerSession", "Lksp/org/jetbrains/kotlin/backend/jvm/serialization/JvmIrSerializerSession;", "fileClassFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "backend.jvm.entrypoint"})
public final class JvmIrSerializerImpl
implements JvmIrSerializer {
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final DeclarationTable declarationTable;

    public JvmIrSerializerImpl(@NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        this.configuration = configuration2;
        this.declarationTable = new DeclarationTable(new JvmGlobalDeclarationTable());
    }

    @Override
    @Nullable
    public byte[] serializeIrFile(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        FqName fileClassFqName = FileClassLoweringKt.getFileClassInfo(irFile).getFileClassFqName();
        JvmIr.ClassOrFile classOrFile = this.makeSerializerSession(fileClassFqName).serializeJvmIrFile(irFile);
        return (byte[])(classOrFile != null ? classOrFile.toByteArray() : null);
    }

    @Override
    @Nullable
    public byte[] serializeTopLevelIrClass(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        boolean bl = irClass.getParent() instanceof IrFile;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        IrDeclarationParent irDeclarationParent = irClass.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
        FqName fileClassFqName = FileClassLoweringKt.getFileClassInfo((IrFile)irDeclarationParent).getFileClassFqName();
        JvmIr.ClassOrFile classOrFile = this.makeSerializerSession(fileClassFqName).serializeTopLevelClass(irClass);
        return (byte[])(classOrFile != null ? classOrFile.toByteArray() : null);
    }

    private final JvmIrSerializerSession makeSerializerSession(FqName fileClassFqName) {
        JvmSerializeIrMode jvmSerializeIrMode = this.configuration.get(JVMConfigurationKeys.SERIALIZE_IR);
        if (jvmSerializeIrMode == null) {
            jvmSerializeIrMode = JvmSerializeIrMode.NONE;
        }
        return new JvmIrSerializerSession(this.declarationTable, jvmSerializeIrMode, fileClassFqName, CommonConfigurationKeysKt.getLanguageVersionSettings(this.configuration));
    }
}

