/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.lower;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.CommonBackendContext;
import ksp.org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import ksp.org.jetbrains.kotlin.backend.common.LowerKt;
import ksp.org.jetbrains.kotlin.backend.common.ScopeWithIr;
import ksp.org.jetbrains.kotlin.backend.common.lower.InnerClassesLoweringKt;
import ksp.org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import ksp.org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\u000b*\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/InnerClassesMemberBodyLowering;", "Lksp/org/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "innerClassesSupport", "Lksp/org/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "classForImplicitThis", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "Lksp/org/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "getClassForImplicitThis", "(Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;)Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irBody", "Lksp/org/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "fixThisReference", "irClass", "ir.backend.common"})
public class InnerClassesMemberBodyLowering
implements BodyLoweringPass {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final InnerClassesSupport innerClassesSupport;

    public InnerClassesMemberBodyLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.innerClassesSupport = this.context.getInnerClassesSupport();
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        LowerKt.runOnFilePostfix(this, irFile, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final IrClass getClassForImplicitThis(IrValueSymbol $this$classForImplicitThis) {
        if (!($this$classForImplicitThis instanceof IrValueParameterSymbol)) return null;
        if (((IrValueParameter)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner()).getIndex() != -1) return null;
        IrDeclarationParent irDeclarationParent = ((IrValueParameter)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner()).getParent();
        IrFunction irFunction = irDeclarationParent instanceof IrFunction ? (IrFunction)irDeclarationParent : null;
        if (!Intrinsics.areEqual((Object)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner(), (Object)(irFunction != null ? irFunction.getDispatchReceiverParameter() : null))) {
            irDeclarationParent = ((IrValueParameter)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner()).getParent();
            IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
            if (!Intrinsics.areEqual((Object)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner(), (Object)(irClass != null ? irClass.getThisReceiver() : null))) return null;
        }
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(((IrValueParameter)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner()).getType());
        if (irClassSymbol == null) return null;
        IrClass irClass = (IrClass)irClassSymbol.getOwner();
        return irClass;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        IrConstructor primaryConstructor2;
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        IrDeclarationParent irDeclarationParent = container.getParent();
        IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        if (irClass == null) {
            return;
        }
        IrClass irClass2 = irClass;
        if (!irClass2.isInner()) {
            return;
        }
        if ((container instanceof IrField || container instanceof IrAnonymousInitializer || container instanceof IrValueParameter) && (primaryConstructor2 = this.innerClassesSupport.getInnerClassOriginalPrimaryConstructorOrNull(irClass2)) != null) {
            Map oldConstructorParameterToNew = InnerClassesLoweringKt.access$primaryConstructorParameterMap(this.innerClassesSupport, primaryConstructor2);
            IrElementTransformerVoidKt.transformChildrenVoid(irBody, new VariableRemapper(oldConstructorParameterToNew));
        }
        if (container instanceof IrFunction) {
            for (IrValueParameter parameter2 : ((IrFunction)container).getValueParameters()) {
                IrExpressionBody irExpressionBody = parameter2.getDefaultValue();
                if (irExpressionBody != null) {
                    this.fixThisReference(irExpressionBody, irClass2, container);
                }
            }
        }
        this.fixThisReference(irBody, irClass2, container);
    }

    private final void fixThisReference(IrBody $this$fixThisReference, IrClass irClass, IrDeclaration container) {
        IrBody $this$fixThisReference_u24lambda_u240 = $this$fixThisReference;
        boolean bl = false;
        IrDeclaration current = container;
        while (current != null && !(current instanceof IrFunction) && !(current instanceof IrClass)) {
            IrDeclarationParent irDeclarationParent = current.getParent();
            current = irDeclarationParent instanceof IrDeclaration ? (IrDeclaration)((Object)irDeclarationParent) : null;
        }
        IrDeclaration enclosingFunction = (IrDeclaration)((IrElement)current);
        IrElementTransformerVoidKt.transformChildrenVoid($this$fixThisReference, new IrElementTransformerVoidWithContext(this, irClass, enclosingFunction){
            final /* synthetic */ InnerClassesMemberBodyLowering this$0;
            final /* synthetic */ IrClass $irClass;
            final /* synthetic */ IrDeclaration $enclosingFunction;
            {
                this.this$0 = $receiver;
                this.$irClass = $irClass;
                this.$enclosingFunction = $enclosingFunction;
            }

            public IrStatement visitClassNew(IrClass declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                return declaration2;
            }

            public IrExpression visitGetValue(IrGetValue expression2) {
                Object object;
                IrFunction function2;
                IrDeclarationBase irDeclarationBase;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrClass implicitThisClass = InnerClassesMemberBodyLowering.access$getClassForImplicitThis(this.this$0, expression2.getSymbol());
                if (implicitThisClass == null || Intrinsics.areEqual((Object)implicitThisClass, (Object)this.$irClass)) {
                    return expression2;
                }
                int startOffset = expression2.getStartOffset();
                int endOffset = expression2.getEndOffset();
                IrStatementOrigin origin2 = expression2.getOrigin();
                Object object2 = this.getCurrentFunction();
                if (object2 == null || (object2 = ((ScopeWithIr)object2).getIrElement()) == null) {
                    object2 = this.$enclosingFunction;
                }
                if ((irDeclarationBase = (function2 = (object = object2) instanceof IrFunction ? (IrFunction)object : null)) == null || (irDeclarationBase = irDeclarationBase.getDispatchReceiverParameter()) == null) {
                    IrValueParameter irValueParameter = this.$irClass.getThisReceiver();
                    irDeclarationBase = irValueParameter;
                    Intrinsics.checkNotNull((Object)irValueParameter);
                }
                IrDeclarationBase enclosingThisReceiver = irDeclarationBase;
                IrExpression irThis = BuildersKt.IrGetValueImpl(startOffset, endOffset, ((IrValueParameter)enclosingThisReceiver).getSymbol(), origin2);
                IrClass innerClass = this.$irClass;
                while (!Intrinsics.areEqual((Object)innerClass, (Object)implicitThisClass)) {
                    IrDeclarationReference irDeclarationReference;
                    if (!innerClass.isInner()) {
                        return expression2;
                    }
                    if (function2 instanceof IrConstructor && Intrinsics.areEqual((Object)this.$irClass, (Object)innerClass)) {
                        irDeclarationReference = BuildersKt.IrGetValueImpl(startOffset, endOffset, ((IrConstructor)function2).getValueParameters().get(0).getSymbol(), origin2);
                    } else {
                        IrField outerThisField = InnerClassesMemberBodyLowering.access$getInnerClassesSupport$p(this.this$0).getOuterThisField(innerClass);
                        irDeclarationReference = BuildersKt.IrGetFieldImpl$default(startOffset, endOffset, outerThisField.getSymbol(), outerThisField.getType(), irThis, origin2, null, 64, null);
                    }
                    irThis = irDeclarationReference;
                    innerClass = IrUtilsKt.getParentAsClass(innerClass);
                }
                return irThis;
            }
        });
    }

    public static final /* synthetic */ IrClass access$getClassForImplicitThis(InnerClassesMemberBodyLowering $this, IrValueSymbol $receiver) {
        return $this.getClassForImplicitThis($receiver);
    }

    public static final /* synthetic */ InnerClassesSupport access$getInnerClassesSupport$p(InnerClassesMemberBodyLowering $this) {
        return $this.innerClassesSupport;
    }
}

