/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.codeWithMe.ClientId;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.application.Application;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.client.ClientAppSession;
import ksp.com.intellij.openapi.client.ClientKind;
import ksp.com.intellij.openapi.client.ClientProjectSession;
import ksp.com.intellij.openapi.client.ClientSession;
import ksp.com.intellij.openapi.client.ClientSessionsManagerKt;
import ksp.com.intellij.openapi.components.ComponentManager;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Disposer;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u0017*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0007J\u001b\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lksp/com/intellij/openapi/client/ClientSessionsManager;", "T", "Lksp/com/intellij/openapi/client/ClientSession;", "", "()V", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lksp/com/intellij/codeWithMe/ClientId;", "getSession", "clientId", "(Lcom/intellij/codeWithMe/ClientId;)Lcom/intellij/openapi/client/ClientSession;", "getSessions", "", "kind", "Lksp/com/intellij/openapi/client/ClientKind;", "isValid", "", "registerSession", "", "disposable", "Lksp/com/intellij/openapi/Disposable;", "session", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/client/ClientSession;)V", "Companion", "intellij.platform.core"})
@ApiStatus.Experimental
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nClientSessionsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientSessionsManager.kt\ncom/intellij/openapi/client/ClientSessionsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n766#2:93\n857#2,2:94\n*S KotlinDebug\n*F\n+ 1 ClientSessionsManager.kt\ncom/intellij/openapi/client/ClientSessionsManager\n*L\n67#1:93\n67#1:94,2\n*E\n"})
public class ClientSessionsManager<T extends ClientSession> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<ClientId, T> sessions = new ConcurrentHashMap();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<T> getSessions(@NotNull ClientKind kind) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        if (kind == ClientKind.ALL) {
            return new ArrayList<T>(this.sessions.values());
        }
        Collection<T> collection = this.sessions.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClientSession it = (ClientSession)element$iv$iv;
            boolean bl = false;
            if (!it.getType().matches(kind)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final T getSession(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        return (T)((ClientSession)this.sessions.get(clientId));
    }

    public final void registerSession(@NotNull Disposable disposable, @NotNull T session) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(session, (String)"session");
        ClientId clientId = session.getClientId();
        if (this.sessions.putIfAbsent(clientId, session) != null) {
            ClientSessionsManagerKt.access$getLOG$p().error("Session " + session + " with such clientId is already registered");
        }
        ClientSessionsManagerKt.access$getLOG$p().debug("Session added '" + session + '\'');
        Disposer.register(disposable, (Disposable)session);
        Disposer.register(disposable, () -> ClientSessionsManager.registerSession$lambda$1(this, clientId));
    }

    public final boolean isValid(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        T t = this.getSession(clientId);
        return t != null ? !t.isDisposed() : false;
    }

    private static final void registerSession$lambda$1(ClientSessionsManager this$0, ClientId $clientId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$clientId, (String)"$clientId");
        this$0.sessions.remove($clientId);
        ClientSessionsManagerKt.access$getLOG$p().debug("Session removed '" + $clientId + '\'');
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ClientAppSession getAppSession(@NotNull ClientId clientId) {
        return Companion.getAppSession(clientId);
    }

    @JvmStatic
    @NotNull
    public static final List<ClientAppSession> getAppSessions(@NotNull ClientKind kind) {
        return Companion.getAppSessions(kind);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ClientProjectSession getProjectSession(@NotNull Project project, @NotNull ClientId clientId) {
        return Companion.getProjectSession(project, clientId);
    }

    @JvmStatic
    @NotNull
    public static final List<ClientProjectSession> getProjectSessions(@NotNull Project project, @NotNull ClientKind kind) {
        return Companion.getProjectSessions(project, kind);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ClientAppSession getAppSession() {
        return Companion.getAppSession();
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ClientProjectSession getProjectSession(@NotNull Project project) {
        return Companion.getProjectSession(project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u0010"}, d2={"Lksp/com/intellij/openapi/client/ClientSessionsManager$Companion;", "", "()V", "getAppSession", "Lksp/com/intellij/openapi/client/ClientAppSession;", "clientId", "Lksp/com/intellij/codeWithMe/ClientId;", "getAppSessions", "", "kind", "Lksp/com/intellij/openapi/client/ClientKind;", "getProjectSession", "Lksp/com/intellij/openapi/client/ClientProjectSession;", "project", "Lksp/com/intellij/openapi/project/Project;", "getProjectSessions", "intellij.platform.core"})
    @SourceDebugExtension(value={"SMAP\nClientSessionsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientSessionsManager.kt\ncom/intellij/openapi/client/ClientSessionsManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,92:1\n30#2,3:93\n30#2,3:96\n30#2,3:99\n30#2,3:102\n*S KotlinDebug\n*F\n+ 1 ClientSessionsManager.kt\ncom/intellij/openapi/client/ClientSessionsManager$Companion\n*L\n26#1:93,3\n36#1:96,3\n46#1:99,3\n56#1:102,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ClientAppSession getAppSession(@NotNull ClientId clientId) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = application;
            boolean $i$f$service = false;
            Class<ClientSessionsManager> serviceClass$iv = ClientSessionsManager.class;
            ClientSessionsManager clientSessionsManager = $this$service$iv.getService(serviceClass$iv);
            if (clientSessionsManager == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (ClientAppSession)clientSessionsManager.getSession(clientId);
        }

        public static /* synthetic */ ClientAppSession getAppSession$default(Companion companion, ClientId clientId, int n, Object object) {
            if ((n & 1) != 0) {
                clientId = ClientId.Companion.getCurrent();
            }
            return companion.getAppSession(clientId);
        }

        @JvmStatic
        @NotNull
        public final List<ClientAppSession> getAppSessions(@NotNull ClientKind kind) {
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = application;
            boolean $i$f$service = false;
            Class<ClientSessionsManager> serviceClass$iv = ClientSessionsManager.class;
            ClientSessionsManager clientSessionsManager = $this$service$iv.getService(serviceClass$iv);
            if (clientSessionsManager == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return clientSessionsManager.getSessions(kind);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ClientProjectSession getProjectSession(@NotNull Project project, @NotNull ClientId clientId) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            ComponentManager $this$service$iv = project;
            boolean $i$f$service = false;
            Class<ClientSessionsManager> serviceClass$iv = ClientSessionsManager.class;
            ClientSessionsManager clientSessionsManager = $this$service$iv.getService(serviceClass$iv);
            if (clientSessionsManager == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (ClientProjectSession)clientSessionsManager.getSession(clientId);
        }

        public static /* synthetic */ ClientProjectSession getProjectSession$default(Companion companion, Project project, ClientId clientId, int n, Object object) {
            if ((n & 2) != 0) {
                clientId = ClientId.Companion.getCurrent();
            }
            return companion.getProjectSession(project, clientId);
        }

        @JvmStatic
        @NotNull
        public final List<ClientProjectSession> getProjectSessions(@NotNull Project project, @NotNull ClientKind kind) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            ComponentManager $this$service$iv = project;
            boolean $i$f$service = false;
            Class<ClientSessionsManager> serviceClass$iv = ClientSessionsManager.class;
            ClientSessionsManager clientSessionsManager = $this$service$iv.getService(serviceClass$iv);
            if (clientSessionsManager == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return clientSessionsManager.getSessions(kind);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ClientAppSession getAppSession() {
            return ksp.com.intellij.openapi.client.ClientSessionsManager$Companion.getAppSession$default(this, null, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ClientProjectSession getProjectSession(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return ksp.com.intellij.openapi.client.ClientSessionsManager$Companion.getProjectSession$default(this, project, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

