/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.util.diff.FlyweightCapableTreeStructure;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtLightSourceElement;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElementKind;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirFunctionTypeParameter;
import ksp.org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirInconsistentTypeParameterHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirField;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import ksp.org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeNullability;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import ksp.org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J.\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J>\u0010\u0014\u001a\u00020\u00152\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u001a\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u001fH\u0002\u00a8\u0006 "}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypesChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotationOnSuperclass", "superTypeRef", "Lksp/org/jetbrains/kotlin/fir/types/FirTypeRef;", "checkClassCannotBeExtendedDirectly", "symbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "checkDelegationNotToInterface", "checkDelegationWithoutPrimaryConstructor", "checkExpandedTypeCannotBeInherited", "", "Lksp/org/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "fullyExpandedType", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "coneType", "checkNamedFunctionTypeParameter", "checkProjectionInImmediateArgumentToSupertype", "checkSupertypeOnTypeAliasWithTypeProjection", "findSourceForParameterName", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "Lksp/org/jetbrains/kotlin/fir/FirFunctionTypeParameter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSupertypesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSupertypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypesChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 7 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,273:1\n40#2:274\n12511#3,2:275\n21#4:277\n57#4:285\n37#4:287\n21#4:288\n1#5:278\n651#6,6:279\n34#7:286\n*S KotlinDebug\n*F\n+ 1 FirSupertypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypesChecker\n*L\n88#1:274\n192#1:275,2\n205#1:277\n255#1:285\n256#1:287\n261#1:288\n242#1:279,6\n255#1:286\n*E\n"})
public final class FirSupertypesChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirSupertypesChecker INSTANCE = new FirSupertypesChecker();

    private FirSupertypesChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = declaration2.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        boolean isInterface = declaration2.getClassKind() == ClassKind.INTERFACE;
        boolean nullableSupertypeReported = false;
        boolean extensionFunctionSupertypeReported = false;
        boolean interfaceWithSuperclassReported = !isInterface;
        boolean finalSupertypeReported = false;
        boolean singletonInSupertypeReported = false;
        boolean classAppeared = false;
        HashSet superClassSymbols = new HashSet();
        for (FirTypeRef superTypeRef : declaration2.getSuperTypeRefs()) {
            if (superTypeRef.getSource() == null) continue;
            ConeKotlinType coneType = FirTypeUtilsKt.getConeType(superTypeRef);
            if (!nullableSupertypeReported && coneType.getNullability() == ConeNullability.NULLABLE) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_SUPERTYPE(), (DiagnosticContext)context2, null, 8, null);
                nullableSupertypeReported = true;
            }
            if (!extensionFunctionSupertypeReported && CompilerConeAttributesKt.isExtensionFunctionType(coneType) && !FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.FunctionalTypeWithExtensionAsSupertype)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_IS_EXTENSION_FUNCTION_TYPE(), (DiagnosticContext)context2, null, 8, null);
                extensionFunctionSupertypeReported = true;
            }
            this.checkAnnotationOnSuperclass(superTypeRef, context2, reporter);
            ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType(coneType, context2.getSession());
            FirClassifierSymbol<?> symbol2 = TypeUtilsKt.toSymbol(fullyExpandedType2, context2.getSession());
            if (symbol2 instanceof FirRegularClassSymbol) {
                boolean isObject;
                if (!superClassSymbols.add(symbol2)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_APPEARS_TWICE(), (DiagnosticContext)context2, null, 8, null);
                }
                if (((FirRegularClassSymbol)symbol2).getClassKind() != ClassKind.INTERFACE) {
                    if (classAppeared) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getMANY_CLASSES_IN_SUPERTYPE_LIST(), (DiagnosticContext)context2, null, 8, null);
                    } else {
                        classAppeared = true;
                    }
                    if (!interfaceWithSuperclassReported) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getINTERFACE_WITH_SUPERCLASS(), (DiagnosticContext)context2, null, 8, null);
                        interfaceWithSuperclassReported = true;
                    }
                }
                boolean bl = isObject = ((FirRegularClassSymbol)symbol2).getClassKind() == ClassKind.OBJECT;
                if (!finalSupertypeReported && !isObject) {
                    FirClassLikeSymbol $this$modality$iv = (FirClassLikeSymbol)symbol2;
                    boolean $i$f$getModality = false;
                    if ($this$modality$iv.getResolvedStatus().getModality() == Modality.FINAL) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getFINAL_SUPERTYPE(), (DiagnosticContext)context2, null, 8, null);
                        finalSupertypeReported = true;
                    }
                }
                if (!singletonInSupertypeReported && isObject) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSINGLETON_IN_SUPERTYPE(), (DiagnosticContext)context2, null, 8, null);
                    singletonInSupertypeReported = true;
                }
            }
            this.checkClassCannotBeExtendedDirectly(symbol2, reporter, superTypeRef, context2);
            this.checkNamedFunctionTypeParameter(superTypeRef, context2, reporter);
            boolean bl = !(coneType.getTypeArguments().length == 0) ? !this.checkProjectionInImmediateArgumentToSupertype(coneType, superTypeRef, reporter, context2) : !this.checkExpandedTypeCannotBeInherited((FirBasedSymbol)symbol2, fullyExpandedType2, reporter, superTypeRef, coneType, context2);
            boolean shouldCheckSupertypeOnTypealiasWithTypeProjection = bl;
            if (!shouldCheckSupertypeOnTypealiasWithTypeProjection) continue;
            this.checkSupertypeOnTypeAliasWithTypeProjection(coneType, fullyExpandedType2, superTypeRef, reporter, context2);
        }
        this.checkDelegationNotToInterface(declaration2, context2, reporter);
        this.checkDelegationWithoutPrimaryConstructor(declaration2, context2, reporter);
        if (declaration2 instanceof FirRegularClass && declaration2.getSuperTypeRefs().size() > 1) {
            FirInconsistentTypeParameterHelpersKt.checkInconsistentTypeParameters(CollectionsKt.listOf((Object)new Pair(null, (Object)((FirRegularClass)declaration2).getSymbol())), context2, reporter, declaration2.getSource(), true);
        }
    }

    private final void checkAnnotationOnSuperclass(FirTypeRef superTypeRef, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirAnnotation annotation2 : superTypeRef.getAnnotations()) {
            if (annotation2.getUseSiteTarget() == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getANNOTATION_ON_SUPERCLASS(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkClassCannotBeExtendedDirectly(FirClassifierSymbol<?> symbol2, DiagnosticReporter reporter, FirTypeRef superTypeRef, CheckerContext context2) {
        if (symbol2 instanceof FirRegularClassSymbol && Intrinsics.areEqual((Object)((FirRegularClassSymbol)symbol2).getClassId(), (Object)StandardClassIds.INSTANCE.getEnum())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getCLASS_CANNOT_BE_EXTENDED_DIRECTLY(), symbol2, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final boolean checkProjectionInImmediateArgumentToSupertype(ConeKotlinType coneType, FirTypeRef superTypeRef, DiagnosticReporter reporter, CheckerContext context2) {
        List<FirTypeRefSource> list2 = FirHelpersKt.extractArgumentsTypeRefAndSource(superTypeRef);
        if (list2 == null) {
            return false;
        }
        List<FirTypeRefSource> typeRefAndSourcesForArguments = list2;
        boolean result2 = false;
        ConeTypeProjection[] coneTypeProjectionArray = coneType.getTypeArguments();
        int n = coneTypeProjectionArray.length;
        for (int i = 0; i < n; ++i) {
            int index2 = i;
            ConeTypeProjection typeArgument = coneTypeProjectionArray[i];
            if (!FirHelpersKt.isConflictingOrNotInvariant(typeArgument)) continue;
            FirTypeRefSource firTypeRefSource = (FirTypeRefSource)CollectionsKt.getOrNull(typeRefAndSourcesForArguments, (int)index2);
            if (firTypeRefSource == null) continue;
            KtSourceElement argSource = firTypeRefSource.component2();
            KtSourceElement ktSourceElement = argSource;
            if (ktSourceElement == null) {
                ktSourceElement = superTypeRef.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getPROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE(), (DiagnosticContext)context2, null, 8, null);
            result2 = true;
        }
        return result2;
    }

    private final boolean checkExpandedTypeCannotBeInherited(FirBasedSymbol<?> symbol2, ConeKotlinType fullyExpandedType2, DiagnosticReporter reporter, FirTypeRef superTypeRef, ConeKotlinType coneType, CheckerContext context2) {
        if (symbol2 instanceof FirRegularClassSymbol && ((FirRegularClassSymbol)symbol2).getClassKind() == ClassKind.INTERFACE) {
            for (ConeTypeProjection typeArgument : fullyExpandedType2.getTypeArguments()) {
                if (!FirHelpersKt.isConflictingOrNotInvariant(typeArgument)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getEXPANDED_TYPE_CANNOT_BE_INHERITED(), (Object)coneType, (DiagnosticContext)context2, null, 16, null);
                return true;
            }
        }
        return false;
    }

    private final void checkSupertypeOnTypeAliasWithTypeProjection(ConeKotlinType coneType, ConeKotlinType fullyExpandedType2, FirTypeRef superTypeRef, DiagnosticReporter reporter, CheckerContext context2) {
        if (TypeUtilsKt.toSymbol(coneType, context2.getSession()) instanceof FirTypeAliasSymbol) {
            boolean bl;
            block3: {
                ConeTypeProjection[] $this$any$iv = fullyExpandedType2.getTypeArguments();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    ConeTypeProjection element$iv;
                    ConeTypeProjection it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!FirHelpersKt.isConflictingOrNotInvariant(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getCONSTRUCTOR_OR_SUPERTYPE_ON_TYPEALIAS_WITH_TYPE_PROJECTION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final void checkDelegationNotToInterface(FirClass declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirDeclaration subDeclaration : declaration2.getDeclarations()) {
            FirRegularClassSymbol delegatedClassSymbol;
            if (!(subDeclaration instanceof FirField)) continue;
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)subDeclaration;
            boolean $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE) || !FirHelpersKt.isDelegated(((FirField)subDeclaration).getName()) || (delegatedClassSymbol = FirHelpersKt.toRegularClassSymbol(((FirField)subDeclaration).getReturnTypeRef(), context2.getSession())) == null || delegatedClassSymbol.getClassKind() == ClassKind.INTERFACE) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirField)subDeclaration).getReturnTypeRef().getSource(), FirErrors.INSTANCE.getDELEGATION_NOT_TO_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkNamedFunctionTypeParameter(FirTypeRef superTypeRef, CheckerContext context2, DiagnosticReporter reporter) {
        FirTypeRef firTypeRef = superTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)superTypeRef : null;
        if (firTypeRef == null || (firTypeRef = firTypeRef.getDelegatedTypeRef()) == null) {
            return;
        }
        FirTypeRef delegatedTypeRef = firTypeRef;
        if (!(delegatedTypeRef instanceof FirFunctionTypeRef)) {
            return;
        }
        for (FirFunctionTypeParameter parameter2 : ((FirFunctionTypeRef)delegatedTypeRef).getParameters()) {
            KtSourceElement source;
            if (parameter2.getName() == null || this.findSourceForParameterName(parameter2) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"named parameter in function type in supertype position", (DiagnosticContext)context2, null, 16, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final KtSourceElement findSourceForParameterName(FirFunctionTypeParameter $this$findSourceForParameterName) {
        void endOffset$iv;
        void startOffset$iv;
        void $this$toKtLightSourceElement_u24default$iv;
        LighterASTNode node;
        Object v2;
        FlyweightCapableTreeStructure<LighterASTNode> treeStructure;
        block4: {
            KtSourceElement ktSourceElement = $this$findSourceForParameterName.getSource();
            if (ktSourceElement == null) {
                return null;
            }
            KtSourceElement source = ktSourceElement;
            Name name2 = $this$findSourceForParameterName.getName();
            if (name2 == null) {
                return null;
            }
            Name name3 = name2;
            treeStructure = source.getTreeStructure();
            List<LighterASTNode> nodes = LightTreeUtilsKt.getChildren(source.getLighterASTNode(), treeStructure);
            Iterable iterable = nodes;
            for (Object t : iterable) {
                LighterASTNode it = (LighterASTNode)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtTokens.IDENTIFIER) && Intrinsics.areEqual((Object)treeStructure.toString(it), (Object)name3.getIdentifier()))) continue;
                v2 = t;
                break block4;
            }
            v2 = null;
        }
        LighterASTNode lighterASTNode = v2;
        if (lighterASTNode == null) {
            return null;
        }
        LighterASTNode lighterASTNode2 = node = lighterASTNode;
        int n = node.getStartOffset();
        int n2 = node.getEndOffset();
        KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
        boolean $i$f$toKtLightSourceElement = false;
        return new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, (int)startOffset$iv, (int)endOffset$iv, treeStructure, kind$iv);
    }

    private final void checkDelegationWithoutPrimaryConstructor(FirClass declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        FirClass $this$isInterface$iv = declaration2;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
        if (bl) {
            return;
        }
        FirMemberDeclaration $this$isExpect$iv = declaration2;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            return;
        }
        FirConstructorSymbol primaryConstructor2 = DeclarationUtilsKt.primaryConstructorIfAny(declaration2, context2.getSession());
        if (primaryConstructor2 != null) {
            return;
        }
        for (FirDeclaration subDeclaration : declaration2.getDeclarations()) {
            if (!(subDeclaration instanceof FirField)) continue;
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)subDeclaration;
            boolean $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE) || !FirHelpersKt.isDelegated(((FirField)subDeclaration).getName())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)subDeclaration.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Delegation without primary constructor is not supported", (DiagnosticContext)context2, null, 16, null);
        }
    }
}

