/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeTypeParameterInQualifiedAccess;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeErrorType;
import ksp.org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeStarProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import ksp.org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00072\u0006\u0010\r\u001a\u00020\u0013H\u0002R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirKClassWithIncorrectTypeArgumentChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "()V", "typeParameterFromError", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "getTypeParameterFromError", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isKClassTypeWithErrorOrNullableArgument", "", "Lksp/org/jetbrains/kotlin/fir/types/ConeInferenceContext;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirKClassWithIncorrectTypeArgumentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirKClassWithIncorrectTypeArgumentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirKClassWithIncorrectTypeArgumentChecker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n13346#2,2:72\n1863#3,2:74\n*S KotlinDebug\n*F\n+ 1 FirKClassWithIncorrectTypeArgumentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirKClassWithIncorrectTypeArgumentChecker\n*L\n38#1:72,2\n45#1:74,2\n*E\n"})
public final class FirKClassWithIncorrectTypeArgumentChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirKClassWithIncorrectTypeArgumentChecker INSTANCE = new FirKClassWithIncorrectTypeArgumentChecker();

    private FirKClassWithIncorrectTypeArgumentChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirCallableDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (context2.getContainingDeclarations().size() > 1) {
            return;
        }
        KtSourceElement ktSourceElement = declaration2.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (source.getKind() instanceof KtFakeSourceElementKind) {
            return;
        }
        List typeArgumentsWithWrongType = new ArrayList();
        ConeKotlinType returnType2 = FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef());
        if (this.isKClassTypeWithErrorOrNullableArgument(returnType2, TypeComponentsKt.getTypeContext(context2.getSession()))) {
            typeArgumentsWithWrongType.add(returnType2);
        }
        Object $this$forEach$iv = returnType2.getTypeArguments();
        boolean $i$f$forEach = false;
        int n = ((ConeTypeProjection[])$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            ConeKotlinType type2;
            ConeTypeProjection element$iv;
            ConeTypeProjection it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (ConeTypeProjectionKt.getType(it) == null || !INSTANCE.isKClassTypeWithErrorOrNullableArgument(type2, TypeComponentsKt.getTypeContext(context2.getSession()))) continue;
            typeArgumentsWithWrongType.add(type2);
        }
        if (typeArgumentsWithWrongType.isEmpty()) {
            return;
        }
        $this$forEach$iv = typeArgumentsWithWrongType;
        $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            ConeKotlinType it = (ConeKotlinType)element$iv;
            boolean bl = false;
            ConeTypeProjection coneTypeProjection = it.getTypeArguments()[0];
            Object object = coneTypeProjection instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)coneTypeProjection : null;
            if (object == null || (object = ((ConeKotlinTypeProjection)object).getType()) == null || (object = INSTANCE.getTypeParameterFromError((ConeKotlinType)object)) == null) continue;
            Object typeParameterFromError = object;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getKCLASS_WITH_NULLABLE_TYPE_PARAMETER_IN_SIGNATURE(), typeParameterFromError, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final boolean isKClassTypeWithErrorOrNullableArgument(ConeKotlinType $this$isKClassTypeWithErrorOrNullableArgument, ConeInferenceContext context2) {
        ConeTypeProjection coneTypeProjection;
        block10: {
            block9: {
                ConeKotlinType coneKotlinType;
                if (!InferenceUtilsKt.isKClassType($this$isKClassTypeWithErrorOrNullableArgument)) {
                    return false;
                }
                coneTypeProjection = (ConeTypeProjection)CollectionsKt.singleOrNull((List)ArraysKt.toList((Object[])$this$isKClassTypeWithErrorOrNullableArgument.getTypeArguments()));
                if (coneTypeProjection == null) break block9;
                ConeTypeProjection it = coneTypeProjection;
                boolean bl = false;
                ConeTypeProjection coneTypeProjection2 = it;
                if (coneTypeProjection2 instanceof ConeStarProjection) {
                    coneKotlinType = null;
                } else if (coneTypeProjection2 instanceof ConeKotlinTypeProjection) {
                    coneKotlinType = ((ConeKotlinTypeProjection)it).getType();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                coneTypeProjection = coneKotlinType;
                if (coneKotlinType != null) break block10;
            }
            return false;
        }
        ConeTypeProjection argumentType = coneTypeProjection;
        ConeInferenceContext $this$isKClassTypeWithErrorOrNullableArgument_u24lambda_u244 = context2;
        boolean bl = false;
        FirTypeParameterSymbol firTypeParameterSymbol = INSTANCE.getTypeParameterFromError((ConeKotlinType)argumentType);
        if (firTypeParameterSymbol != null) {
            FirTypeParameterSymbol typeParameterSymbol = firTypeParameterSymbol;
            boolean bl2 = false;
            return $this$isKClassTypeWithErrorOrNullableArgument_u24lambda_u244.isNullableType(FirNestedClassifierScopeKt.toConeType(typeParameterSymbol));
        }
        return argumentType instanceof ConeErrorType || $this$isKClassTypeWithErrorOrNullableArgument_u24lambda_u244.isNullableType((KotlinTypeMarker)((Object)argumentType));
    }

    private final FirTypeParameterSymbol getTypeParameterFromError(ConeKotlinType $this$typeParameterFromError) {
        ConeErrorType coneErrorType = $this$typeParameterFromError instanceof ConeErrorType ? (ConeErrorType)$this$typeParameterFromError : null;
        ConeDiagnostic coneDiagnostic = coneErrorType != null ? coneErrorType.getDiagnostic() : null;
        ConeTypeParameterInQualifiedAccess coneTypeParameterInQualifiedAccess = coneDiagnostic instanceof ConeTypeParameterInQualifiedAccess ? (ConeTypeParameterInQualifiedAccess)coneDiagnostic : null;
        return coneTypeParameterInQualifiedAccess != null ? coneTypeParameterInQualifiedAccess.getSymbol() : null;
    }
}

