/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/OverloadsAnnotationChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDeclaration", "annotationEntry", "Lksp/org/jetbrains/kotlin/psi/KtAnnotationEntry;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\ndeclarationCheckers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 declarationCheckers.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/OverloadsAnnotationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,260:1\n2632#2,3:261\n*S KotlinDebug\n*F\n+ 1 declarationCheckers.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/OverloadsAnnotationChecker\n*L\n225#1:261,3\n*E\n"})
public final class OverloadsAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            AnnotationDescriptor annotationDescriptor = JvmAnnotationUtilKt.findJvmOverloadsAnnotation(descriptor2);
            if (annotationDescriptor == null) break block1;
            AnnotationDescriptor annotation2 = annotationDescriptor;
            boolean bl = false;
            KtAnnotationEntry annotationEntry2 = DescriptorToSourceUtils.getSourceFromAnnotation(annotation2);
            if (annotationEntry2 != null) {
                this.checkDeclaration(annotationEntry2, descriptor2, context2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDeclaration(KtAnnotationEntry annotationEntry, DeclarationDescriptor descriptor, DeclarationCheckerContext context) {
        block11: {
            block9: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block10: {
                                        diagnosticHolder = context.getTrace();
                                        if (!(descriptor instanceof CallableDescriptor)) {
                                            return;
                                        }
                                        var6_5 = ((CallableDescriptor)descriptor).getContainingDeclaration();
                                        v0 = var6_5 instanceof ClassDescriptor != false ? (ClassDescriptor)var6_5 : null;
                                        if ((v0 != null ? v0.getKind() : null) != ClassKind.INTERFACE) break block10;
                                        diagnosticHolder.report(ErrorsJvm.OVERLOADS_INTERFACE.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
                                        break block11;
                                    }
                                    if (!(descriptor instanceof FunctionDescriptor) || ((FunctionDescriptor)descriptor).getModality() != Modality.ABSTRACT) break block12;
                                    diagnosticHolder.report(ErrorsJvm.OVERLOADS_ABSTRACT.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
                                    break block11;
                                }
                                if (!DescriptorUtils.isLocal(descriptor)) break block13;
                                diagnosticHolder.report(ErrorsJvm.OVERLOADS_LOCAL.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
                                break block11;
                            }
                            if (!DescriptorUtilsKt.isAnnotationConstructor(descriptor)) break block14;
                            diagnosticHolder.report(ErrorsJvm.OVERLOADS_ANNOTATION_CLASS_CONSTRUCTOR.on(context.getLanguageVersionSettings(), (KtAnnotationEntry)((PsiElement)annotationEntry)));
                            break block11;
                        }
                        if (((CallableDescriptor)descriptor).getVisibility().isPublicAPI() || Intrinsics.areEqual((Object)((CallableDescriptor)descriptor).getVisibility(), (Object)DescriptorVisibilities.INTERNAL)) break block15;
                        diagnosticHolder.report(ErrorsJvm.OVERLOADS_PRIVATE.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
                        break block11;
                    }
                    v1 = ((CallableDescriptor)descriptor).getValueParameters();
                    Intrinsics.checkNotNullExpressionValue(v1, (String)"getValueParameters(...)");
                    $this$none$iv = v1;
                    $i$f$none = false;
                    if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) break block16;
                    v2 = true;
                    break block9;
                }
                for (T element$iv : $this$none$iv) {
                    it = (ValueParameterDescriptor)element$iv;
                    $i$a$-none-OverloadsAnnotationChecker$checkDeclaration$1 = false;
                    if (it.declaresDefaultValue()) ** GOTO lbl-1000
                    Intrinsics.checkNotNull((Object)it);
                    if (ArgumentsUtilsKt.isActualParameterWithCorrespondingExpectedDefault(it)) lbl-1000:
                    // 2 sources

                    {
                        v3 = true;
                    } else {
                        v3 = false;
                    }
                    if (!v3) continue;
                    v2 = false;
                    break block9;
                }
                v2 = true;
            }
            if (v2) {
                diagnosticHolder.report(ErrorsJvm.OVERLOADS_WITHOUT_DEFAULT_ARGUMENTS.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
            } else if (descriptor instanceof SimpleFunctionDescriptor && (InlineClassManglingRulesKt.requiresFunctionNameManglingForParameterTypes((CallableMemberDescriptor)descriptor) || InlineClassManglingRulesKt.requiresFunctionNameManglingForReturnType((CallableMemberDescriptor)descriptor))) {
                diagnosticHolder.report(ErrorsJvm.OVERLOADS_ANNOTATION_MANGLED_FUNCTION.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
            } else if (descriptor instanceof ClassConstructorDescriptor && InlineClassManglingRulesKt.shouldHideConstructorDueToValueClassTypeValueParameters((CallableMemberDescriptor)descriptor)) {
                diagnosticHolder.report(ErrorsJvm.OVERLOADS_ANNOTATION_HIDDEN_CONSTRUCTOR.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
            }
        }
    }
}

