/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsNameChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsNameChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsNameChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,69:1\n1782#2,4:70\n40#3:74\n25#4:75\n*S KotlinDebug\n*F\n+ 1 FirJsNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsNameChecker\n*L\n25#1:70,4\n39#1:74\n40#1:75\n*E\n"})
public final class FirJsNameChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsNameChecker INSTANCE = new FirJsNameChecker();

    private FirJsNameChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirDeclaration firDeclaration;
        KtSourceElement jsNameSource;
        block21: {
            block20: {
                boolean $i$f$isOverride;
                Object $this$isOverride$iv;
                block19: {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                    if (declaration2 instanceof FirProperty) {
                        int namedAccessorCount;
                        int n;
                        Object[] objectArray = new FirPropertyAccessorSymbol[2];
                        FirPropertyAccessor firPropertyAccessor = ((FirProperty)declaration2).getGetter();
                        objectArray[0] = firPropertyAccessor != null ? firPropertyAccessor.getSymbol() : null;
                        FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)declaration2).getSetter();
                        objectArray[1] = firPropertyAccessor2 != null ? firPropertyAccessor2.getSymbol() : null;
                        List accessors = CollectionsKt.listOfNotNull((Object[])objectArray);
                        Iterable $this$count$iv = accessors;
                        boolean $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            n = 0;
                        } else {
                            int count$iv = 0;
                            for (Object element$iv : $this$count$iv) {
                                FirPropertyAccessorSymbol it = (FirPropertyAccessorSymbol)element$iv;
                                boolean bl = false;
                                if (!(FirJsHelpersKt.getJsName(it, context2.getSession()) != null) || ++count$iv >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            n = namedAccessorCount = count$iv;
                        }
                        if (namedAccessorCount > 0 && namedAccessorCount < accessors.size()) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getJS_NAME_IS_NOT_ON_ALL_ACCESSORS(), (DiagnosticContext)context2, null, 8, null);
                        }
                    }
                    FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration2, JsStandardClassIds.Annotations.JsName, context2.getSession());
                    if (firAnnotation == null) {
                        return;
                    }
                    FirAnnotation jsName = firAnnotation;
                    KtSourceElement ktSourceElement = jsName.getSource();
                    if (ktSourceElement == null) {
                        ktSourceElement = jsNameSource = declaration2.getSource();
                    }
                    if (FirHelpersKt.getAnnotationStringParameter(declaration2.getSymbol(), JsStandardClassIds.Annotations.JsNative, context2.getSession()) != null) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_PROHIBITED_FOR_NAMED_NATIVE(), (DiagnosticContext)context2, null, 8, null);
                    }
                    if (!(declaration2 instanceof FirCallableDeclaration)) break block19;
                    $this$isOverride$iv = (FirMemberDeclaration)declaration2;
                    $i$f$isOverride = false;
                    if (((FirMemberDeclaration)$this$isOverride$iv).getStatus().isOverride()) break block20;
                }
                if (!(declaration2 instanceof FirPropertyAccessor)) break block21;
                $this$isOverride$iv = ((FirPropertyAccessor)declaration2).getPropertySymbol();
                $i$f$isOverride = false;
                if (!((FirCallableSymbol)$this$isOverride$iv).getRawStatus().isOverride()) break block21;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_PROHIBITED_FOR_OVERRIDE(), (DiagnosticContext)context2, null, 8, null);
        }
        if ((firDeclaration = declaration2) instanceof FirConstructor) {
            if (((FirConstructor)declaration2).isPrimary()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_ON_PRIMARY_CONSTRUCTOR_PROHIBITED(), (DiagnosticContext)context2, null, 8, null);
            }
        } else if (firDeclaration instanceof FirPropertyAccessor) {
            FirPropertySymbol property2 = ((FirPropertyAccessor)declaration2).getPropertySymbol();
            if (FirJsHelpersKt.getJsName(property2, context2.getSession()) != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_ON_ACCESSOR_AND_PROPERTY(), (DiagnosticContext)context2, null, 8, null);
            }
        } else if (firDeclaration instanceof FirProperty && FirDeclarationUtilKt.isExtension((FirCallableDeclaration)declaration2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_PROHIBITED_FOR_EXTENSION_PROPERTY(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

