/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.util.diff.FlyweightCapableTreeStructure;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.ElementTypeUtils;
import ksp.org.jetbrains.kotlin.KtLightSourceElement;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtPsiSourceElement;
import ksp.org.jetbrains.kotlin.KtRealPsiSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirExpressionSyntaxChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpression;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtIsExpression;
import ksp.org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import ksp.org.jetbrains.kotlin.psi.KtPsiUtil;
import ksp.org.jetbrains.kotlin.psi.KtWhenCondition;
import ksp.org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import ksp.org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import ksp.org.jetbrains.kotlin.psi.KtWhenEntry;
import ksp.org.jetbrains.kotlin.psi.KtWhenExpression;
import ksp.org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J6\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/syntax/FirConfusingWhenBranchSyntaxChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExpressionSyntaxChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lksp/com/intellij/psi/PsiElement;", "()V", "prohibitedTokens", "Lksp/com/intellij/psi/tree/TokenSet;", "Lksp/org/jetbrains/annotations/NotNull;", "checkCondition", "", "condition", "Lksp/org/jetbrains/kotlin/psi/KtWhenCondition;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkConditionExpression", "offset", "", "expression", "Lksp/com/intellij/lang/LighterASTNode;", "tree", "Lksp/com/intellij/util/diff/FlyweightCapableTreeStructure;", "rawExpression", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "checkLightTree", "element", "source", "Lksp/org/jetbrains/kotlin/KtLightSourceElement;", "checkPsi", "Lksp/org/jetbrains/kotlin/KtPsiSourceElement;", "psi", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConfusingWhenBranchSyntaxChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConfusingWhenBranchSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirConfusingWhenBranchSyntaxChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n774#2:120\n865#2,2:121\n295#2,2:123\n295#2,2:125\n230#2,2:127\n*S KotlinDebug\n*F\n+ 1 FirConfusingWhenBranchSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirConfusingWhenBranchSyntaxChecker\n*L\n43#1:120\n43#1:121,2\n48#1:123,2\n50#1:125,2\n68#1:127,2\n*E\n"})
public final class FirConfusingWhenBranchSyntaxChecker
extends FirExpressionSyntaxChecker<FirWhenExpression, PsiElement> {
    @NotNull
    public static final FirConfusingWhenBranchSyntaxChecker INSTANCE = new FirConfusingWhenBranchSyntaxChecker();
    @NotNull
    private static final TokenSet prohibitedTokens;

    private FirConfusingWhenBranchSyntaxChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkLightTree(@NotNull FirWhenExpression element2, @NotNull KtLightSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (element2.getSubject() == null && element2.getSubjectVariable() == null) {
            return;
        }
        FlyweightCapableTreeStructure<LighterASTNode> tree = source.getTreeStructure();
        Iterable $this$filter$iv = LightTreeUtilsKt.getChildren(source.getLighterASTNode(), tree);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LighterASTNode it = (LighterASTNode)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.WHEN_ENTRY)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List entries = (List)destination$iv$iv;
        int offset = source.getStartOffset() - source.getLighterASTNode().getStartOffset();
        for (LighterASTNode entry : entries) {
            for (LighterASTNode node : LightTreeUtilsKt.getChildren(entry, tree)) {
                LighterASTNode lighterASTNode;
                LighterASTNode it;
                boolean $i$f$firstOrNull;
                Iterable $this$firstOrNull$iv;
                IElementType iElementType = node.getTokenType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.WHEN_CONDITION_EXPRESSION)) {
                    Object v0;
                    block10: {
                        $this$firstOrNull$iv = LightTreeUtilsKt.getChildren(node, tree);
                        $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it = (LighterASTNode)element$iv;
                            boolean bl = false;
                            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
                            v0 = element$iv;
                            break block10;
                        }
                        v0 = null;
                    }
                    lighterASTNode = v0;
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.WHEN_CONDITION_IN_RANGE)) {
                    Object v2;
                    block11: {
                        $this$firstOrNull$iv = LightTreeUtilsKt.getChildren(node, tree);
                        $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it = (LighterASTNode)element$iv;
                            boolean bl = false;
                            if (!(!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.OPERATION_REFERENCE) && ElementTypeUtils.INSTANCE.isExpression(it))) continue;
                            v2 = element$iv;
                            break block11;
                        }
                        v2 = null;
                    }
                    lighterASTNode = v2;
                } else {
                    lighterASTNode = null;
                }
                if (lighterASTNode == null) continue;
                LighterASTNode expression2 = lighterASTNode;
                this.checkConditionExpression(offset, expression2, tree, context2, reporter);
            }
        }
    }

    private final void checkConditionExpression(int offset, LighterASTNode expression2, FlyweightCapableTreeStructure<LighterASTNode> tree, CheckerContext context2, DiagnosticReporter reporter) {
        boolean shouldReport;
        boolean bl;
        IElementType iElementType = expression2.getTokenType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.IS_EXPRESSION)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BINARY_EXPRESSION)) {
            Object element$iv2;
            block6: {
                Iterable $this$first$iv = LightTreeUtilsKt.getChildren(expression2, tree);
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    LighterASTNode it = (LighterASTNode)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.OPERATION_REFERENCE)) continue;
                    break block6;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            String operationTokenName = element$iv2.toString();
            IElementType operationToken = ElementTypeUtils.INSTANCE.getOperationSymbol(operationTokenName);
            bl = prohibitedTokens.contains(operationToken);
        } else {
            bl = shouldReport = false;
        }
        if (shouldReport) {
            KtLightSourceElement source = new KtLightSourceElement(expression2, offset + expression2.getStartOffset(), offset + expression2.getEndOffset(), tree, null, 16, null);
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONFUSING_BRANCH_CONDITION(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    @Override
    public void checkPsi(@NotNull FirWhenExpression element2, @NotNull KtPsiSourceElement source, @NotNull PsiElement psi2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)psi2, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (element2.getSubject() == null && element2.getSubjectVariable() == null) {
            return;
        }
        KtWhenExpression whenExpression = (KtWhenExpression)psi2;
        if (whenExpression.getSubjectExpression() == null && whenExpression.getSubjectVariable() == null) {
            return;
        }
        for (KtWhenEntry entry : whenExpression.getEntries()) {
            KtWhenCondition[] ktWhenConditionArray;
            Intrinsics.checkNotNullExpressionValue((Object)entry.getConditions(), (String)"getConditions(...)");
            for (KtWhenCondition condition : ktWhenConditionArray) {
                Intrinsics.checkNotNull((Object)condition);
                this.checkCondition(condition, context2, reporter);
            }
        }
    }

    private final void checkCondition(KtWhenCondition condition, CheckerContext context2, DiagnosticReporter reporter) {
        KtWhenCondition ktWhenCondition = condition;
        if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
            this.checkConditionExpression(((KtWhenConditionWithExpression)condition).getExpression(), context2, reporter);
        } else if (ktWhenCondition instanceof KtWhenConditionInRange) {
            this.checkConditionExpression(((KtWhenConditionInRange)condition).getRangeExpression(), context2, reporter);
        }
    }

    private final void checkConditionExpression(KtExpression rawExpression, CheckerContext context2, DiagnosticReporter reporter) {
        boolean shouldReport;
        if (rawExpression == null) {
            return;
        }
        if (rawExpression instanceof KtParenthesizedExpression) {
            return;
        }
        KtExpression ktExpression = KtPsiUtil.safeDeparenthesize(rawExpression);
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"safeDeparenthesize(...)");
        KtExpression expression2 = ktExpression;
        boolean bl = expression2 instanceof KtIsExpression ? true : (shouldReport = expression2 instanceof KtBinaryExpression ? prohibitedTokens.contains(((KtBinaryExpression)expression2).getOperationToken()) : false);
        if (shouldReport) {
            KtRealPsiSourceElement source = new KtRealPsiSourceElement(rawExpression);
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONFUSING_BRANCH_CONDITION(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.NOT_IN, KtTokens.LT, KtTokens.LTEQ, KtTokens.GT, KtTokens.GTEQ, KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, KtTokens.ANDAND, KtTokens.OROR};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        prohibitedTokens = tokenSet;
    }
}

