/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConstantArgumentKind;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.FirConstChecksKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeErrorType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstPropertyChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConstPropertyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConstPropertyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstPropertyChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,74:1\n47#2:75\n*S KotlinDebug\n*F\n+ 1 FirConstPropertyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstPropertyChecker\n*L\n28#1:75\n*E\n"})
public final class FirConstPropertyChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirConstPropertyChecker INSTANCE = new FirConstPropertyChecker();

    private FirConstPropertyChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        KtDiagnosticFactory0 ktDiagnosticFactory0;
        KtSourceElement source;
        ClassKind classKind2;
        FirModifier<?> it;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirMemberDeclaration $this$isConst$iv = declaration2;
        boolean $i$f$isConst = false;
        if (!$this$isConst$iv.getStatus().isConst()) {
            return;
        }
        if (declaration2.isVar()) {
            FirModifier<?> constModifier;
            FirElement firElement = declaration2;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.CONST_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"CONST_KEYWORD");
            FirModifier<?> firModifier = constModifier = FirKeywordUtilsKt.getModifier(firElement, ktModifierKeywordToken);
            if (firModifier != null) {
                it = firModifier;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), (Object)it.getToken(), (Object)"vars", (DiagnosticContext)context2, null, 32, null);
            }
        }
        FirRegularClass firRegularClass = (it = CollectionsKt.lastOrNull(context2.getContainingDeclarations())) instanceof FirRegularClass ? (FirRegularClass)((Object)it) : null;
        ClassKind classKind3 = classKind2 = firRegularClass != null ? firRegularClass.getClassKind() : null;
        if (classKind2 != ClassKind.OBJECT && context2.getContainingDeclarations().size() > 1) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getCONST_VAL_NOT_TOP_LEVEL_OR_OBJECT(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        FirPropertyAccessor firPropertyAccessor = declaration2.getGetter();
        KtSourceElement ktSourceElement = source = firPropertyAccessor != null ? firPropertyAccessor.getSource() : null;
        if (source != null && !(source.getKind() instanceof KtFakeSourceElementKind)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONST_VAL_WITH_GETTER(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        if (declaration2.getDelegate() != null) {
            FirExpression firExpression2 = declaration2.getDelegate();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(firExpression2 != null ? firExpression2.getSource() : null), FirErrors.INSTANCE.getCONST_VAL_WITH_DELEGATE(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        FirExpression initializer2 = declaration2.getInitializer();
        if (initializer2 == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getCONST_VAL_WITHOUT_INITIALIZER(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        ConeKotlinType type2 = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2.getSession());
        if (!(type2 instanceof ConeErrorType) && !FirConstChecksKt.canBeUsedForConstVal(type2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getTYPE_CANT_BE_USED_FOR_CONST_VAL(), (Object)FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), (DiagnosticContext)context2, null, 16, null);
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[FirConstChecksKt.computeConstantExpressionKind(initializer2, context2.getSession(), true).ordinal()]) {
            case 1: 
            case 2: {
                return;
            }
            case 3: {
                ktDiagnosticFactory0 = FirErrors.INSTANCE.getNON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION();
                break;
            }
            default: {
                ktDiagnosticFactory0 = FirErrors.INSTANCE.getCONST_VAL_WITH_NON_CONST_INITIALIZER();
            }
        }
        KtDiagnosticFactory0 errorKind = ktDiagnosticFactory0;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)initializer2.getSource(), errorKind, (DiagnosticContext)context2, null, 8, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstantArgumentKind.values().length];
            try {
                nArray[ConstantArgumentKind.VALID_CONST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.RESOLUTION_ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.NOT_CONST_VAL_IN_CONST_EXPRESSION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

