/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstructorAllowedChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstructorChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConstructorAllowedChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConstructorAllowedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstructorAllowedChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n21#2:61\n11#2:62\n1745#3,3:63\n*S KotlinDebug\n*F\n+ 1 FirConstructorAllowedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstructorAllowedChecker\n*L\n38#1:61\n43#1:62\n45#1:63,3\n*E\n"})
public final class FirConstructorAllowedChecker
extends FirDeclarationChecker<FirConstructor> {
    @NotNull
    public static final FirConstructorAllowedChecker INSTANCE = new FirConstructorAllowedChecker();

    private FirConstructorAllowedChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirConstructor declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        IElementType elementType;
        KtSourceElement source;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Object object = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        if (!(object instanceof FirClass)) return;
        FirClass firClass = (FirClass)object;
        if (firClass == null) {
            return;
        }
        FirClass containingClass = firClass;
        KtSourceElement ktSourceElement = source = declaration2.getSource();
        IElementType iElementType = elementType = ktSourceElement != null ? ktSourceElement.getElementType() : null;
        if (!Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR) && !Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.SECONDARY_CONSTRUCTOR)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[containingClass.getClassKind().ordinal()]) {
            case 1: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONSTRUCTOR_IN_OBJECT(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            case 2: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONSTRUCTOR_IN_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            case 3: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONSTRUCTOR_IN_OBJECT(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            case 4: {
                FirMemberDeclaration $this$visibility$iv = declaration2;
                boolean $i$f$getVisibility = false;
                if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) return;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_PRIVATE_CONSTRUCTOR_IN_ENUM(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            case 5: {
                FirModifier it;
                KtModifierKeywordToken token;
                FirClass firClass2 = containingClass;
                if (firClass2 instanceof FirAnonymousObject) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONSTRUCTOR_IN_OBJECT(), (DiagnosticContext)context2, null, 8, null);
                    return;
                }
                if (!(firClass2 instanceof FirRegularClass)) return;
                FirMemberDeclaration $this$modality$iv = containingClass;
                boolean $i$f$getModality = false;
                if ($this$modality$iv.getStatus().getModality() != Modality.SEALED) return;
                FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(source);
                if (firModifierList == null) {
                    return;
                }
                FirModifierList modifierList2 = firModifierList;
                Iterable $this$any$iv = modifierList2.getModifiers();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return;
                }
                Iterator iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return;
                    Object element$iv = iterator2.next();
                    it = (FirModifier)element$iv;
                    boolean bl = false;
                } while (!(KtTokens.VISIBILITY_MODIFIERS.contains(token = it.getToken()) && !Intrinsics.areEqual((Object)token, (Object)KtTokens.PROTECTED_KEYWORD) && !Intrinsics.areEqual((Object)token, (Object)KtTokens.PRIVATE_KEYWORD)));
                boolean bl = true;
                boolean hasIllegalModifier = bl;
                if (!hasIllegalModifier) return;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_PRIVATE_OR_PROTECTED_CONSTRUCTOR_IN_SEALED(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

