/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.UtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirConflictsHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationCollector;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirVariable;
import ksp.org.jetbrains.kotlin.fir.expressions.FirBlock;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeSession;
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeSessionKey;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScope;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScopeKt;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.SpecialNames;
import ksp.org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JB\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2 \u0010\u001b\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u0002H\u0002R\u001c\u0010\u0005\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\u00a8\u0006\u001f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "isPrimaryConstructor", "", "Lksp/org/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkFile", "file", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFile;", "inspector", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationCollector;", "getDestructuredParameters", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirVariable;", "function", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "reportConflicts", "declarationConflictingSymbols", "", "Lksp/org/jetbrains/kotlin/utils/SmartSet;", "container", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConflictsDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConflictsDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ScopeSession.kt\norg/jetbrains/kotlin/fir/resolve/ScopeSession\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,144:1\n2622#2,3:145\n764#2:148\n855#2,2:149\n1618#2,3:151\n1609#2:154\n1853#2:155\n1854#2:157\n1610#2:158\n1724#2,3:160\n1745#2,3:164\n1#3:156\n1#3:163\n215#4:159\n216#4:167\n18#5:168\n19#5:172\n20#5,2:177\n372#6,3:169\n375#6,4:173\n*S KotlinDebug\n*F\n+ 1 FirConflictsDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker\n*L\n58#1:145,3\n60#1:148\n60#1:149,2\n61#1:151,3\n63#1:154\n63#1:155\n63#1:157\n63#1:158\n90#1:160,3\n102#1:164,3\n63#1:156\n75#1:159\n75#1:167\n116#1:168\n116#1:172\n116#1:177,2\n116#1:169,3\n116#1:173,4\n*E\n"})
public final class FirConflictsDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirConflictsDeclarationChecker INSTANCE = new FirConflictsDeclarationChecker();

    private FirConflictsDeclarationChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirFile) {
            FirDeclarationCollector inspector = new FirDeclarationCollector(context2);
            this.checkFile((FirFile)declaration2, inspector, context2);
            this.reportConflicts(reporter, context2, (Map)inspector.getDeclarationConflictingSymbols(), declaration2);
        } else if (firDeclaration instanceof FirRegularClass) {
            KtSourceElement ktSourceElement = declaration2.getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) {
                FirConflictsHelpersKt.checkForLocalRedeclarations(((FirRegularClass)declaration2).getTypeParameters(), context2, reporter);
            }
            FirDeclarationCollector inspector = new FirDeclarationCollector(context2);
            FirConflictsHelpersKt.collectClassMembers(inspector, ((FirRegularClass)declaration2).getSymbol());
            this.reportConflicts(reporter, context2, (Map)inspector.getDeclarationConflictingSymbols(), declaration2);
        } else {
            KtSourceElement ktSourceElement = declaration2.getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) && declaration2 instanceof FirTypeParameterRefsOwner) {
                if (declaration2 instanceof FirFunction) {
                    List<FirVariable> destructuredParameters = this.getDestructuredParameters((FirFunction)declaration2);
                    FirConflictsHelpersKt.checkForLocalRedeclarations(destructuredParameters, context2, reporter);
                }
                FirConflictsHelpersKt.checkForLocalRedeclarations(((FirTypeParameterRefsOwner)((Object)declaration2)).getTypeParameters(), context2, reporter);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirVariable> getDestructuredParameters(FirFunction function2) {
        void $this$mapNotNullTo$iv;
        Collection destination$iv;
        Iterator iterator2;
        Iterable $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        Object element$iv2;
        boolean bl;
        block8: {
            Iterable $this$none$iv = function2.getValueParameters();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$none$iv) {
                    FirValueParameter it = (FirValueParameter)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)SpecialNames.DESTRUCT)) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (bl) {
            return function2.getValueParameters();
        }
        Iterable $this$filter$iv = function2.getValueParameters();
        boolean $i$f$filter22 = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirValueParameter it = (FirValueParameter)element$iv$iv;
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)SpecialNames.DESTRUCT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection $i$f$filter22 = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            iterator2 = (FirValueParameter)item$iv;
            void var17_19 = destination$iv;
            boolean bl4 = false;
            var17_19.add(it.getSymbol());
        }
        Set destructuredParametersBoxes = (Set)destination$iv;
        FirBlock firBlock = function2.getBody();
        List list2 = firBlock != null ? firBlock.getStatements() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        $this$mapTo$iv = list2;
        destination$iv = CollectionsKt.toMutableList((Collection)function2.getValueParameters());
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirVariable it$iv;
            Object destructuredParameter;
            Object element$iv$iv;
            Object element$iv3 = element$iv$iv = iterator2.next();
            boolean bl5 = false;
            FirStatement it = (FirStatement)element$iv3;
            boolean bl6 = false;
            Object object = it instanceof FirVariable ? (FirVariable)it : null;
            if ((object == null || (object = FirConflictsHelpersKt.getDestructuredParameter((FirVariable)object)) == null ? null : (destructuredParametersBoxes.contains(destructuredParameter = object) ? (FirVariable)it : null)) == null) continue;
            it$iv = it$iv;
            boolean bl7 = false;
            destination$iv.add(it$iv);
        }
        return (List)destination$iv;
    }

    private final void reportConflicts(DiagnosticReporter reporter, CheckerContext context2, Map<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> declarationConflictingSymbols, FirDeclaration container2) {
        Map<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> $this$forEach$iv = declarationConflictingSymbols;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            FirBasedSymbol it;
            KtSourceElement source;
            KtSourceElement ktSourceElement;
            Map.Entry<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> element$iv;
            Map.Entry<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            FirBasedSymbol<?> conflictingDeclaration = entry.getKey();
            SmartSet<FirBasedSymbol<?>> symbols = entry.getValue();
            FirBasedSymbol firBasedSymbol = conflictingDeclaration instanceof FirConstructorSymbol ? (FirConstructorSymbol)conflictingDeclaration : null;
            KtSourceElement typeAliasForConstructorSource = firBasedSymbol != null && (firBasedSymbol = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasForConstructor((FirConstructorSymbol)firBasedSymbol)) != null ? firBasedSymbol.getSource() : null;
            FirDeclarationOrigin origin2 = conflictingDeclaration.getOrigin();
            if (!(conflictingDeclaration instanceof FirCallableSymbol)) {
                ktSourceElement = conflictingDeclaration.getSource();
            } else if (Intrinsics.areEqual((Object)origin2, (Object)FirDeclarationOrigin.Source.INSTANCE)) {
                ktSourceElement = conflictingDeclaration.getSource();
            } else {
                if (Intrinsics.areEqual((Object)origin2, (Object)FirDeclarationOrigin.Library.INSTANCE)) continue;
                ktSourceElement = source = Intrinsics.areEqual((Object)origin2, (Object)FirDeclarationOrigin.Synthetic.TypeAliasConstructor.INSTANCE) ? typeAliasForConstructorSource : container2.getSource();
            }
            if (symbols.isEmpty()) continue;
            if (INSTANCE.isPrimaryConstructor(conflictingDeclaration)) {
                boolean bl3;
                block18: {
                    Iterable $this$all$iv = (Iterable)((Object)symbols);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            it = (FirBasedSymbol)element$iv2;
                            boolean bl4 = false;
                            if (INSTANCE.isPrimaryConstructor(it)) continue;
                            bl3 = false;
                            break block18;
                        }
                        bl3 = true;
                    }
                }
                if (bl3) continue;
            }
            if ((FirBasedSymbol)CollectionsKt.singleOrNull((Iterable)((Iterable)((Object)symbols))) != null) {
                FirBasedSymbol it2;
                boolean bl5 = false;
                bl = FirConflictsHelpersKt.isExpectAndActual(conflictingDeclaration, it2);
            } else {
                bl = false;
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECT_AND_ACTUAL_IN_THE_SAME_MODULE(), conflictingDeclaration, (DiagnosticContext)context2, null, 16, null);
                continue;
            }
            if (conflictingDeclaration instanceof FirNamedFunctionSymbol || conflictingDeclaration instanceof FirConstructorSymbol) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONFLICTING_OVERLOADS(), symbols, (DiagnosticContext)context2, null, 16, null);
                continue;
            }
            if (conflictingDeclaration instanceof FirClassLikeSymbol && FirHelpersKt.getContainingClassSymbol(conflictingDeclaration, context2.getSession()) == null) {
                boolean bl6;
                block19: {
                    Iterable $this$any$iv = (Iterable)((Object)symbols);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl6 = false;
                    } else {
                        for (Object element$iv3 : $this$any$iv) {
                            it = (FirBasedSymbol)element$iv3;
                            boolean bl7 = false;
                            if (!(it instanceof FirClassLikeSymbol)) continue;
                            bl6 = true;
                            break block19;
                        }
                        bl6 = false;
                    }
                }
                if (bl6) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getPACKAGE_OR_CLASSIFIER_REDECLARATION(), symbols, (DiagnosticContext)context2, null, 16, null);
                    continue;
                }
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getREDECLARATION(), symbols, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final boolean isPrimaryConstructor(FirBasedSymbol<?> $this$isPrimaryConstructor) {
        return $this$isPrimaryConstructor instanceof FirConstructorSymbol && ((FirConstructorSymbol)$this$isPrimaryConstructor).isPrimary() || Intrinsics.areEqual((Object)$this$isPrimaryConstructor.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.TypeAliasConstructor.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFile(FirFile file2, FirDeclarationCollector<FirBasedSymbol<?>> inspector, CheckerContext context2) {
        Object object;
        Object object2;
        void id$iv;
        void this_$iv;
        ScopeSession scopeSession = context2.getSessionHolder().getScopeSession();
        FqName fqName2 = UtilsKt.getPackageFqName(file2);
        ScopeSessionKey<FqName, FirPackageMemberScope> key$iv = FirPackageMemberScopeKt.getPACKAGE_MEMBER();
        boolean $i$f$getOrBuild = false;
        Map $this$getOrPut$iv$iv = this_$iv.scopes();
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(id$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            HashMap answer$iv$iv = new HashMap();
            $this$getOrPut$iv$iv.put(id$iv, answer$iv$iv);
            object2 = answer$iv$iv;
        } else {
            object2 = value$iv$iv;
        }
        $this$getOrPut$iv$iv = (Map)object2;
        $i$f$getOrPut = false;
        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            FirPackageMemberScope answer$iv$iv = new FirPackageMemberScope(UtilsKt.getPackageFqName(file2), context2.getSessionHolder().getSession(), null, null, 12, null);
            $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        FirPackageMemberScope packageMemberScope = (FirPackageMemberScope)object;
        FirConflictsHelpersKt.collectTopLevel(inspector, file2, packageMemberScope);
    }
}

