/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.util.SmartList;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.CodegenUtil;
import ksp.org.jetbrains.kotlin.codegen.AsmUtil;
import ksp.org.jetbrains.kotlin.codegen.ClassBuilder;
import ksp.org.jetbrains.kotlin.codegen.CodeFragmentCodegen;
import ksp.org.jetbrains.kotlin.codegen.CodegenUtilKt;
import ksp.org.jetbrains.kotlin.codegen.MemberCodegen;
import ksp.org.jetbrains.kotlin.codegen.PackageCodegen;
import ksp.org.jetbrains.kotlin.codegen.PackagePartCodegen;
import ksp.org.jetbrains.kotlin.codegen.ScriptCodegen;
import ksp.org.jetbrains.kotlin.codegen.context.CodegenContext;
import ksp.org.jetbrains.kotlin.codegen.context.PackageContext;
import ksp.org.jetbrains.kotlin.codegen.state.GenerationState;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import ksp.org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import ksp.org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import ksp.org.jetbrains.kotlin.psi.KtClassBody;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtCodeFragment;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import ksp.org.jetbrains.kotlin.psi.KtScript;
import ksp.org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import ksp.org.jetbrains.kotlin.resolve.lazy.descriptors.PackageDescriptorUtilKt;
import ksp.org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;
import ksp.org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;
import ksp.org.jetbrains.org.objectweb.asm.Type;

public class PackageCodegenImpl
implements PackageCodegen {
    private static final Logger LOG = Logger.getInstance(PackageCodegenImpl.class);
    private final GenerationState state;
    private final Collection<KtFile> files;
    private final PackageFragmentDescriptor packageFragment;

    public PackageCodegenImpl(@NotNull GenerationState state, @NotNull Collection<KtFile> files2, @NotNull FqName packageFqName) {
        if (state == null) {
            PackageCodegenImpl.$$$reportNull$$$0(0);
        }
        if (files2 == null) {
            PackageCodegenImpl.$$$reportNull$$$0(1);
        }
        if (packageFqName == null) {
            PackageCodegenImpl.$$$reportNull$$$0(2);
        }
        this.state = state;
        this.files = files2;
        this.packageFragment = this.getOnlyPackageFragment(packageFqName);
    }

    @Override
    public void generate() {
        for (KtFile file2 : this.files) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            try {
                this.generateFile(file2);
                this.state.afterIndependentPart();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                VirtualFile vFile = file2.getVirtualFile();
                CodegenUtil.reportBackendException(e, "file facade code generation", vFile == null ? null : vFile.getUrl(), null, (Function1<? super Integer, Pair<Integer, Integer>>)((Function1)it -> null));
            }
        }
    }

    public static void generateClassesAndObjectsInFile(@NotNull KtFile file2, @NotNull CodegenContext<?> context2, @NotNull GenerationState state) {
        if (file2 == null) {
            PackageCodegenImpl.$$$reportNull$$$0(3);
        }
        if (context2 == null) {
            PackageCodegenImpl.$$$reportNull$$$0(4);
        }
        if (state == null) {
            PackageCodegenImpl.$$$reportNull$$$0(5);
        }
        ArrayList<KtClassOrObject> classOrObjects = new ArrayList<KtClassOrObject>();
        for (KtDeclaration declaration2 : file2.getDeclarations()) {
            if (declaration2 instanceof KtClassOrObject) {
                if (PsiUtilsKt.hasExpectModifier(declaration2)) {
                    PackageCodegenImpl.addDescriptorToOptionalAnnotationsIfNeeded((KtClassOrObject)declaration2, state);
                    continue;
                }
                KtClassOrObject classOrObject = (KtClassOrObject)declaration2;
                if (!state.getGenerateDeclaredClassFilter().shouldGenerateClass(classOrObject)) continue;
                classOrObjects.add(classOrObject);
                continue;
            }
            if (!(declaration2 instanceof KtScript)) continue;
            KtScript script = (KtScript)declaration2;
            if (!state.getGenerateDeclaredClassFilter().shouldGenerateScript(script)) continue;
            ScriptCodegen.createScriptCodegen(script, state, context2).generate();
        }
        List<KtClassOrObject> sortedClasses = CodegenUtilKt.sortTopLevelClassesAndPrepareContextForSealedClasses(classOrObjects, context2, state);
        for (KtClassOrObject classOrObject : sortedClasses) {
            MemberCodegen.genClassOrObject(context2, classOrObject, state, null);
        }
    }

    private static void addDescriptorToOptionalAnnotationsIfNeeded(@NotNull KtClassOrObject declaration2, @NotNull GenerationState state) {
        ClassDescriptor descriptor2;
        if (declaration2 == null) {
            PackageCodegenImpl.$$$reportNull$$$0(6);
        }
        if (state == null) {
            PackageCodegenImpl.$$$reportNull$$$0(7);
        }
        if ((descriptor2 = state.getBindingContext().get(BindingContext.CLASS, declaration2)) == null || !OptionalAnnotationUtil.shouldGenerateExpectClass(descriptor2)) {
            return;
        }
        assert (OptionalAnnotationUtil.isOptionalAnnotationClass(descriptor2)) : "Expect class should be generated only if it's an optional annotation: " + descriptor2;
        state.getFactory().getPackagePartRegistry().getOptionalAnnotations().add(descriptor2);
        KtClassBody body2 = declaration2.getBody();
        if (body2 != null) {
            for (KtDeclaration childDeclaration : body2.getDeclarations()) {
                if (!(childDeclaration instanceof KtClassOrObject)) continue;
                PackageCodegenImpl.addDescriptorToOptionalAnnotationsIfNeeded((KtClassOrObject)childDeclaration, state);
            }
        }
    }

    private void generateFile(@NotNull KtFile file2) {
        JvmFileClassInfo fileClassInfo;
        if (file2 == null) {
            PackageCodegenImpl.$$$reportNull$$$0(8);
        }
        if ((fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(file2)).getWithJvmMultifileClass()) {
            return;
        }
        Type fileClassType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(fileClassInfo.getFileClassFqName());
        PackageContext packagePartContext = this.state.getRootContext().intoPackagePart(this.packageFragment, fileClassType, file2);
        if (file2 instanceof KtCodeFragment) {
            if (this.state.getClassBuilderMode().generateBodies && this.state.getGenerateDeclaredClassFilter().shouldGenerateCodeFragment((KtCodeFragment)file2)) {
                CodeFragmentCodegen.createCodegen((KtCodeFragment)file2, this.state, packagePartContext).generate();
            }
        } else {
            PackageCodegenImpl.generateClassesAndObjectsInFile(file2, packagePartContext, this.state);
        }
        if (!this.state.getGenerateDeclaredClassFilter().shouldGeneratePackagePart(file2)) {
            return;
        }
        if (CodegenUtil.getMemberDeclarationsToGenerate(file2).isEmpty()) {
            return;
        }
        this.state.getFactory().getPackagePartRegistry().addPart(this.packageFragment.getFqName(), fileClassType.getInternalName(), null);
        ClassBuilder builder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.PackagePart(file2, this.packageFragment), fileClassType, file2);
        new PackagePartCodegen(builder2, file2, fileClassType, packagePartContext, this.state).generate();
    }

    @Nullable
    private PackageFragmentDescriptor getOnlyPackageFragment(@NotNull FqName expectedPackageFqName) {
        if (expectedPackageFqName == null) {
            PackageCodegenImpl.$$$reportNull$$$0(9);
        }
        SmartList<PackageFragmentDescriptor> fragments2 = new SmartList<PackageFragmentDescriptor>();
        for (KtFile file2 : this.files) {
            PackageFragmentDescriptor fragment = PackageDescriptorUtilKt.findPackageFragmentForFile(this.state.getModule(), file2);
            if (fragment == null) {
                LOG.error(new KotlinExceptionWithAttachments("package fragment is not found for module:" + this.state.getModule() + " file:" + file2).withPsiAttachment("file.kt", file2));
            } else if (!expectedPackageFqName.equals(fragment.getFqName())) {
                LOG.error("expected package fq name: " + expectedPackageFqName + ", actual: " + fragment.getFqName());
            }
            if (fragments2.contains(fragment)) continue;
            fragments2.add(fragment);
        }
        if (fragments2.size() > 1) {
            throw new IllegalStateException("More than one package fragment, files: " + this.files + " | fragments: " + fragments2);
        }
        if (fragments2.isEmpty()) {
            return null;
        }
        return (PackageFragmentDescriptor)fragments2.get(0);
    }

    @Override
    public PackageFragmentDescriptor getPackageFragment() {
        return this.packageFragment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFqName";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedPackageFqName";
                break;
            }
        }
        objectArray2[1] = "ksp/org/jetbrains/kotlin/codegen/PackageCodegenImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "generateClassesAndObjectsInFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addDescriptorToOptionalAnnotationsIfNeeded";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "generateFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getOnlyPackageFragment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

