/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.com.intellij.openapi.util.Disposer;
import ksp.com.intellij.util.ExceptionUtil;
import ksp.com.intellij.util.ReflectionUtil;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.com.intellij.util.containers.DisposableWrapperList;
import ksp.com.intellij.util.lang.CompoundRuntimeException;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.TestOnly;

public final class EventDispatcher<T extends EventListener> {
    private static final Logger LOG = Logger.getInstance(EventDispatcher.class);
    private T myMulticaster;
    private final DisposableWrapperList<T> myListeners;
    @NotNull
    private final Class<T> myListenerClass;
    @Nullable
    private final Map<String, Object> myMethodReturnValues;

    @NotNull
    public static <T extends EventListener> EventDispatcher<T> create(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            EventDispatcher.$$$reportNull$$$0(0);
        }
        return new EventDispatcher<T>(listenerClass, null);
    }

    @NotNull
    public static <T extends EventListener> EventDispatcher<T> create(@NotNull Class<T> listenerClass, @NotNull Map<String, Object> methodReturnValues) {
        if (listenerClass == null) {
            EventDispatcher.$$$reportNull$$$0(1);
        }
        if (methodReturnValues == null) {
            EventDispatcher.$$$reportNull$$$0(2);
        }
        EventDispatcher.assertNonVoidMethodReturnValuesAreDeclared(methodReturnValues, listenerClass);
        return new EventDispatcher<T>(listenerClass, methodReturnValues);
    }

    private static void assertNonVoidMethodReturnValuesAreDeclared(@NotNull Map<String, Object> methodReturnValues, @NotNull Class<?> listenerClass) {
        if (methodReturnValues == null) {
            EventDispatcher.$$$reportNull$$$0(3);
        }
        if (listenerClass == null) {
            EventDispatcher.$$$reportNull$$$0(4);
        }
        ArrayList<Method> declared = new ArrayList<Method>(ReflectionUtil.getClassPublicMethods(listenerClass));
        for (Map.Entry<String, Object> entry : methodReturnValues.entrySet()) {
            String methodName = entry.getKey();
            Method found = (Method)((Object)ContainerUtil.find(declared, m -> methodName.equals(m.getName())));
            assert (found != null) : "Method " + methodName + " must be declared in " + listenerClass;
            assert (!found.getReturnType().equals(Void.TYPE)) : "Method " + methodName + " must be non-void if you want to specify what its proxy should return";
            Object returnValue = entry.getValue();
            assert (ReflectionUtil.boxType(found.getReturnType()).isAssignableFrom(returnValue.getClass())) : "You specified that method " + methodName + " proxy will return " + returnValue + " but its return type is " + found.getReturnType() + " which is incompatible with " + returnValue.getClass();
            declared.remove(found);
        }
        for (Method method : declared) {
            assert (method.getReturnType().equals(Void.TYPE)) : "Method " + method + " returns " + method.getReturnType() + " and yet you didn't specify what its proxy should return";
        }
    }

    private EventDispatcher(@NotNull Class<T> listenerClass, @Nullable Map<String, Object> methodReturnValues) {
        if (listenerClass == null) {
            EventDispatcher.$$$reportNull$$$0(5);
        }
        this.myListeners = new DisposableWrapperList();
        this.myListenerClass = listenerClass;
        this.myMethodReturnValues = methodReturnValues;
    }

    public static <T> T createMulticaster(@NotNull Class<T> listenerClass, @NotNull Supplier<? extends Iterable<T>> listeners) {
        if (listenerClass == null) {
            EventDispatcher.$$$reportNull$$$0(6);
        }
        if (listeners == null) {
            EventDispatcher.$$$reportNull$$$0(7);
        }
        return EventDispatcher.createMulticaster(listenerClass, null, listeners);
    }

    @NotNull
    static <T> T createMulticaster(@NotNull Class<T> listenerClass, @Nullable Map<String, Object> methodReturnValues, @NotNull Supplier<? extends Iterable<T>> listeners) {
        if (listenerClass == null) {
            EventDispatcher.$$$reportNull$$$0(8);
        }
        if (listeners == null) {
            EventDispatcher.$$$reportNull$$$0(9);
        }
        LOG.assertTrue(listenerClass.isInterface(), "listenerClass must be an interface");
        Object object = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, (proxy, method, args) -> {
            String methodName = method.getName();
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                return EventDispatcher.handleObjectMethod(proxy, args, methodName);
            }
            if (methodReturnValues != null && methodReturnValues.containsKey(methodName)) {
                return methodReturnValues.get(methodName);
            }
            EventDispatcher.dispatchVoidMethod((Iterable)listeners.get(), method, args);
            return null;
        });
        if (object == null) {
            EventDispatcher.$$$reportNull$$$0(10);
        }
        return (T)object;
    }

    @Nullable
    public static Object handleObjectMethod(Object proxy, Object[] args, String methodName) {
        switch (methodName) {
            case "toString": {
                return "Multicaster";
            }
            case "hashCode": {
                return System.identityHashCode(proxy);
            }
            case "equals": {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        LOG.error("Incorrect Object's method invoked for proxy:" + methodName);
        return null;
    }

    @NotNull
    public T getMulticaster() {
        Object multicaster = this.myMulticaster;
        if (multicaster == null) {
            this.myMulticaster = multicaster = (EventListener)EventDispatcher.createMulticaster(this.myListenerClass, this.myMethodReturnValues, () -> this.myListeners);
        }
        T t = multicaster;
        if (t == null) {
            EventDispatcher.$$$reportNull$$$0(11);
        }
        return t;
    }

    private static <T> void dispatchVoidMethod(@NotNull Iterable<? extends T> listeners, @NotNull Method method, Object[] args) {
        if (listeners == null) {
            EventDispatcher.$$$reportNull$$$0(12);
        }
        if (method == null) {
            EventDispatcher.$$$reportNull$$$0(13);
        }
        List<Throwable> exceptions = null;
        method.setAccessible(true);
        for (T listener2 : listeners) {
            try {
                method.invoke(listener2, args);
            }
            catch (Throwable e) {
                exceptions = EventDispatcher.handleException(e, exceptions);
            }
        }
        if (exceptions != null) {
            EventDispatcher.throwExceptions(exceptions);
        }
    }

    @Nullable
    public static List<Throwable> handleException(@NotNull Throwable e, @Nullable List<Throwable> exceptions) {
        Throwable cause;
        if (e == null) {
            EventDispatcher.$$$reportNull$$$0(14);
        }
        Throwable exception = e;
        if (e instanceof InvocationTargetException && (cause = e.getCause()) != null) {
            if (cause instanceof AbstractMethodError) {
                return exceptions;
            }
            exception = cause;
        }
        if (exceptions == null) {
            exceptions = new ArrayList<Throwable>();
        }
        exceptions.add(exception);
        return exceptions;
    }

    public static void throwExceptions(@NotNull List<? extends Throwable> exceptions) {
        if (exceptions == null) {
            EventDispatcher.$$$reportNull$$$0(15);
        }
        if (exceptions.size() != 1) {
            for (Throwable throwable : exceptions) {
                if (!(throwable instanceof ProcessCanceledException)) continue;
                throw (ProcessCanceledException)throwable;
            }
            throw new CompoundRuntimeException(exceptions);
        }
        ExceptionUtil.rethrow(exceptions.get(0));
    }

    public void addListener(@NotNull T listener2) {
        if (listener2 == null) {
            EventDispatcher.$$$reportNull$$$0(16);
        }
        this.myListeners.add(listener2);
    }

    public void addListener(@NotNull T listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            EventDispatcher.$$$reportNull$$$0(17);
        }
        if (parentDisposable == null) {
            EventDispatcher.$$$reportNull$$$0(18);
        }
        this.myListeners.add(listener2, parentDisposable);
    }

    public void removeListener(@NotNull T listener2) {
        if (listener2 == null) {
            EventDispatcher.$$$reportNull$$$0(19);
        }
        this.myListeners.remove(listener2);
    }

    public boolean hasListeners() {
        return !this.myListeners.isEmpty();
    }

    @NotNull
    public List<T> getListeners() {
        DisposableWrapperList<T> disposableWrapperList = this.myListeners;
        if (disposableWrapperList == null) {
            EventDispatcher.$$$reportNull$$$0(20);
        }
        return disposableWrapperList;
    }

    @TestOnly
    public void neuterMultiCasterWhilePerformanceTestIsRunningUntil(@NotNull Disposable disposable) {
        if (disposable == null) {
            EventDispatcher.$$$reportNull$$$0(21);
        }
        T multicaster = this.myMulticaster;
        this.myMulticaster = (EventListener)EventDispatcher.createMulticaster(this.myListenerClass, this.myMethodReturnValues, () -> Collections.emptyList());
        Disposer.register(disposable, () -> {
            this.myMulticaster = multicaster;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReturnValues";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 10: 
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/EventDispatcher";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/EventDispatcher";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createMulticaster";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMulticaster";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "assertNonVoidMethodReturnValuesAreDeclared";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createMulticaster";
                break;
            }
            case 10: 
            case 11: 
            case 20: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "dispatchVoidMethod";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "handleException";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "throwExceptions";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "neuterMultiCasterWhilePerformanceTestIsRunningUntil";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 11: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

