/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util;

import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.command.CommandProcessor;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.org.jetbrains.annotations.NotNull;

public final class DocumentUtil {
    private DocumentUtil() {
    }

    public static void executeInBulk(@NotNull Document document2, boolean executeInBulk, @NotNull Runnable task) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(0);
        }
        if (task == null) {
            DocumentUtil.$$$reportNull$$$0(1);
        }
        if (executeInBulk == document2.isInBulkUpdate()) {
            task.run();
            return;
        }
        document2.setInBulkUpdate(executeInBulk);
        try {
            task.run();
            document2.setInBulkUpdate(!executeInBulk);
        }
        catch (Throwable throwable) {
            document2.setInBulkUpdate(!executeInBulk);
            throw throwable;
        }
    }

    public static void executeInBulk(@NotNull Document document2, @NotNull Runnable task) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(2);
        }
        if (task == null) {
            DocumentUtil.$$$reportNull$$$0(3);
        }
        DocumentUtil.executeInBulk(document2, true, task);
    }

    public static void writeInRunUndoTransparentAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            DocumentUtil.$$$reportNull$$$0(4);
        }
        CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(runnable));
    }

    public static int getFirstNonSpaceCharOffset(@NotNull Document document2, int line) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(5);
        }
        int startOffset = document2.getLineStartOffset(line);
        int endOffset = document2.getLineEndOffset(line);
        return DocumentUtil.getFirstNonSpaceCharOffset(document2, startOffset, endOffset);
    }

    public static int getFirstNonSpaceCharOffset(@NotNull Document document2, int startOffset, int endOffset) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(6);
        }
        CharSequence text = document2.getImmutableCharSequence();
        for (int i = startOffset; i < endOffset; ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return i;
        }
        return startOffset;
    }

    public static boolean isValidOffset(int offset, @NotNull Document document2) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(7);
        }
        return offset >= 0 && offset <= document2.getTextLength();
    }

    public static int getLineStartOffset(int offset, @NotNull Document document2) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(8);
        }
        if (offset < 0 || offset > document2.getTextLength()) {
            return offset;
        }
        int lineNumber = document2.getLineNumber(offset);
        return document2.getLineStartOffset(lineNumber);
    }

    public static int getLineEndOffset(int offset, @NotNull Document document2) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(9);
        }
        if (offset < 0 || offset > document2.getTextLength()) {
            return offset;
        }
        int lineNumber = document2.getLineNumber(offset);
        return document2.getLineEndOffset(lineNumber);
    }

    @NotNull
    public static TextRange getLineTextRange(@NotNull Document document2, int line) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(10);
        }
        TextRange textRange = TextRange.create(document2.getLineStartOffset(line), document2.getLineEndOffset(line));
        if (textRange == null) {
            DocumentUtil.$$$reportNull$$$0(11);
        }
        return textRange;
    }

    public static boolean isAtLineStart(int offset, @NotNull Document document2) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(12);
        }
        return offset >= 0 && offset <= document2.getTextLength() && offset == document2.getLineStartOffset(document2.getLineNumber(offset));
    }

    public static boolean isAtLineEnd(int offset, @NotNull Document document2) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(13);
        }
        return offset >= 0 && offset <= document2.getTextLength() && offset == document2.getLineEndOffset(document2.getLineNumber(offset));
    }

    public static int alignToCodePointBoundary(@NotNull Document document2, int offset) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(14);
        }
        return DocumentUtil.isInsideSurrogatePair(document2, offset) ? offset - 1 : offset;
    }

    public static boolean isSurrogatePair(@NotNull Document document2, int offset) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(15);
        }
        CharSequence text = document2.getImmutableCharSequence();
        return offset >= 0 && offset + 1 < text.length() && Character.isHighSurrogate(text.charAt(offset)) && Character.isLowSurrogate(text.charAt(offset + 1));
    }

    public static boolean isInsideSurrogatePair(@NotNull Document document2, int offset) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(16);
        }
        return DocumentUtil.isSurrogatePair(document2, offset - 1);
    }

    public static int getPreviousCodePointOffset(@NotNull Document document2, int offset) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(17);
        }
        return offset - (DocumentUtil.isSurrogatePair(document2, offset - 2) ? 2 : 1);
    }

    public static int getNextCodePointOffset(@NotNull Document document2, int offset) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(18);
        }
        return offset + (DocumentUtil.isSurrogatePair(document2, offset) ? 2 : 1);
    }

    public static boolean isInsideCharacterPair(@NotNull Document document2, int offset) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(19);
        }
        if (offset <= 0 || offset >= document2.getTextLength()) {
            return false;
        }
        CharSequence text = document2.getImmutableCharSequence();
        char prev = text.charAt(offset - 1);
        return prev == '\r' ? text.charAt(offset) == '\n' : Character.isHighSurrogate(prev) && Character.isLowSurrogate(text.charAt(offset));
    }

    public static boolean isLineEmpty(@NotNull Document document2, int line) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(20);
        }
        CharSequence chars = document2.getCharsSequence();
        int start = document2.getLineStartOffset(line);
        int end = Math.min(document2.getLineEndOffset(line), document2.getTextLength() - 1);
        for (int i = start; i <= end; ++i) {
            if (Character.isWhitespace(chars.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static CharSequence getIndent(@NotNull Document document2, int offset) {
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(21);
        }
        int lineOffset = DocumentUtil.getLineStartOffset(offset, document2);
        int result2 = 0;
        while (lineOffset + result2 < document2.getTextLength() && Character.isWhitespace(document2.getCharsSequence().charAt(lineOffset + result2))) {
            ++result2;
        }
        if (result2 + lineOffset > document2.getTextLength()) {
            --result2;
        }
        return document2.getCharsSequence().subSequence(lineOffset, lineOffset + Math.max(result2, 0));
    }

    public static int calculateOffset(@NotNull Document document2, int line, int column, int tabSize) {
        int offset;
        if (document2 == null) {
            DocumentUtil.$$$reportNull$$$0(22);
        }
        if (0 <= line && line < document2.getLineCount()) {
            int lineStart = document2.getLineStartOffset(line);
            int lineEnd = document2.getLineEndOffset(line);
            CharSequence docText = document2.getCharsSequence();
            offset = lineStart;
            for (int col = 0; offset < lineEnd && col < column; col += docText.charAt(offset) == '\t' ? tabSize : 1, ++offset) {
            }
        } else {
            offset = document2.getTextLength();
        }
        return offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/DocumentUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/DocumentUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeInBulk";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeInRunUndoTransparentAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFirstNonSpaceCharOffset";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isValidOffset";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLineStartOffset";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLineEndOffset";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLineTextRange";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAtLineStart";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAtLineEnd";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "alignToCodePointBoundary";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSurrogatePair";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInsideSurrogatePair";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousCodePointOffset";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNextCodePointOffset";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isInsideCharacterPair";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isLineEmpty";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "calculateOffset";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

