/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.backend;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import ksp.org.jetbrains.kotlin.fir.backend.utils.InjectedValue;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.ir.IrBuiltIns;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.overrides.IrExternalOverridabilityCondition;
import ksp.org.jetbrains.kotlin.ir.util.SymbolTable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001&J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H&J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH&J\u0018\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH&J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006'\u00c0\u0006\u0001"}, d2={"Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "", "irNeedsDeserialization", "", "getIrNeedsDeserialization", "()Z", "parametersAreAssignable", "getParametersAreAssignable", "externalOverridabilityConditions", "", "Lksp/org/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition;", "getExternalOverridabilityConditions", "()Ljava/util/List;", "deserializeToplevelClass", "irClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "components", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "findInjectedValue", "Lksp/org/jetbrains/kotlin/fir/backend/utils/InjectedValue;", "calleeReference", "Lksp/org/jetbrains/kotlin/fir/references/FirReference;", "conversionScope", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "hasBackingField", "property", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "isTrueStatic", "declaration", "Lksp/org/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "initializeIrBuiltInsAndSymbolTable", "", "irBuiltIns", "Lksp/org/jetbrains/kotlin/ir/IrBuiltIns;", "symbolTable", "Lksp/org/jetbrains/kotlin/ir/util/SymbolTable;", "Default", "fir2ir"})
public interface Fir2IrExtensions {
    public boolean getIrNeedsDeserialization();

    public boolean getParametersAreAssignable();

    @NotNull
    public List<IrExternalOverridabilityCondition> getExternalOverridabilityConditions();

    public boolean deserializeToplevelClass(@NotNull IrClass var1, @NotNull Fir2IrComponents var2);

    @Nullable
    public InjectedValue findInjectedValue(@NotNull FirReference var1, @NotNull Fir2IrConversionScope var2);

    public boolean hasBackingField(@NotNull FirProperty var1, @NotNull FirSession var2);

    public boolean isTrueStatic(@NotNull FirCallableDeclaration var1, @NotNull FirSession var2);

    public void initializeIrBuiltInsAndSymbolTable(@NotNull IrBuiltIns var1, @NotNull SymbolTable var2);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrExtensions$Default;", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "<init>", "()V", "irNeedsDeserialization", "", "getIrNeedsDeserialization", "()Z", "parametersAreAssignable", "getParametersAreAssignable", "externalOverridabilityConditions", "", "Lksp/org/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition;", "getExternalOverridabilityConditions", "()Ljava/util/List;", "deserializeToplevelClass", "irClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "components", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "findInjectedValue", "", "calleeReference", "Lksp/org/jetbrains/kotlin/fir/references/FirReference;", "conversionScope", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "hasBackingField", "property", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "isTrueStatic", "declaration", "Lksp/org/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "initializeIrBuiltInsAndSymbolTable", "", "irBuiltIns", "Lksp/org/jetbrains/kotlin/ir/IrBuiltIns;", "symbolTable", "Lksp/org/jetbrains/kotlin/ir/util/SymbolTable;", "fir2ir"})
    public static final class Default
    implements Fir2IrExtensions {
        @NotNull
        public static final Default INSTANCE = new Default();
        @NotNull
        private static final List<IrExternalOverridabilityCondition> externalOverridabilityConditions = CollectionsKt.emptyList();

        private Default() {
        }

        @Override
        public boolean getIrNeedsDeserialization() {
            return false;
        }

        @Override
        public boolean getParametersAreAssignable() {
            return false;
        }

        @Override
        @NotNull
        public List<IrExternalOverridabilityCondition> getExternalOverridabilityConditions() {
            return externalOverridabilityConditions;
        }

        @Override
        public boolean deserializeToplevelClass(@NotNull IrClass irClass, @NotNull Fir2IrComponents components) {
            Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
            Intrinsics.checkNotNullParameter((Object)components, (String)"components");
            return false;
        }

        @Nullable
        public Void findInjectedValue(@NotNull FirReference calleeReference, @NotNull Fir2IrConversionScope conversionScope) {
            Intrinsics.checkNotNullParameter((Object)calleeReference, (String)"calleeReference");
            Intrinsics.checkNotNullParameter((Object)conversionScope, (String)"conversionScope");
            return null;
        }

        @Override
        public boolean hasBackingField(@NotNull FirProperty property, @NotNull FirSession session) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            return DeclarationAttributesKt.getHasBackingField(property);
        }

        @Override
        public boolean isTrueStatic(@NotNull FirCallableDeclaration declaration2, @NotNull FirSession session) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            return false;
        }

        @Override
        public void initializeIrBuiltInsAndSymbolTable(@NotNull IrBuiltIns irBuiltIns, @NotNull SymbolTable symbolTable) {
            Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
            Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        }
    }
}

