/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.caches;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirInternals;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.caches.SoftReferenceWithCleanup;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.caches.SoftValueCleaner;

@LLFirInternals
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B!\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0011\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0012J'\u0010\u0013\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00028\u00002\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0015J3\u0010\u0016\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0011\u001a\u00028\u00002\u001c\u0010\u0014\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018J\u001d\u0010\u0019\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u001d\u001a\u00020\u000fJ\u0006\u0010\"\u001a\u00020#J\b\u0010(\u001a\u00020)H\u0016J)\u0010*\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010+J\u0018\u0010,\u001a\u00020\u000f*\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bH\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006-"}, d2={"Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache;", "K", "", "V", "getCleaner", "Lkotlin/Function1;", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/caches/SoftValueCleaner;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "backingMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/caches/SoftReferenceWithCleanup;", "referenceQueue", "Ljava/lang/ref/ReferenceQueue;", "processQueue", "", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "computeIfAbsent", "computeValue", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "compute", "Lkotlin/Function2;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "clear", "size", "", "getSize", "()I", "isEmpty", "", "keys", "", "getKeys", "()Ljava/util/Set;", "toString", "", "createSoftReference", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/SoftReferenceWithCleanup;", "performCleanup", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nCleanableSoftValueCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CleanableSoftValueCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,282:1\n1#2:283\n1863#3,2:284\n*S KotlinDebug\n*F\n+ 1 CleanableSoftValueCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache\n*L\n210#1:284,2\n*E\n"})
public final class CleanableSoftValueCache<K, V> {
    @NotNull
    private final Function1<V, SoftValueCleaner<V>> getCleaner;
    @NotNull
    private final ConcurrentHashMap<K, SoftReferenceWithCleanup<K, V>> backingMap;
    @NotNull
    private final ReferenceQueue<V> referenceQueue;

    public CleanableSoftValueCache(@NotNull Function1<? super V, ? extends SoftValueCleaner<V>> getCleaner) {
        Intrinsics.checkNotNullParameter(getCleaner, (String)"getCleaner");
        this.getCleaner = getCleaner;
        this.backingMap = new ConcurrentHashMap();
        this.referenceQueue = new ReferenceQueue();
    }

    private final void processQueue() {
        while (this.referenceQueue.poll() != null) {
            Reference<V> ref;
            if (!(ref instanceof SoftReferenceWithCleanup)) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            SoftReferenceWithCleanup cfr_ignored_0 = (SoftReferenceWithCleanup)ref;
            boolean wasRemoved = this.backingMap.remove(((SoftReferenceWithCleanup)ref).getKey(), ref);
            if (!wasRemoved) continue;
            this.performCleanup((SoftReferenceWithCleanup)ref);
        }
    }

    @Nullable
    public final V get(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        SoftReferenceWithCleanup<K, V> softReferenceWithCleanup = this.backingMap.get(key);
        return (V)(softReferenceWithCleanup != null ? softReferenceWithCleanup.get() : null);
    }

    @NotNull
    public final V computeIfAbsent(@NotNull K key, @NotNull Function1<? super K, ? extends V> computeValue) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(computeValue, (String)"computeValue");
        V v = this.get(key);
        if (v != null) {
            V it = v;
            boolean bl = false;
            return it;
        }
        V v2 = this.compute(key, (arg_0, arg_1) -> CleanableSoftValueCache.computeIfAbsent$lambda$1(computeValue, key, arg_0, arg_1));
        if (v2 == null) {
            throw new IllegalStateException("`computeIfAbsent` should always return a non-null value.".toString());
        }
        return v2;
    }

    @Nullable
    public final V compute(@NotNull K key, @NotNull Function2<? super K, ? super V, ? extends V> computeValue) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(computeValue, (String)"computeValue");
        Ref.ObjectRef newValue = new Ref.ObjectRef();
        Ref.ObjectRef removedRef = new Ref.ObjectRef();
        SoftReferenceWithCleanup newRef = this.backingMap.compute(key, (arg_0, arg_1) -> CleanableSoftValueCache.compute$lambda$3((arg_0, arg_1) -> CleanableSoftValueCache.compute$lambda$2(newValue, computeValue, key, removedRef, this, arg_0, arg_1), arg_0, arg_1));
        SoftReferenceWithCleanup softReferenceWithCleanup = (SoftReferenceWithCleanup)removedRef.element;
        if (softReferenceWithCleanup != null) {
            this.performCleanup(softReferenceWithCleanup);
        }
        this.processQueue();
        SoftReferenceWithCleanup softReferenceWithCleanup2 = newRef;
        if (!((softReferenceWithCleanup2 != null ? softReferenceWithCleanup2.get() : null) == newValue.element)) {
            boolean bl = false;
            String string2 = "The newly computed value was already garbage-collected before the end of the `compute` function.";
            throw new IllegalArgumentException(string2.toString());
        }
        return (V)newValue.element;
    }

    @Nullable
    public final V put(@NotNull K key, @NotNull V value2) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Ref.ObjectRef oldValue = new Ref.ObjectRef();
        Ref.ObjectRef removedRef = new Ref.ObjectRef();
        this.backingMap.compute(key, (arg_0, arg_1) -> CleanableSoftValueCache.put$lambda$6((arg_0, arg_1) -> CleanableSoftValueCache.put$lambda$5(oldValue, value2, removedRef, this, key, arg_0, arg_1), arg_0, arg_1));
        SoftReferenceWithCleanup softReferenceWithCleanup = (SoftReferenceWithCleanup)removedRef.element;
        if (softReferenceWithCleanup != null) {
            this.performCleanup(softReferenceWithCleanup);
        }
        this.processQueue();
        return (V)oldValue.element;
    }

    @Nullable
    public final V remove(@NotNull K key) {
        SoftReferenceWithCleanup<K, V> ref;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        SoftReferenceWithCleanup<K, V> softReferenceWithCleanup = ref = this.backingMap.remove(key);
        if (softReferenceWithCleanup != null) {
            this.performCleanup(softReferenceWithCleanup);
        }
        this.processQueue();
        SoftReferenceWithCleanup<K, V> softReferenceWithCleanup2 = ref;
        return (V)(softReferenceWithCleanup2 != null ? softReferenceWithCleanup2.get() : null);
    }

    public final void clear() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Collection<SoftReferenceWithCleanup<K, V>> collection = this.backingMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SoftReferenceWithCleanup it = (SoftReferenceWithCleanup)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.performCleanup(it);
        }
        this.backingMap.clear();
        this.processQueue();
    }

    public final int getSize() {
        this.processQueue();
        return this.backingMap.size();
    }

    public final boolean isEmpty() {
        this.processQueue();
        return this.backingMap.isEmpty();
    }

    @NotNull
    public final Set<K> getKeys() {
        this.processQueue();
        Set set = this.backingMap.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return CollectionsKt.toSet((Iterable)set);
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + " size:" + this.getSize();
    }

    private final SoftReferenceWithCleanup<K, V> createSoftReference(K key, V value2) {
        return new SoftReferenceWithCleanup<K, V>(key, value2, (SoftValueCleaner)this.getCleaner.invoke(value2), this.referenceQueue);
    }

    private final void performCleanup(SoftReferenceWithCleanup<K, V> $this$performCleanup) {
        $this$performCleanup.getCleaner().cleanUp($this$performCleanup.get());
    }

    private static final Object computeIfAbsent$lambda$1(Function1 $computeValue, Object $key, Object object, Object currentValue) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<unused var>");
        Object object2 = currentValue;
        if (object2 == null) {
            object2 = $computeValue.invoke($key);
        }
        return object2;
    }

    private static final SoftReferenceWithCleanup compute$lambda$2(Ref.ObjectRef $newValue, Function2 $computeValue, Object $key, Ref.ObjectRef $removedRef, CleanableSoftValueCache this$0, Object object, SoftReferenceWithCleanup currentRef) {
        SoftReferenceWithCleanup<Object, Object> softReferenceWithCleanup;
        Intrinsics.checkNotNullParameter((Object)object, (String)"<unused var>");
        SoftReferenceWithCleanup<Object, Object> softReferenceWithCleanup2 = currentRef;
        Object currentValue = softReferenceWithCleanup2 != null ? softReferenceWithCleanup2.get() : null;
        $newValue.element = $computeValue.invoke($key, currentValue);
        if ($newValue.element == null) {
            $removedRef.element = currentRef;
            softReferenceWithCleanup = null;
        } else if ($newValue.element == currentValue) {
            softReferenceWithCleanup = currentRef;
        } else {
            $removedRef.element = currentRef;
            Object object2 = $newValue.element;
            Intrinsics.checkNotNull((Object)object2);
            softReferenceWithCleanup = this$0.createSoftReference($key, object2);
        }
        return softReferenceWithCleanup;
    }

    private static final SoftReferenceWithCleanup compute$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return (SoftReferenceWithCleanup)$tmp0.invoke(p0, p1);
    }

    private static final SoftReferenceWithCleanup put$lambda$5(Ref.ObjectRef $oldValue, Object $value, Ref.ObjectRef $removedRef, CleanableSoftValueCache this$0, Object $key, Object object, SoftReferenceWithCleanup currentRef) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<unused var>");
        SoftReferenceWithCleanup softReferenceWithCleanup = currentRef;
        Object currentValue = softReferenceWithCleanup != null ? softReferenceWithCleanup.get() : null;
        $oldValue.element = currentValue;
        if ($value == currentValue) {
            return currentRef;
        }
        $removedRef.element = currentRef;
        return this$0.createSoftReference($key, $value);
    }

    private static final SoftReferenceWithCleanup put$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        return (SoftReferenceWithCleanup)$tmp0.invoke(p0, p1);
    }
}

