/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/SealedInterfaceAllowedChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class SealedInterfaceAllowedChecker
implements DeclarationChecker {
    @NotNull
    public static final SealedInterfaceAllowedChecker INSTANCE = new SealedInterfaceAllowedChecker();

    private SealedInterfaceAllowedChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        ParametrizedDiagnostic parametrizedDiagnostic;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor instanceof ClassDescriptor)) {
            return;
        }
        if (((ClassDescriptor)descriptor).getKind() != ClassKind.INTERFACE) {
            return;
        }
        PsiElement psiElement = declaration2.getModifierList();
        if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.SEALED_KEYWORD)) == null) {
            return;
        }
        PsiElement keyword = psiElement;
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.SealedInterfaces)) {
            if (!((ClassDescriptor)descriptor).isFun()) {
                return;
            }
            parametrizedDiagnostic = Errors.UNSUPPORTED_SEALED_FUN_INTERFACE.on(keyword);
        } else {
            parametrizedDiagnostic = Errors.UNSUPPORTED_FEATURE.on(keyword, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.SealedInterfaces), (Object)context2.getLanguageVersionSettings()));
        }
        ParametrizedDiagnostic parametrizedDiagnostic2 = parametrizedDiagnostic;
        Intrinsics.checkNotNull((Object)parametrizedDiagnostic2);
        ParametrizedDiagnostic diagnostic = parametrizedDiagnostic2;
        context2.getTrace().report(diagnostic);
    }
}

