/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FieldDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.Annotations;
import ksp.org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/MultiFieldValueClassAnnotationsChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "report", "", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "name", "", "type", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "annotationEntry", "Lksp/org/jetbrains/kotlin/psi/KtAnnotationEntry;", "check", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "frontend"})
@SourceDebugExtension(value={"SMAP\nMultiFieldValueClassAnnotationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiFieldValueClassAnnotationsChecker.kt\norg/jetbrains/kotlin/resolve/checkers/MultiFieldValueClassAnnotationsChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1#2:66\n1863#3,2:67\n1863#3,2:69\n1863#3,2:71\n*S KotlinDebug\n*F\n+ 1 MultiFieldValueClassAnnotationsChecker.kt\norg/jetbrains/kotlin/resolve/checkers/MultiFieldValueClassAnnotationsChecker\n*L\n51#1:67,2\n59#1:69,2\n60#1:71,2\n*E\n"})
public final class MultiFieldValueClassAnnotationsChecker
implements DeclarationChecker {
    @NotNull
    public static final MultiFieldValueClassAnnotationsChecker INSTANCE = new MultiFieldValueClassAnnotationsChecker();

    private MultiFieldValueClassAnnotationsChecker() {
    }

    private final void report(DeclarationCheckerContext context2, String name2, KotlinType type2, KtAnnotationEntry annotationEntry2) {
        if (!InlineClassesUtilsKt.needsMfvcFlattening(type2)) {
            return;
        }
        context2.getTrace().report(Errors.ANNOTATION_ON_ILLEGAL_MULTI_FIELD_VALUE_CLASS_TYPED_TARGET.on((KtAnnotationEntry)((PsiElement)annotationEntry2), name2));
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        block15: {
            ParameterDescriptor it;
            DeclarationDescriptor declarationDescriptor;
            block16: {
                block14: {
                    Object it2;
                    Object object;
                    KotlinType kotlinType;
                    KtExpression ktExpression;
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    declarationDescriptor = descriptor;
                    if (!(declarationDescriptor instanceof PropertyDescriptor)) break block14;
                    FieldDescriptor fieldDescriptor = ((PropertyDescriptor)descriptor).getBackingField();
                    if (fieldDescriptor != null) {
                        FieldDescriptor it3 = fieldDescriptor;
                        boolean bl = false;
                        KotlinType kotlinType2 = ((PropertyDescriptor)descriptor).getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
                        MultiFieldValueClassAnnotationsChecker.check$report(context2, "fields", kotlinType2, it3.getAnnotations());
                    }
                    if ((ktExpression = declaration2 instanceof KtProperty ? (KtProperty)declaration2 : null) != null && (ktExpression = ktExpression.getDelegateExpression()) != null) {
                        BindingContext bindingContext = context2.getTrace().getBindingContext();
                        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                        kotlinType = CallUtilKt.getType(ktExpression, bindingContext);
                    } else {
                        kotlinType = null;
                    }
                    KotlinType delegateType = kotlinType;
                    FieldDescriptor fieldDescriptor2 = ((PropertyDescriptor)descriptor).getDelegateField();
                    if (fieldDescriptor2 != null) {
                        FieldDescriptor it4 = fieldDescriptor2;
                        boolean bl = false;
                        if (delegateType != null) {
                            MultiFieldValueClassAnnotationsChecker.check$report(context2, "delegate fields", delegateType, it4.getAnnotations());
                        }
                    }
                    PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)descriptor).getGetter();
                    if (propertyGetterDescriptor != null) {
                        PropertyGetterDescriptor getterDescriptor = propertyGetterDescriptor;
                        boolean bl = false;
                        List<ReceiverParameterDescriptor> list = getterDescriptor.getContextReceiverParameters();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"getContextReceiverParameters(...)");
                        if (!(!((Collection)list).isEmpty()) && getterDescriptor.getExtensionReceiverParameter() == null) {
                            KotlinType kotlinType3 = getterDescriptor.getReturnType();
                            if (kotlinType3 != null) {
                                KotlinType type2 = kotlinType3;
                                MultiFieldValueClassAnnotationsChecker.check$report(context2, "getters", type2, getterDescriptor.getAnnotations());
                            }
                        }
                    }
                    if ((object = ((PropertyDescriptor)descriptor).getSetter()) != null && (object = object.getValueParameters()) != null && (object = (ValueParameterDescriptor)CollectionsKt.single((List)object)) != null) {
                        it2 = object;
                        boolean bl = false;
                        KotlinType kotlinType4 = it2.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType4, (String)"getType(...)");
                        MultiFieldValueClassAnnotationsChecker.check$report(context2, "parameters", kotlinType4, it2.getAnnotations());
                    }
                    ReceiverParameterDescriptor receiverParameterDescriptor = ((PropertyDescriptor)descriptor).getExtensionReceiverParameter();
                    if (receiverParameterDescriptor != null) {
                        ReceiverParameterDescriptor it5 = receiverParameterDescriptor;
                        boolean bl = false;
                        KotlinType kotlinType5 = it5.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType5, (String)"getType(...)");
                        MultiFieldValueClassAnnotationsChecker.check$report(context2, "receivers", kotlinType5, it5.getAnnotations());
                    }
                    List<ReceiverParameterDescriptor> list = ((PropertyDescriptor)descriptor).getContextReceiverParameters();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getContextReceiverParameters(...)");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it2 = (ReceiverParameterDescriptor)element$iv;
                        boolean bl = false;
                        KotlinType kotlinType6 = it2.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType6, (String)"getType(...)");
                        MultiFieldValueClassAnnotationsChecker.check$report(context2, "receivers", kotlinType6, it2.getAnnotations());
                    }
                    break block15;
                }
                if (declarationDescriptor instanceof PropertyAccessorDescriptor) break block15;
                if (!(declarationDescriptor instanceof LocalVariableDescriptor)) break block16;
                KotlinType kotlinType = ((LocalVariableDescriptor)descriptor).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                Annotations annotations2 = ((LocalVariableDescriptor)descriptor).getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)annotations2, (String)"<get-annotations>(...)");
                MultiFieldValueClassAnnotationsChecker.check$report(context2, "variables", kotlinType, annotations2);
                break block15;
            }
            if (!(declarationDescriptor instanceof CallableDescriptor)) break block15;
            ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)descriptor).getExtensionReceiverParameter();
            if (receiverParameterDescriptor != null) {
                ReceiverParameterDescriptor it6 = receiverParameterDescriptor;
                boolean bl = false;
                KotlinType kotlinType = it6.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                MultiFieldValueClassAnnotationsChecker.check$report(context2, "receivers", kotlinType, it6.getAnnotations());
            }
            List<ReceiverParameterDescriptor> list = ((CallableDescriptor)descriptor).getContextReceiverParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getContextReceiverParameters(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ReceiverParameterDescriptor)element$iv;
                boolean bl = false;
                KotlinType kotlinType = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                MultiFieldValueClassAnnotationsChecker.check$report(context2, "receivers", kotlinType, it.getAnnotations());
            }
            List<ValueParameterDescriptor> list2 = ((CallableDescriptor)descriptor).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ValueParameterDescriptor)element$iv;
                boolean bl = false;
                KotlinType kotlinType = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                MultiFieldValueClassAnnotationsChecker.check$report(context2, "parameters", kotlinType, it.getAnnotations());
            }
        }
    }

    private static final void check$report(DeclarationCheckerContext $context, String name2, KotlinType type2, Annotations annotations2) {
        for (AnnotationDescriptor annotationDescriptor : annotations2) {
            PsiElement psiElement = PsiSourceElementKt.getPsi(annotationDescriptor.getSource());
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
            INSTANCE.report($context, name2, type2, (KtAnnotationEntry)psiElement);
        }
    }
}

