/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve;

import java.util.Collection;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.util.SmartFMap;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.diagnostics.Diagnostic;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import ksp.org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class ObservableBindingTrace
implements BindingTrace {
    private final BindingTrace originalTrace;
    private SmartFMap<WritableSlice, RecordHandler> handlers = SmartFMap.emptyMap();

    public ObservableBindingTrace(BindingTrace originalTrace) {
        this.originalTrace = originalTrace;
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            ObservableBindingTrace.$$$reportNull$$$0(0);
        }
        this.originalTrace.report(diagnostic);
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.originalTrace.getBindingContext();
        if (bindingContext == null) {
            ObservableBindingTrace.$$$reportNull$$$0(1);
        }
        return bindingContext;
    }

    @Override
    public <K, V> void record(WritableSlice<K, V> slice, K key, V value2) {
        this.originalTrace.record(slice, key, value2);
        RecordHandler recordHandler = this.handlers.get(slice);
        if (recordHandler != null) {
            recordHandler.handleRecord(slice, key, value2);
        }
    }

    @Override
    public <K> void record(WritableSlice<K, Boolean> slice, K key) {
        this.record(slice, key, true);
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        return this.originalTrace.get(slice, key);
    }

    @Override
    @NotNull
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        Collection<K> collection = this.originalTrace.getKeys(slice);
        if (collection == null) {
            ObservableBindingTrace.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Override
    @Nullable
    public KotlinType getType(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            ObservableBindingTrace.$$$reportNull$$$0(3);
        }
        return this.originalTrace.getType(expression2);
    }

    @Override
    public void recordType(@NotNull KtExpression expression2, @Nullable KotlinType type2) {
        if (expression2 == null) {
            ObservableBindingTrace.$$$reportNull$$$0(4);
        }
        this.originalTrace.recordType(expression2, type2);
    }

    public <K, V> ObservableBindingTrace addHandler(@NotNull WritableSlice<K, V> slice, @NotNull RecordHandler<K, V> handler2) {
        if (slice == null) {
            ObservableBindingTrace.$$$reportNull$$$0(5);
        }
        if (handler2 == null) {
            ObservableBindingTrace.$$$reportNull$$$0(6);
        }
        this.handlers = this.handlers.plus(slice, handler2);
        return this;
    }

    @Override
    public boolean wantsDiagnostics() {
        return this.originalTrace.wantsDiagnostics();
    }

    public String toString() {
        return "ObservableTrace over " + this.originalTrace.toString();
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.originalTrace.getProject();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/resolve/ObservableBindingTrace";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slice";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/resolve/ObservableBindingTrace";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "recordType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addHandler";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface RecordHandler<K, V> {
        public void handleRecord(WritableSlice<K, V> var1, K var2, V var3);
    }
}

