/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.inline;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.ir.Symbols;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\u0005*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/ir/inline/InlineFunctionResolver;", "", "<init>", "()V", "allowExternalInlining", "", "getAllowExternalInlining", "()Z", "needsInlining", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "getNeedsInlining", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "getFunctionDeclaration", "symbol", "Lksp/org/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "shouldExcludeFunctionFromInlining", "Companion", "ir.inline"})
public abstract class InlineFunctionResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final InlineFunctionResolver TRIVIAL = new InlineFunctionResolver(){};

    public boolean getAllowExternalInlining() {
        return false;
    }

    private final boolean getNeedsInlining(IrFunction $this$needsInlining) {
        return $this$needsInlining.isInline() && (this.getAllowExternalInlining() || !$this$needsInlining.isExternal());
    }

    @Nullable
    public IrFunction getFunctionDeclaration(@NotNull IrFunctionSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (this.shouldExcludeFunctionFromInlining(symbol)) {
            return null;
        }
        IrFunction owner = symbol.getOwner();
        IrSimpleFunction irSimpleFunction = owner instanceof IrSimpleFunction ? (IrSimpleFunction)owner : null;
        return irSimpleFunction != null && (irSimpleFunction = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default(irSimpleFunction, null, 1, null)) != null ? (IrFunction)irSimpleFunction : owner;
    }

    protected boolean shouldExcludeFunctionFromInlining(@NotNull IrFunctionSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        return !this.getNeedsInlining(symbol.getOwner()) || Symbols.Companion.isLateinitIsInitializedPropertyGetter(symbol) || Symbols.Companion.isTypeOfIntrinsic(symbol);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lksp/org/jetbrains/kotlin/ir/inline/InlineFunctionResolver$Companion;", "", "<init>", "()V", "TRIVIAL", "Lksp/org/jetbrains/kotlin/ir/inline/InlineFunctionResolver;", "getTRIVIAL", "()Lorg/jetbrains/kotlin/ir/inline/InlineFunctionResolver;", "ir.inline"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InlineFunctionResolver getTRIVIAL() {
            return TRIVIAL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

