/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import ksp.org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import ksp.org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001:\u0002\u000f\u0010B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunInterfaceDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "mppKind", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "Regular", "ForExpectClass", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunInterfaceDeclarationChecker$ForExpectClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunInterfaceDeclarationChecker$Regular;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirFunInterfaceDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirFunInterfaceDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunInterfaceDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n57#2:118\n51#2:120\n34#3:119\n14#4:121\n14#4:122\n31#4:123\n1863#5,2:124\n*S KotlinDebug\n*F\n+ 1 FirFunInterfaceDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunInterfaceDeclarationChecker\n*L\n45#1:118\n45#1:120\n45#1:119\n57#1:121\n68#1:122\n95#1:123\n105#1:124,2\n*E\n"})
public abstract class FirFunInterfaceDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    private FirFunInterfaceDeclarationChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block13: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                FirClass $this$isInterface$iv = declaration2;
                boolean $i$f$isInterface = false;
                ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                boolean $i$f$isInterface2 = false;
                boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
                if (!bl) break block12;
                FirMemberDeclaration $this$isFun$iv = declaration2;
                boolean $i$f$isFun = false;
                if ($this$isFun$iv.getStatus().isFun()) break block13;
            }
            return;
        }
        FirTypeScope scope = FirHelpersKt.unsubstitutedScope(declaration2, context2);
        FirRegularClassSymbol classSymbol = declaration2.getSymbol();
        FirCallableSymbol abstractFunctionSymbol = null;
        for (Name name2 : scope.getCallableNames()) {
            List<FirNamedFunctionSymbol> functions = FirScopeKt.getFunctions(scope, name2);
            List<FirVariableSymbol<?>> properties = FirScopeKt.getProperties(scope, name2);
            for (FirNamedFunctionSymbol firNamedFunctionSymbol : functions) {
                FirCallableSymbol $this$isAbstract$iv = firNamedFunctionSymbol;
                boolean $i$f$isAbstract = false;
                if (!($this$isAbstract$iv.getResolvedStatus().getModality() == Modality.ABSTRACT)) continue;
                if (abstractFunctionSymbol == null) {
                    abstractFunctionSymbol = firNamedFunctionSymbol;
                    continue;
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getFUN_INTERFACE_WRONG_COUNT_OF_ABSTRACT_MEMBERS(), (DiagnosticContext)context2, null, 8, null);
            }
            for (FirVariableSymbol firVariableSymbol : properties) {
                FirPropertySymbol firProperty;
                if ((firVariableSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firVariableSymbol : null) == null) continue;
                firProperty = firProperty;
                FirCallableSymbol $this$isAbstract$iv = firProperty;
                boolean $i$f$isAbstract = false;
                if (!($this$isAbstract$iv.getResolvedStatus().getModality() == Modality.ABSTRACT)) continue;
                KtSourceElement source = !Intrinsics.areEqual(FirHelpersKt.getContainingClassSymbol(firProperty, context2.getSession()), (Object)classSymbol) ? declaration2.getSource() : firProperty.getSource();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getFUN_INTERFACE_CANNOT_HAVE_ABSTRACT_PROPERTIES(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        if (abstractFunctionSymbol == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getFUN_INTERFACE_WRONG_COUNT_OF_ABSTRACT_MEMBERS(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        boolean inFunInterface = FirHelpersKt.getContainingClassSymbol(abstractFunctionSymbol, context2.getSession()) == classSymbol;
        if (!((Collection)abstractFunctionSymbol.getTypeParameterSymbols()).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(inFunInterface ? abstractFunctionSymbol.getSource() : declaration2.getSource()), FirErrors.INSTANCE.getFUN_INTERFACE_ABSTRACT_METHOD_WITH_TYPE_PARAMETERS(), (DiagnosticContext)context2, null, 8, null);
        } else {
            FirCallableSymbol $this$isSuspend$iv = abstractFunctionSymbol;
            boolean $i$f$isSuspend = false;
            if ($this$isSuspend$iv.getRawStatus().isSuspend() && !FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.SuspendFunctionsInFunInterfaces)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(inFunInterface ? abstractFunctionSymbol.getSource() : declaration2.getSource()), FirErrors.INSTANCE.getFUN_INTERFACE_WITH_SUSPEND_FUNCTION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        Iterable $this$forEach$iv = ((FirFunctionSymbol)abstractFunctionSymbol).getValueParameterSymbols();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameterSymbol firValueParameterSymbol = (FirValueParameterSymbol)element$iv;
            boolean bl = false;
            if (!firValueParameterSymbol.getHasDefaultValue()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(inFunInterface ? firValueParameterSymbol.getSource() : declaration2.getSource()), FirErrors.INSTANCE.getFUN_INTERFACE_ABSTRACT_METHOD_WITH_DEFAULT_VALUE(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    public /* synthetic */ FirFunInterfaceDeclarationChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunInterfaceDeclarationChecker$ForExpectClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunInterfaceDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirFunInterfaceDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirFunInterfaceDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunInterfaceDeclarationChecker$ForExpectClass\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,117:1\n37#2:118\n*S KotlinDebug\n*F\n+ 1 FirFunInterfaceDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunInterfaceDeclarationChecker$ForExpectClass\n*L\n39#1:118\n*E\n"})
    public static final class ForExpectClass
    extends FirFunInterfaceDeclarationChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirMemberDeclaration $this$isExpect$iv = declaration2;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(declaration2, context2, reporter);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunInterfaceDeclarationChecker$Regular;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunInterfaceDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirFunInterfaceDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirFunInterfaceDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunInterfaceDeclarationChecker$Regular\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,117:1\n37#2:118\n*S KotlinDebug\n*F\n+ 1 FirFunInterfaceDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunInterfaceDeclarationChecker$Regular\n*L\n32#1:118\n*E\n"})
    public static final class Regular
    extends FirFunInterfaceDeclarationChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirMemberDeclaration $this$isExpect$iv = declaration2;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(declaration2, context2, reporter);
        }
    }
}

