/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.containers;

import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.util.ArrayUtil;
import ksp.it.unimi.dsi.fastutil.objects.Object2IntMap;
import ksp.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import ksp.org.jetbrains.annotations.NotNull;

public class Enumerator<T> {
    private static final Logger LOG = Logger.getInstance(Enumerator.class);
    private final Object2IntMap<T> myNumbers;
    private int myNextNumber = 1;

    public Enumerator(int expectNumber) {
        this.myNumbers = new Object2IntOpenHashMap<T>(expectNumber);
    }

    public void clear() {
        this.myNumbers.clear();
        this.myNextNumber = 1;
    }

    public int @NotNull [] enumerate(T @NotNull [] objects) {
        if (objects == null) {
            Enumerator.$$$reportNull$$$0(0);
        }
        int[] nArray = this.enumerate(objects, 0, 0);
        if (nArray == null) {
            Enumerator.$$$reportNull$$$0(1);
        }
        return nArray;
    }

    public int @NotNull [] enumerate(T @NotNull [] objects, int startShift, int endCut) {
        if (objects == null) {
            Enumerator.$$$reportNull$$$0(2);
        }
        int[] idx = ArrayUtil.newIntArray(objects.length - startShift - endCut);
        for (int i = startShift; i < objects.length - endCut; ++i) {
            int number;
            T object = objects[i];
            idx[i - startShift] = number = this.enumerate(object);
        }
        if (idx == null) {
            Enumerator.$$$reportNull$$$0(3);
        }
        return idx;
    }

    public int enumerate(T object) {
        int res2 = this.enumerateImpl(object);
        return Math.max(res2, -res2);
    }

    public boolean add(T object) {
        int res2 = this.enumerateImpl(object);
        return res2 < 0;
    }

    public int enumerateImpl(T object) {
        if (object == null) {
            return 0;
        }
        int number = this.myNumbers.getInt(object);
        if (number == 0) {
            number = this.myNextNumber++;
            this.myNumbers.put(object, number);
            return -number;
        }
        return number;
    }

    public boolean contains(@NotNull T object) {
        if (object == null) {
            Enumerator.$$$reportNull$$$0(4);
        }
        return this.myNumbers.getInt(object) != 0;
    }

    public int get(T object) {
        if (object == null) {
            return 0;
        }
        int res2 = this.myNumbers.getInt(object);
        if (res2 == 0) {
            LOG.error("Object " + object + " must be already added to enumerator!");
        }
        return res2;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Object2IntMap.Entry entry : this.myNumbers.object2IntEntrySet()) {
            buffer.append(entry.getIntValue()).append(": ").append(entry.getKey()).append("\n");
        }
        return buffer.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/containers/Enumerator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/containers/Enumerator";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "enumerate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

