/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.concurrency;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.util.concurrency.BoundedTaskExecutor;
import ksp.com.intellij.util.concurrency.SchedulingWrapper;
import ksp.org.jetbrains.annotations.NotNull;

final class AppDelayQueue
extends DelayQueue<SchedulingWrapper.MyScheduledFutureTask<?>> {
    private static final Logger LOG = Logger.getInstance(AppDelayQueue.class);
    private final Thread scheduledToPooledTransferrer;
    private final AtomicBoolean shutdown = new AtomicBoolean();

    AppDelayQueue() {
        this.scheduledToPooledTransferrer = new Thread(() -> {
            while (!this.shutdown.get()) {
                try {
                    SchedulingWrapper.MyScheduledFutureTask task = (SchedulingWrapper.MyScheduledFutureTask)this.take();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Took " + BoundedTaskExecutor.info(task));
                    }
                    if (task.isDone()) continue;
                    try {
                        task.executeMeInBackendExecutor();
                    }
                    catch (Throwable e) {
                        try {
                            LOG.error("Error executing " + task, e);
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (this.shutdown.get()) continue;
                    LOG.error(e);
                }
            }
            LOG.debug("scheduledToPooledTransferrer Stopped");
        }, "Periodic tasks thread");
        this.scheduledToPooledTransferrer.setDaemon(true);
        this.scheduledToPooledTransferrer.start();
    }

    void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            throw new IllegalStateException("Already shutdown");
        }
        this.scheduledToPooledTransferrer.interrupt();
        try {
            this.scheduledToPooledTransferrer.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    Thread getThread() {
        Thread thread = this.scheduledToPooledTransferrer;
        if (thread == null) {
            AppDelayQueue.$$$reportNull$$$0(0);
        }
        return thread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ksp/com/intellij/util/concurrency/AppDelayQueue", "getThread"));
    }
}

