/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.filters;

import java.util.stream.Stream;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.filters.ElementFilter;

public class AndFilter
implements ElementFilter {
    private final ElementFilter[] myFilters;

    public AndFilter(ElementFilter filter1, ElementFilter filter2) {
        this.myFilters = new ElementFilter[]{filter1, filter2};
    }

    public AndFilter(ElementFilter ... filters) {
        this.myFilters = filters;
    }

    @Override
    public boolean isAcceptable(Object element2, PsiElement context2) {
        return Stream.of(this.myFilters).allMatch(filter -> filter.isAcceptable(element2, context2));
    }

    @Override
    public boolean isClassAcceptable(Class elementClass) {
        return Stream.of(this.myFilters).allMatch(filter -> filter.isClassAcceptable(elementClass));
    }

    @Override
    public String toString() {
        return '(' + StringUtil.join(this.myFilters, ElementFilter::toString, " & ") + ')';
    }
}

