/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.cli.jvm.modules;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.openapi.util.io.FileUtil;
import ksp.com.intellij.openapi.vfs.VfsUtilCore;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.openapi.vfs.VirtualFileSystem;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\u0015\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020\u0005H\u0016J \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020!H\u0016J\n\u0010)\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010*\u001a\u00020\u0005H\u0016J\b\u0010+\u001a\u00020!H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0018H\u0016J\b\u0010/\u001a\u00020\u0018H\u0016J\b\u00100\u001a\u00020\u0018H\u0016J\"\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u00182\b\u00105\u001a\u0004\u0018\u000106H\u0016R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lksp/org/jetbrains/kotlin/cli/jvm/modules/CoreJrtVirtualFile;", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "virtualFileSystem", "Lksp/org/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem;", "jdkHomePath", "", "path", "Ljava/nio/file/Path;", "parent", "(Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem;Ljava/lang/String;Ljava/nio/file/Path;Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtVirtualFile;)V", "attributes", "Ljava/nio/file/attribute/BasicFileAttributes;", "getAttributes", "()Ljava/nio/file/attribute/BasicFileAttributes;", "myChildren", "", "getMyChildren", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "myChildren$delegate", "Lkotlin/Lazy;", "computeChildren", "contentsToByteArray", "", "equals", "", "other", "", "getChildren", "getFileSystem", "Lksp/com/intellij/openapi/vfs/VirtualFileSystem;", "getInputStream", "Ljava/io/InputStream;", "getLength", "", "getModificationStamp", "getName", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "newModificationStamp", "newTimeStamp", "getParent", "getPath", "getTimeStamp", "hashCode", "", "isDirectory", "isValid", "isWritable", "refresh", "", "asynchronous", "recursive", "postRunnable", "Ljava/lang/Runnable;", "cli-base"})
@SourceDebugExtension(value={"SMAP\nCoreJrtVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreJrtVirtualFile.kt\norg/jetbrains/kotlin/cli/jvm/modules/CoreJrtVirtualFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,96:1\n1#2:97\n1557#3:98\n1628#3,3:99\n37#4,2:102\n*S KotlinDebug\n*F\n+ 1 CoreJrtVirtualFile.kt\norg/jetbrains/kotlin/cli/jvm/modules/CoreJrtVirtualFile\n*L\n68#1:98\n68#1:99,3\n68#1:102,2\n*E\n"})
public final class CoreJrtVirtualFile
extends VirtualFile {
    @NotNull
    private final CoreJrtFileSystem virtualFileSystem;
    @NotNull
    private final String jdkHomePath;
    @NotNull
    private final Path path;
    @Nullable
    private final CoreJrtVirtualFile parent;
    @NotNull
    private final Lazy myChildren$delegate;

    public CoreJrtVirtualFile(@NotNull CoreJrtFileSystem virtualFileSystem, @NotNull String jdkHomePath, @NotNull Path path, @Nullable CoreJrtVirtualFile parent2) {
        Intrinsics.checkNotNullParameter((Object)virtualFileSystem, (String)"virtualFileSystem");
        Intrinsics.checkNotNullParameter((Object)jdkHomePath, (String)"jdkHomePath");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.virtualFileSystem = virtualFileSystem;
        this.jdkHomePath = jdkHomePath;
        this.path = path;
        this.parent = parent2;
        this.myChildren$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VirtualFile[]>(this){
            final /* synthetic */ CoreJrtVirtualFile this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final VirtualFile[] invoke() {
                return CoreJrtVirtualFile.access$computeChildren(this.this$0);
            }
        }));
    }

    private final BasicFileAttributes getAttributes() {
        BasicFileAttributes basicFileAttributes = Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)basicFileAttributes, (String)"readAttributes(...)");
        return basicFileAttributes;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.virtualFileSystem;
    }

    @Override
    @NotNull
    public String getName() {
        return ((Object)this.path.getFileName()).toString();
    }

    @Override
    @NotNull
    public String getPath() {
        String string2 = FileUtil.toSystemIndependentName(this.jdkHomePath + "!/" + this.path);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
        return string2;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.path, new LinkOption[0]);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    @Nullable
    public VirtualFile getParent() {
        return this.parent;
    }

    private final VirtualFile[] getMyChildren() {
        Lazy lazy = this.myChildren$delegate;
        return (VirtualFile[])lazy.getValue();
    }

    @Override
    @NotNull
    public VirtualFile[] getChildren() {
        return this.getMyChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final VirtualFile[] computeChildren() {
        VirtualFile[] virtualFileArray;
        Iterable p02;
        Object object;
        try {
            object = Files.newDirectoryStream(this.path);
            Throwable throwable = null;
            try {
                p02 = (Iterable)object;
                boolean bl = false;
                p02 = CollectionsKt.toList((Iterable)p02);
            }
            catch (Throwable p02) {
                throwable = p02;
                throw p02;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = p02;
        }
        catch (IOException e) {
            object = CollectionsKt.emptyList();
        }
        List paths = object;
        if (paths.isEmpty()) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)VirtualFile.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = paths;
            boolean $i$f$map = false;
            p02 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void path;
                Path path2 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new CoreJrtVirtualFile(this.virtualFileSystem, this.jdkHomePath, (Path)path, this));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            virtualFileArray = thisCollection$iv.toArray(new CoreJrtVirtualFile[0]);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(@NotNull Object requestor, long newModificationStamp, long newTimeStamp) {
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = Files.readAllBytes(this.path);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        return byArray;
    }

    @Override
    public long getTimeStamp() {
        return this.getAttributes().lastModifiedTime().toMillis();
    }

    @Override
    public long getLength() {
        return this.getAttributes().size();
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = Files.newInputStream(this.path, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        InputStream inputStream2 = inputStream;
        int n = 8192;
        InputStream inputStream3 = VfsUtilCore.inputStreamSkippingBOM(inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n), this);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream3, (String)"inputStreamSkippingBOM(...)");
        return inputStream3;
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof CoreJrtVirtualFile && Intrinsics.areEqual((Object)this.path, (Object)((CoreJrtVirtualFile)other).path) && Intrinsics.areEqual((Object)this.getFileSystem(), (Object)((CoreJrtVirtualFile)other).getFileSystem());
    }

    public int hashCode() {
        return ((Object)this.path).hashCode();
    }

    public static final /* synthetic */ VirtualFile[] access$computeChildren(CoreJrtVirtualFile $this) {
        return $this.computeChildren();
    }
}

