/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.uninstallmodules;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;

final class AggregatedUninstallModulesGenerator {
    private final XTypeElement testElement;
    private final ImmutableList<XTypeElement> uninstallModuleElements;

    AggregatedUninstallModulesGenerator(XTypeElement testElement, ImmutableList<XTypeElement> uninstallModuleElements) {
        this.testElement = testElement;
        this.uninstallModuleElements = uninstallModuleElements;
    }

    void generate() {
        Processors.generateAggregatingClass("dagger.hilt.android.internal.uninstallmodules.codegen", this.aggregatedUninstallModulesAnnotation(), this.testElement, this.getClass());
    }

    private AnnotationSpec aggregatedUninstallModulesAnnotation() {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassNames.AGGREGATED_UNINSTALL_MODULES);
        builder.addMember("test", "$S", new Object[]{this.testElement.getQualifiedName()});
        this.uninstallModuleElements.stream().map(XTypeElement::getQualifiedName).forEach(uninstallModule -> builder.addMember("uninstallModules", "$S", new Object[]{uninstallModule}));
        return builder.build();
    }
}

