/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentNames;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.root.RootMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public final class TestComponentDataGenerator {
    private final XProcessingEnv processingEnv;
    private final XTypeElement originatingElement;
    private final RootMetadata rootMetadata;
    private final ClassName name;
    private final ComponentNames componentNames;

    public TestComponentDataGenerator(XProcessingEnv processingEnv, XTypeElement originatingElement, RootMetadata rootMetadata, ComponentNames componentNames) {
        this.processingEnv = processingEnv;
        this.originatingElement = originatingElement;
        this.rootMetadata = rootMetadata;
        this.componentNames = componentNames;
        this.name = Processors.append(Processors.getEnclosedClassName(rootMetadata.testRootMetadata().testName()), "_TestComponentDataSupplier");
    }

    public void generate() throws IOException {
        TypeSpec.Builder generator = TypeSpec.classBuilder((ClassName)this.name).superclass((TypeName)ClassNames.TEST_COMPONENT_DATA_SUPPLIER).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(this.getMethod()).addMethod(this.getTestInjectInternalMethod());
        JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)generator, (XElement)this.originatingElement);
        Processors.addGeneratedAnnotation(generator, this.processingEnv, ClassNames.ROOT_PROCESSOR.toString());
        this.processingEnv.getFiler().write(JavaFile.builder((String)this.name.packageName(), (TypeSpec)generator.build()).build(), XFiler.Mode.Isolating);
    }

    private MethodSpec getMethod() {
        XTypeElement testElement = this.rootMetadata.testRootMetadata().testElement();
        ClassName component = this.componentNames.generatedComponent(testElement.getClassName(), ClassNames.SINGLETON_COMPONENT);
        ImmutableSet<XTypeElement> daggerRequiredModules = this.rootMetadata.modulesThatDaggerCannotConstruct(ClassNames.SINGLETON_COMPONENT);
        ImmutableSet hiltRequiredModules = (ImmutableSet)daggerRequiredModules.stream().filter(module -> !TestComponentDataGenerator.canBeConstructedByHilt(module, testElement)).collect(DaggerStreams.toImmutableSet());
        return MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ClassNames.TEST_COMPONENT_DATA).addStatement("return new $T($L, $L, $L, $L, $L)", new Object[]{ClassNames.TEST_COMPONENT_DATA, this.rootMetadata.waitForBindValue(), CodeBlock.of((String)"testInstance -> injectInternal(($1T) testInstance)", (Object[])new Object[]{testElement.getClassName()}), TestComponentDataGenerator.getElementsListed(daggerRequiredModules), TestComponentDataGenerator.getElementsListed((ImmutableSet<XTypeElement>)hiltRequiredModules), CodeBlock.of((String)"(modules, testInstance, autoAddModuleEnabled) -> $T.builder()\n.applicationContextModule(\n    new $T($T.getApplication($T.getApplicationContext())))\n$L.build()", (Object[])new Object[]{Processors.prepend(Processors.getEnclosedClassName(component), "Dagger"), ClassNames.APPLICATION_CONTEXT_MODULE, ClassNames.CONTEXTS, ClassNames.APPLICATION_PROVIDER, daggerRequiredModules.stream().map(module -> TestComponentDataGenerator.getAddModuleStatement(module, testElement)).collect(Collectors.joining("\n"))})}).build();
    }

    private static String getAddModuleStatement(XTypeElement module, XTypeElement testElement) {
        ClassName className = module.getClassName();
        return TestComponentDataGenerator.canBeConstructedByHilt(module, testElement) ? CodeBlock.of((String)".$1L(autoAddModuleEnabled\n    ? (($3T) testInstance).new $4L()\n    : ($2T) modules.get($2T.class))", (Object[])new Object[]{Processors.upperToLowerCamel(className.simpleName()), className, className.enclosingClassName(), className.simpleName()}).toString() : CodeBlock.of((String)".$1L(($2T) modules.get($2T.class))", (Object[])new Object[]{Processors.upperToLowerCamel(className.simpleName()), className}).toString();
    }

    private static boolean canBeConstructedByHilt(XTypeElement module, XTypeElement testElement) {
        return TestComponentDataGenerator.hasOnlyAccessibleNoArgConstructor(module) && module.getEnclosingElement().equals((Object)testElement);
    }

    private static boolean hasOnlyAccessibleNoArgConstructor(XTypeElement module) {
        List declaredConstructors = module.getConstructors();
        return declaredConstructors.isEmpty() || declaredConstructors.size() == 1 && !((XConstructorElement)declaredConstructors.get(0)).isPrivate() && ((XConstructorElement)declaredConstructors.get(0)).getParameters().isEmpty();
    }

    private static CodeBlock getElementsListed(ImmutableSet<XTypeElement> modules) {
        return modules.isEmpty() ? CodeBlock.of((String)"$T.emptySet()", (Object[])new Object[]{ClassNames.COLLECTIONS}) : CodeBlock.of((String)"new $T<>($T.asList($L))", (Object[])new Object[]{ClassNames.HASH_SET, ClassNames.ARRAYS, modules.stream().map(module -> CodeBlock.of((String)"$T.class", (Object[])new Object[]{module.getClassName()}).toString()).collect(Collectors.joining(","))});
    }

    private MethodSpec getTestInjectInternalMethod() {
        XTypeElement testElement = this.rootMetadata.testRootMetadata().testElement();
        ClassName testName = testElement.getClassName();
        return MethodSpec.methodBuilder((String)"injectInternal").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)testName, "testInstance", new Modifier[0]).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).addStatement(this.callInjectTest(testElement)).build();
    }

    private CodeBlock callInjectTest(XTypeElement testElement) {
        Optional<XAnnotation> skipTestInjection = this.rootMetadata.testRootMetadata().skipTestInjectionAnnotation();
        if (skipTestInjection.isPresent()) {
            return CodeBlock.of((String)"throw new IllegalStateException(\"Cannot inject test when using @$L\")", (Object[])new Object[]{skipTestInjection.get().getName()});
        }
        return CodeBlock.of((String)"(($T) (($T) $T.getApplication($T.getApplicationContext())).generatedComponent()).injectTest(testInstance)", (Object[])new Object[]{this.rootMetadata.testRootMetadata().testInjectorName(), ClassNames.GENERATED_COMPONENT_MANAGER, ClassNames.CONTEXTS, ClassNames.APPLICATION_PROVIDER});
    }
}

