/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.definecomponent;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.definecomponent.AutoValue_DefineComponentMetadatas_DefineComponentMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

final class DefineComponentMetadatas {
    private final Map<XElement, DefineComponentMetadata> metadatas = new HashMap<XElement, DefineComponentMetadata>();

    static DefineComponentMetadatas create() {
        return new DefineComponentMetadatas();
    }

    private DefineComponentMetadatas() {
    }

    DefineComponentMetadata get(XElement element) {
        return this.get(element, new LinkedHashSet<XElement>());
    }

    private DefineComponentMetadata get(XElement element, LinkedHashSet<XElement> childPath) {
        if (!this.metadatas.containsKey(element)) {
            this.metadatas.put(element, this.getUncached(element, childPath));
        }
        return this.metadatas.get(element);
    }

    private DefineComponentMetadata getUncached(XElement element, LinkedHashSet<XElement> childPath) {
        ProcessorErrors.checkState(childPath.add(element), element, "@DefineComponent cycle: %s -> %s", childPath.stream().map(XElements::toStableString).collect(Collectors.joining(" -> ")), XElements.toStableString((XElement)element));
        ProcessorErrors.checkState(element.hasAnnotation(ClassNames.DEFINE_COMPONENT), element, "%s, expected to be annotated with @DefineComponent. Found: %s", XElements.toStableString((XElement)element), element.getAllAnnotations().stream().map(XAnnotations::toStableString).collect(DaggerStreams.toImmutableList()));
        ProcessorErrors.checkState(XElementKt.isTypeElement((XElement)element) && XElements.asTypeElement((XElement)element).isInterface(), element, "@DefineComponent is only allowed on interfaces. Found: %s", XElements.toStableString((XElement)element));
        XTypeElement component = XElements.asTypeElement((XElement)element);
        ProcessorErrors.checkState(component.getSuperInterfaces().isEmpty(), (XElement)component, "@DefineComponent %s, cannot extend a super class or interface. Found: %s", XElements.toStableString((XElement)component), component.getSuperInterfaces().stream().map(XTypes::toStableString).collect(DaggerStreams.toImmutableList()));
        ProcessorErrors.checkState(component.getTypeParameters().isEmpty(), (XElement)component, "@DefineComponent %s, cannot have type parameters.", XTypes.toStableString((XType)component.getType()));
        ImmutableList nonStaticMethods = (ImmutableList)component.getDeclaredMethods().stream().filter(method -> !method.isStatic()).collect(DaggerStreams.toImmutableList());
        ProcessorErrors.checkState(nonStaticMethods.isEmpty(), (XElement)component, "@DefineComponent %s, cannot have non-static methods. Found: %s", XElements.toStableString((XElement)component), nonStaticMethods.stream().map(XElements::toStableString).collect(DaggerStreams.toImmutableList()));
        ImmutableList scopes = (ImmutableList)Processors.getScopeAnnotations((XElement)component).stream().map(XAnnotation::getTypeElement).collect(DaggerStreams.toImmutableList());
        ImmutableList aliasScopes = ImmutableList.copyOf((Collection)component.getAnnotationsAnnotatedWith(ClassNames.ALIAS_OF));
        ProcessorErrors.checkState(aliasScopes.isEmpty(), (XElement)component, "@DefineComponent %s, references invalid scope(s) annotated with @AliasOf. @DefineComponent scopes cannot be aliases of other scopes: %s", XElements.toStableString((XElement)component), aliasScopes.stream().map(XAnnotations::toStableString).collect(DaggerStreams.toImmutableList()));
        XAnnotation annotation = component.getAnnotation(ClassNames.DEFINE_COMPONENT);
        XAnnotationValue parentValue = annotation.getAnnotationValue("parent");
        ProcessorErrors.checkState(!"<error>".contentEquals(parentValue.getValue().toString()), (XElement)component, "@DefineComponent %s, references an invalid parent type: %s", XElements.toStableString((XElement)component), XAnnotations.toStableString((XAnnotation)annotation));
        XTypeElement parent = parentValue.asType().getTypeElement();
        ProcessorErrors.checkState(parent.getClassName().equals((Object)ClassNames.DEFINE_COMPONENT_NO_PARENT) || parent.hasAnnotation(ClassNames.DEFINE_COMPONENT), (XElement)component, "@DefineComponent %s, references a type not annotated with @DefineComponent: %s", XElements.toStableString((XElement)component), XElements.toStableString((XElement)parent));
        Optional<DefineComponentMetadata> parentComponent = parent.getClassName().equals((Object)ClassNames.DEFINE_COMPONENT_NO_PARENT) ? Optional.empty() : Optional.of(this.get((XElement)parent, childPath));
        ClassName componentClassName = component.getClassName();
        ProcessorErrors.checkState(parentComponent.isPresent() || componentClassName.equals((Object)ClassNames.SINGLETON_COMPONENT), (XElement)component, "@DefineComponent %s is missing a parent declaration.\nPlease declare the parent, for example: @DefineComponent(parent = SingletonComponent.class)", XElements.toStableString((XElement)component));
        ProcessorErrors.checkState(componentClassName.equals((Object)ClassNames.SINGLETON_COMPONENT) || !componentClassName.simpleName().equals(ClassNames.SINGLETON_COMPONENT.simpleName()), (XElement)component, "Cannot have a component with the same simple name as the reserved %s: %s", ClassNames.SINGLETON_COMPONENT.simpleName(), componentClassName.canonicalName());
        return new AutoValue_DefineComponentMetadatas_DefineComponentMetadata(component, (ImmutableList<XTypeElement>)scopes, parentComponent);
    }

    @AutoValue
    static abstract class DefineComponentMetadata {
        DefineComponentMetadata() {
        }

        abstract XTypeElement component();

        abstract ImmutableList<XTypeElement> scopes();

        abstract Optional<DefineComponentMetadata> parentMetadata();

        boolean isRoot() {
            return !this.parentMetadata().isPresent();
        }
    }
}

