/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.hilt.processor.internal.AutoValue_MethodSignature;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.stream.Collectors;

@AutoValue
public abstract class MethodSignature {
    MethodSignature() {
    }

    abstract String name();

    abstract ImmutableList<TypeName> parameters();

    public static MethodSignature of(String methodName, TypeName ... typeNames) {
        return new AutoValue_MethodSignature(methodName, (ImmutableList<TypeName>)ImmutableList.copyOf((Object[])typeNames));
    }

    public static MethodSignature of(MethodSpec method) {
        return new AutoValue_MethodSignature(method.name, (ImmutableList<TypeName>)((ImmutableList)method.parameters.stream().map(p -> p.type).collect(DaggerStreams.toImmutableList())));
    }

    public static MethodSignature of(XExecutableElement executableElement) {
        return new AutoValue_MethodSignature(XElements.getSimpleName((XElement)executableElement), (ImmutableList<TypeName>)((ImmutableList)executableElement.getParameters().stream().map(p -> p.getType().getTypeName()).collect(DaggerStreams.toImmutableList())));
    }

    static MethodSignature ofDeclaredType(XMethodElement method, XType enclosing) {
        XMethodType executableType = method.asMemberOf(enclosing);
        return new AutoValue_MethodSignature(XElements.getSimpleName((XElement)method), (ImmutableList<TypeName>)((ImmutableList)executableType.getParameterTypes().stream().map(XType::getTypeName).collect(DaggerStreams.toImmutableList())));
    }

    public final String toString() {
        return String.format("%s(%s)", this.name(), this.parameters().stream().map(Object::toString).collect(Collectors.joining(",")));
    }
}

