/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.BadInputException;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;

public final class Components {
    public static ImmutableSet<ClassName> getComponents(XElement element) {
        if (!element.hasAnnotation(ClassNames.INSTALL_IN) && !element.hasAnnotation(ClassNames.TEST_INSTALL_IN)) {
            XElement enclosing = element.getEnclosingElement();
            if (enclosing != null && XElementKt.isTypeElement((XElement)enclosing) && XElementKt.isTypeElement((XElement)element) && enclosing.hasAnnotation(ClassNames.MODULE) && XElements.asTypeElement((XElement)element).isCompanionObject()) {
                return Components.getComponents(enclosing);
            }
            if (Processors.hasErrorTypeAnnotation(element)) {
                throw new BadInputException(String.format("Error annotation found on element %s. Look above for compilation errors", XElements.toStableString((XElement)element)), element);
            }
            throw new BadInputException(String.format("An @InstallIn annotation is required for: %s.", XElements.toStableString((XElement)element)), element);
        }
        ImmutableSet<ClassName> components = Components.getHiltInstallInComponents(element);
        return components;
    }

    public static AnnotationSpec getInstallInAnnotationSpec(ImmutableSet<ClassName> components) {
        Preconditions.checkArgument((!components.isEmpty() ? 1 : 0) != 0);
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassNames.INSTALL_IN);
        components.forEach(component -> builder.addMember("value", "$T.class", new Object[]{component}));
        return builder.build();
    }

    private static ImmutableSet<ClassName> getHiltInstallInComponents(XElement element) {
        Preconditions.checkArgument((element.hasAnnotation(ClassNames.INSTALL_IN) || element.hasAnnotation(ClassNames.TEST_INSTALL_IN) ? 1 : 0) != 0);
        ImmutableList<XTypeElement> components = element.hasAnnotation(ClassNames.INSTALL_IN) ? Processors.getAnnotationClassValues(element.getAnnotation(ClassNames.INSTALL_IN), "value") : Processors.getAnnotationClassValues(element.getAnnotation(ClassNames.TEST_INSTALL_IN), "components");
        ImmutableSet undefinedComponents = (ImmutableSet)components.stream().filter(component -> !component.hasAnnotation(ClassNames.DEFINE_COMPONENT)).collect(DaggerStreams.toImmutableSet());
        ProcessorErrors.checkState(undefinedComponents.isEmpty(), element, "@InstallIn, can only be used with @DefineComponent-annotated classes, but found: %s", undefinedComponents.stream().map(XElements::toStableString).collect(DaggerStreams.toImmutableList()));
        return (ImmutableSet)components.stream().map(XTypeElement::getClassName).collect(DaggerStreams.toImmutableSet());
    }

    private Components() {
    }
}

