/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.Generators;
import dagger.hilt.processor.internal.Processors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeParameterElement;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public final class ServiceGenerator {
    private final XProcessingEnv env;
    private final AndroidEntryPointMetadata metadata;
    private final ClassName generatedClassName;

    public ServiceGenerator(XProcessingEnv env, AndroidEntryPointMetadata metadata) {
        this.env = env;
        this.metadata = metadata;
        this.generatedClassName = metadata.generatedClassName();
    }

    public void generate() throws IOException {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.generatedClassName.simpleName()).superclass(this.metadata.baseClassName()).addModifiers(this.metadata.generatedClassModifiers()).addMethods(this.baseClassConstructors()).addMethod(this.onCreateMethod());
        JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)builder, (XElement)this.metadata.element());
        Generators.addGeneratedBaseClassJavadoc(builder, AndroidClassNames.ANDROID_ENTRY_POINT);
        Processors.addGeneratedAnnotation(builder, this.env, this.getClass());
        Generators.copyLintAnnotations((XElement)this.metadata.element(), builder);
        Generators.copySuppressAnnotations((XElement)this.metadata.element(), builder);
        this.metadata.baseElement().getTypeParameters().stream().map(XTypeParameterElement::getTypeVariableName).forEachOrdered(arg_0 -> ((TypeSpec.Builder)builder).addTypeVariable(arg_0));
        Generators.addInjectionMethods(this.metadata, builder);
        Generators.addComponentOverride(this.metadata, builder);
        this.env.getFiler().write(JavaFile.builder((String)this.generatedClassName.packageName(), (TypeSpec)builder.build()).build(), XFiler.Mode.Isolating);
    }

    private ImmutableList<MethodSpec> baseClassConstructors() {
        return (ImmutableList)this.metadata.baseElement().getConstructors().stream().map(ServiceGenerator::toMethodSpec).collect(DaggerStreams.toImmutableList());
    }

    private static MethodSpec toMethodSpec(XConstructorElement constructor) {
        ImmutableList params = (ImmutableList)constructor.getParameters().stream().map(ServiceGenerator::toParameterSpec).collect(DaggerStreams.toImmutableList());
        return MethodSpec.constructorBuilder().addParameters((Iterable)params).addStatement("super($L)", new Object[]{params.stream().map(p -> p.name).collect(Collectors.joining(","))}).build();
    }

    private static ParameterSpec toParameterSpec(XExecutableParameterElement parameter) {
        return ParameterSpec.builder((TypeName)parameter.getType().getTypeName(), (String)XElements.getSimpleName((XElement)parameter), (Modifier[])new Modifier[0]).build();
    }

    private MethodSpec onCreateMethod() throws IOException {
        return MethodSpec.methodBuilder((String)"onCreate").addAnnotation(AndroidClassNames.CALL_SUPER).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("inject()", new Object[0]).addStatement("super.onCreate()", new Object[0]).build();
    }
}

