/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.BadInputException;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.HiltCompilerOptions;
import dagger.hilt.processor.internal.aggregateddeps.AggregatedDepsMetadata;
import dagger.hilt.processor.internal.aliasof.AliasOfPropagatedDataMetadata;
import dagger.hilt.processor.internal.definecomponent.DefineComponentClassesMetadata;
import dagger.hilt.processor.internal.earlyentrypoint.AggregatedEarlyEntryPointMetadata;
import dagger.hilt.processor.internal.generatesrootinput.GeneratesRootInputs;
import dagger.hilt.processor.internal.root.AggregatedRootGenerator;
import dagger.hilt.processor.internal.root.AggregatedRootMetadata;
import dagger.hilt.processor.internal.root.ComponentTreeDepsGenerator;
import dagger.hilt.processor.internal.root.ComponentTreeDepsMetadata;
import dagger.hilt.processor.internal.root.ProcessedRootSentinelGenerator;
import dagger.hilt.processor.internal.root.ProcessedRootSentinelMetadata;
import dagger.hilt.processor.internal.root.Root;
import dagger.hilt.processor.internal.root.RootType;
import dagger.hilt.processor.internal.root.TestInjectorGenerator;
import dagger.hilt.processor.internal.root.TestRootMetadata;
import dagger.hilt.processor.internal.root.ir.AggregatedDepsIr;
import dagger.hilt.processor.internal.root.ir.AggregatedEarlyEntryPointIr;
import dagger.hilt.processor.internal.root.ir.AggregatedRootIr;
import dagger.hilt.processor.internal.root.ir.AggregatedRootIrValidator;
import dagger.hilt.processor.internal.root.ir.AggregatedUninstallModulesIr;
import dagger.hilt.processor.internal.root.ir.AliasOfPropagatedDataIr;
import dagger.hilt.processor.internal.root.ir.ComponentTreeDepsIr;
import dagger.hilt.processor.internal.root.ir.ComponentTreeDepsIrCreator;
import dagger.hilt.processor.internal.root.ir.DefineComponentClassesIr;
import dagger.hilt.processor.internal.root.ir.InvalidRootsException;
import dagger.hilt.processor.internal.root.ir.ProcessedRootSentinelIr;
import dagger.hilt.processor.internal.uninstallmodules.AggregatedUninstallModulesMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;

@AutoService(value={Processor.class})
public final class RootProcessor
extends BaseProcessor {
    private boolean processed;
    private GeneratesRootInputs generatesRootInputs;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.generatesRootInputs = new GeneratesRootInputs(processingEnvironment);
    }

    public ImmutableSet<String> additionalProcessingOptions() {
        return HiltCompilerOptions.useAggregatingRootProcessor(this.getProcessingEnv()) ? ImmutableSet.of((Object)IncrementalAnnotationProcessorType.AGGREGATING.getProcessorOption()) : ImmutableSet.of((Object)IncrementalAnnotationProcessorType.ISOLATING.getProcessorOption());
    }

    public ImmutableSet<String> getSupportedAnnotationTypes() {
        return ImmutableSet.builder().addAll((Iterable)Arrays.stream(RootType.values()).map(rootType -> rootType.className().toString()).collect(DaggerStreams.toImmutableSet())).build();
    }

    @Override
    public void processEach(TypeElement annotation, Element element) throws Exception {
        TypeElement rootElement = MoreElements.asType(element);
        RootType rootType = RootType.of(rootElement);
        if (rootType.isTestRoot()) {
            new TestInjectorGenerator(this.getProcessingEnv(), TestRootMetadata.of(this.getProcessingEnv(), rootElement)).generate();
        }
        TypeElement originatingRootElement = Root.create(rootElement, this.getProcessingEnv()).originatingRootElement();
        new AggregatedRootGenerator(rootElement, originatingRootElement, annotation, this.getProcessingEnv()).generate();
    }

    @Override
    public void postRoundProcess(RoundEnvironment roundEnv) throws Exception {
        if (!HiltCompilerOptions.useAggregatingRootProcessor(this.getProcessingEnv())) {
            return;
        }
        ImmutableSet<Element> newElements = this.generatesRootInputs.getElementsToWaitFor(roundEnv);
        if (this.processed) {
            Preconditions.checkState((boolean)newElements.isEmpty(), (String)"Found extra modules after compilation: %s\n(If you are adding an annotation processor that generates root input for hilt, the annotation must be annotated with @dagger.hilt.GeneratesRootInput.\n)", newElements);
        } else if (newElements.isEmpty()) {
            this.processed = true;
            ImmutableSet<AggregatedRootIr> rootsToProcess = this.rootsToProcess();
            if (rootsToProcess.isEmpty()) {
                return;
            }
            ComponentTreeDepsGenerator componentTreeDepsGenerator = new ComponentTreeDepsGenerator(this.getProcessingEnv());
            for (ComponentTreeDepsMetadata metadata : this.componentTreeDepsMetadatas(rootsToProcess)) {
                componentTreeDepsGenerator.generate(metadata);
            }
            for (AggregatedRootIr ir : rootsToProcess) {
                TypeElement rootElement = this.getElementUtils().getTypeElement(ir.getRoot().canonicalName());
                new ProcessedRootSentinelGenerator(rootElement, this.getProcessingEnv()).generate();
            }
        }
    }

    private ImmutableSet<AggregatedRootIr> rootsToProcess() {
        ImmutableSet processedRoots = (ImmutableSet)ProcessedRootSentinelMetadata.from(this.getElementUtils()).stream().map(ProcessedRootSentinelMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        ImmutableSet aggregatedRoots = (ImmutableSet)AggregatedRootMetadata.from(this.processingEnv).stream().map(AggregatedRootMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        boolean isCrossCompilationRootValidationDisabled = HiltCompilerOptions.isCrossCompilationRootValidationDisabled((ImmutableSet<TypeElement>)((ImmutableSet)aggregatedRoots.stream().map(ir -> this.getElementUtils().getTypeElement(ir.getRoot().canonicalName())).collect(DaggerStreams.toImmutableSet())), this.processingEnv);
        try {
            return ImmutableSet.copyOf(AggregatedRootIrValidator.rootsToProcess(isCrossCompilationRootValidationDisabled, (Set<ProcessedRootSentinelIr>)processedRoots, (Set<AggregatedRootIr>)aggregatedRoots));
        }
        catch (InvalidRootsException ex) {
            throw new BadInputException(ex.getMessage());
        }
    }

    private ImmutableSet<ComponentTreeDepsMetadata> componentTreeDepsMetadatas(ImmutableSet<AggregatedRootIr> aggregatedRoots) {
        ImmutableSet defineComponentDeps = (ImmutableSet)DefineComponentClassesMetadata.from(this.getElementUtils()).stream().map(DefineComponentClassesMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        ImmutableSet aliasOfDeps = (ImmutableSet)AliasOfPropagatedDataMetadata.from(this.getElementUtils()).stream().map(AliasOfPropagatedDataMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        ImmutableSet aggregatedDeps = (ImmutableSet)AggregatedDepsMetadata.from(this.getElementUtils()).stream().map(AggregatedDepsMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        ImmutableSet aggregatedUninstallModulesDeps = (ImmutableSet)AggregatedUninstallModulesMetadata.from(this.getElementUtils()).stream().map(AggregatedUninstallModulesMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        ImmutableSet aggregatedEarlyEntryPointDeps = (ImmutableSet)AggregatedEarlyEntryPointMetadata.from(this.getElementUtils()).stream().map(AggregatedEarlyEntryPointMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        boolean isTest = aggregatedRoots.stream().anyMatch(AggregatedRootIr::isTestRoot);
        Set<ComponentTreeDepsIr> componentTreeDeps = ComponentTreeDepsIrCreator.components(isTest, HiltCompilerOptions.isSharedTestComponentsEnabled(this.processingEnv), aggregatedRoots, (Set<DefineComponentClassesIr>)defineComponentDeps, (Set<AliasOfPropagatedDataIr>)aliasOfDeps, (Set<AggregatedDepsIr>)aggregatedDeps, (Set<AggregatedUninstallModulesIr>)aggregatedUninstallModulesDeps, (Set<AggregatedEarlyEntryPointIr>)aggregatedEarlyEntryPointDeps);
        return (ImmutableSet)componentTreeDeps.stream().map(it -> ComponentTreeDepsMetadata.from(it, this.getElementUtils())).collect(DaggerStreams.toImmutableSet());
    }
}

