/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.aggregateddeps.ComponentDependencies;
import dagger.hilt.processor.internal.aliasof.AliasOfs;
import dagger.hilt.processor.internal.kotlin.KotlinMetadataUtil;
import dagger.hilt.processor.internal.kotlin.KotlinMetadataUtils;
import dagger.hilt.processor.internal.root.ComponentTree;
import dagger.hilt.processor.internal.root.Root;
import dagger.hilt.processor.internal.root.TestRootMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public final class RootMetadata {
    private static final ClassName APPLICATION_CONTEXT_MODULE = ClassName.get((String)"dagger.hilt.android.internal.modules", (String)"ApplicationContextModule", (String[])new String[0]);
    private final Root root;
    private final ProcessingEnvironment env;
    private final Elements elements;
    private final ComponentTree componentTree;
    private final ComponentDependencies deps;
    private final AliasOfs aliasOfs;
    private final Supplier<ImmutableSetMultimap<ClassName, ClassName>> scopesByComponent = Suppliers.memoize(this::getScopesByComponentUncached);
    private final Supplier<TestRootMetadata> testRootMetadata = Suppliers.memoize(this::testRootMetadataUncached);

    static RootMetadata create(Root root, ComponentTree componentTree, ComponentDependencies deps, AliasOfs aliasOfs, ProcessingEnvironment env) {
        return RootMetadata.createInternal(root, componentTree, deps, aliasOfs, env);
    }

    static RootMetadata copyWithNewTree(RootMetadata other, ComponentTree componentTree) {
        return RootMetadata.createInternal(other.root, componentTree, other.deps, other.aliasOfs, other.env);
    }

    private static RootMetadata createInternal(Root root, ComponentTree componentTree, ComponentDependencies deps, AliasOfs aliasOfs, ProcessingEnvironment env) {
        RootMetadata metadata = new RootMetadata(root, componentTree, deps, aliasOfs, env);
        metadata.validate();
        return metadata;
    }

    private RootMetadata(Root root, ComponentTree componentTree, ComponentDependencies deps, AliasOfs aliasOfs, ProcessingEnvironment env) {
        this.root = root;
        this.env = env;
        this.elements = env.getElementUtils();
        this.componentTree = componentTree;
        this.deps = deps;
        this.aliasOfs = aliasOfs;
    }

    public Root root() {
        return this.root;
    }

    public ComponentTree componentTree() {
        return this.componentTree;
    }

    public ComponentDependencies deps() {
        return this.deps;
    }

    public ImmutableSet<TypeElement> modules(ClassName componentName) {
        return this.deps.modules().get((Object)componentName);
    }

    public ImmutableSet<TypeName> entryPoints(ClassName componentName) {
        return ImmutableSet.builder().addAll((Iterable)this.deps.entryPoints().get((Object)componentName).stream().map(ClassName::get).collect(DaggerStreams.toImmutableSet())).add((Object)(this.root.isTestRoot() && componentName.equals((Object)ClassNames.SINGLETON_COMPONENT) ? ClassNames.TEST_SINGLETON_COMPONENT : ClassNames.GENERATED_COMPONENT)).add((Object)componentName).build();
    }

    public ImmutableSet<ClassName> scopes(ClassName componentName) {
        return ((ImmutableSetMultimap)this.scopesByComponent.get()).get((Object)componentName);
    }

    public ImmutableSet<TypeElement> modulesThatDaggerCannotConstruct(ClassName componentName) {
        return (ImmutableSet)this.modules(componentName).stream().filter(module -> !RootMetadata.daggerCanConstruct(module)).filter(module -> !APPLICATION_CONTEXT_MODULE.equals((Object)ClassName.get((TypeElement)module))).collect(DaggerStreams.toImmutableSet());
    }

    public TestRootMetadata testRootMetadata() {
        Preconditions.checkState((!this.root.isDefaultRoot() ? 1 : 0) != 0, (Object)"The default root does not have TestRootMetadata!");
        return (TestRootMetadata)this.testRootMetadata.get();
    }

    public boolean waitForBindValue() {
        return false;
    }

    private TestRootMetadata testRootMetadataUncached() {
        return TestRootMetadata.of(this.env, this.root().element());
    }

    private void validate() {
        for (ComponentDescriptor componentDescriptor : this.componentTree.getComponentDescriptors()) {
            ClassName componentName = componentDescriptor.component();
            for (TypeElement extraModule : this.modulesThatDaggerCannotConstruct(componentName)) {
                if (this.root.isTestRoot() && !componentName.equals((Object)ClassNames.SINGLETON_COMPONENT)) {
                    this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, "[Hilt] All test modules (unless installed in ApplicationComponent) must use static provision methods or have a visible, no-arg constructor. Found: " + extraModule.getQualifiedName(), this.root.originatingRootElement());
                    continue;
                }
                if (this.root.isTestRoot()) continue;
                this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, "[Hilt] All modules must be static and use static provision methods or have a visible, no-arg constructor. Found: " + extraModule.getQualifiedName(), this.root.originatingRootElement());
            }
        }
    }

    private ImmutableSetMultimap<ClassName, ClassName> getScopesByComponentUncached() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (ComponentDescriptor componentDescriptor : this.componentTree.getComponentDescriptors()) {
            for (ClassName scope : componentDescriptor.scopes()) {
                builder.put((Object)componentDescriptor.component(), (Object)scope);
                builder.putAll((Object)componentDescriptor.component(), this.aliasOfs.getAliasesFor(scope));
            }
        }
        return builder.build();
    }

    private static boolean daggerCanConstruct(TypeElement type) {
        boolean isKotlinObject;
        KotlinMetadataUtil metadataUtil = KotlinMetadataUtils.getMetadataUtil();
        boolean bl = isKotlinObject = metadataUtil.isObjectClass(type) || metadataUtil.isCompanionObjectClass(type);
        if (isKotlinObject) {
            return true;
        }
        return !RootMetadata.isInnerClass(type) && !RootMetadata.hasNonDaggerAbstractMethod(type) && (RootMetadata.hasOnlyStaticProvides(type) || RootMetadata.hasVisibleEmptyConstructor(type));
    }

    private static boolean isInnerClass(TypeElement type) {
        return type.getNestingKind().isNested() && !type.getModifiers().contains((Object)Modifier.STATIC);
    }

    private static boolean hasNonDaggerAbstractMethod(TypeElement type) {
        return ElementFilter.methodsIn(type.getEnclosedElements()).stream().filter(method -> method.getModifiers().contains((Object)Modifier.ABSTRACT)).anyMatch(method -> !Processors.hasDaggerAbstractMethodAnnotation(method));
    }

    private static boolean hasOnlyStaticProvides(TypeElement type) {
        return ElementFilter.methodsIn(type.getEnclosedElements()).stream().filter(method -> Processors.hasAnnotation((Element)method, ClassNames.PROVIDES)).allMatch(method -> method.getModifiers().contains((Object)Modifier.STATIC));
    }

    private static boolean hasVisibleEmptyConstructor(TypeElement type) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(type.getEnclosedElements());
        return constructors.isEmpty() || constructors.stream().filter(constructor -> constructor.getParameters().isEmpty()).anyMatch(constructor -> !constructor.getModifiers().contains((Object)Modifier.PRIVATE));
    }
}

