/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.model;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.CodeBlock;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.shaded.auto.common.AnnotationMirrors;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

final class MoreAnnotationMirrors {
    public static String toStableString(DaggerAnnotation qualifier) {
        return MoreAnnotationMirrors.stableAnnotationMirrorToString(qualifier.javac());
    }

    private static String stableAnnotationMirrorToString(AnnotationMirror qualifier) {
        StringBuilder builder = new StringBuilder("@").append(qualifier.getAnnotationType());
        ImmutableMap<ExecutableElement, AnnotationValue> elementValues = AnnotationMirrors.getAnnotationValuesWithDefaults(qualifier);
        if (!elementValues.isEmpty()) {
            ImmutableMap.Builder namedValuesBuilder = ImmutableMap.builder();
            elementValues.forEach((key, value2) -> namedValuesBuilder.put((Object)key.getSimpleName().toString(), (Object)MoreAnnotationMirrors.stableAnnotationValueToString(value2)));
            ImmutableMap namedValues = namedValuesBuilder.build();
            builder.append('(');
            if (namedValues.size() == 1 && namedValues.containsKey((Object)"value")) {
                builder.append((String)namedValues.get((Object)"value"));
            } else {
                builder.append(Joiner.on((String)", ").withKeyValueSeparator("=").join((Map)namedValues));
            }
            builder.append(')');
        }
        return builder.toString();
    }

    private static String stableAnnotationValueToString(AnnotationValue annotationValue) {
        return annotationValue.accept(new SimpleAnnotationValueVisitor8<String, Void>(){

            @Override
            protected String defaultAction(Object value2, Void ignore) {
                return value2.toString();
            }

            @Override
            public String visitString(String value2, Void ignore) {
                return CodeBlock.of((String)"$S", (Object[])new Object[]{value2}).toString();
            }

            @Override
            public String visitAnnotation(AnnotationMirror value2, Void ignore) {
                return MoreAnnotationMirrors.stableAnnotationMirrorToString(value2);
            }

            @Override
            public String visitArray(List<? extends AnnotationValue> value2, Void ignore) {
                return value2.stream().map(x$0 -> MoreAnnotationMirrors.stableAnnotationValueToString(x$0)).collect(Collectors.joining(", ", "{", "}"));
            }
        }, null);
    }

    private MoreAnnotationMirrors() {
    }
}

