/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dagger.internal.Provider;
import dagger.internal.Providers;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractMapProducer;
import dagger.producers.internal.Producers;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public final class MapOfProducedProducer<K, V>
extends AbstractMapProducer<K, V, Produced<V>> {
    private static final Function<Map.Entry<Object, Producer<Object>>, ListenableFuture<Map.Entry<Object, Produced<Object>>>> ENTRY_UNWRAPPER = new Function<Map.Entry<Object, Producer<Object>>, ListenableFuture<Map.Entry<Object, Produced<Object>>>>(){

        public ListenableFuture<Map.Entry<Object, Produced<Object>>> apply(final Map.Entry<Object, Producer<Object>> entry) {
            return Futures.transform(Producers.createFutureProduced(entry.getValue().get()), (Function)new Function<Produced<Object>, Map.Entry<Object, Produced<Object>>>(){

                public Map.Entry<Object, Produced<Object>> apply(Produced<Object> value) {
                    return Maps.immutableEntry(entry.getKey(), value);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    };

    private MapOfProducedProducer(ImmutableMap<K, Producer<V>> contributingMap) {
        super(contributingMap);
    }

    @Override
    public ListenableFuture<Map<K, Produced<V>>> compute() {
        return Futures.transform((ListenableFuture)Futures.allAsList((Iterable)Iterables.transform((Iterable)this.contributingMap().entrySet(), MapOfProducedProducer.entryUnwrapper())), (Function)new Function<List<Map.Entry<K, Produced<V>>>, Map<K, Produced<V>>>(){

            public Map<K, Produced<V>> apply(List<Map.Entry<K, Produced<V>>> entries) {
                return ImmutableMap.copyOf(entries);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static <K, V> Function<Map.Entry<K, Producer<V>>, ListenableFuture<Map.Entry<K, Produced<V>>>> entryUnwrapper() {
        return ENTRY_UNWRAPPER;
    }

    public static <K, V> Builder<K, V> builder(int size) {
        return new Builder(size);
    }

    public static final class Builder<K, V>
    extends AbstractMapProducer.Builder<K, V, Produced<V>> {
        private Builder(int size) {
            super(size);
        }

        public Builder<K, V> put(K key, Producer<V> producerOfValue) {
            super.put(key, producerOfValue);
            return this;
        }

        public Builder<K, V> put(K key, Provider<V> providerOfValue) {
            super.put(key, providerOfValue);
            return this;
        }

        @Deprecated
        public Builder<K, V> put(K key, javax.inject.Provider<V> providerOfValue) {
            return this.put((Object)key, Providers.asDaggerProvider(providerOfValue));
        }

        public Builder<K, V> putAll(Producer<Map<K, Produced<V>>> mapOfProducedProducer) {
            super.putAll(mapOfProducedProducer);
            return this;
        }

        public MapOfProducedProducer<K, V> build() {
            return new MapOfProducedProducer(this.mapBuilder.build());
        }
    }
}

