/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import dagger.producers.internal.DelegateProducer;
import dagger.producers.internal.Producers;
import java.util.Map;
import javax.inject.Provider;

abstract class AbstractMapProducer<K, V, V2>
extends AbstractProducer<Map<K, V2>> {
    private final ImmutableMap<K, Producer<V>> contributingMap;

    AbstractMapProducer(ImmutableMap<K, Producer<V>> contributingMap) {
        this.contributingMap = contributingMap;
    }

    final ImmutableMap<K, Producer<V>> contributingMap() {
        return this.contributingMap;
    }

    public static abstract class Builder<K, V, V2> {
        final ImmutableMap.Builder<K, Producer<V>> mapBuilder;

        Builder(int size) {
            this.mapBuilder = ImmutableMap.builderWithExpectedSize((int)size);
        }

        Builder<K, V, V2> put(K key, Producer<V> producerOfValue) {
            Preconditions.checkNotNull(key, (Object)"key");
            Preconditions.checkNotNull(producerOfValue, (Object)"producer of value");
            this.mapBuilder.put(key, producerOfValue);
            return this;
        }

        Builder<K, V, V2> put(K key, Provider<V> providerOfValue) {
            Preconditions.checkNotNull(key, (Object)"key");
            Preconditions.checkNotNull(providerOfValue, (Object)"provider of value");
            this.mapBuilder.put(key, Producers.producerFromProvider(providerOfValue));
            return this;
        }

        Builder<K, V, V2> putAll(Producer<Map<K, V2>> mapOfProducers) {
            if (mapOfProducers instanceof DelegateProducer) {
                DelegateProducer asDelegateProducer = (DelegateProducer)mapOfProducers;
                return this.putAll(asDelegateProducer.getDelegate());
            }
            AbstractMapProducer asAbstractMapProducer = (AbstractMapProducer)mapOfProducers;
            this.mapBuilder.putAll((Map)asAbstractMapProducer.contributingMap);
            return this;
        }
    }
}

