/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dagger.producers.Producer;
import dagger.producers.internal.CancellableProducer;
import dagger.producers.internal.CancellationListener;
import java.util.Collections;
import java.util.Set;

public abstract class DependencyMethodProducer<T>
implements CancellableProducer<T> {
    private final Set<ListenableFuture<T>> futures = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private boolean cancelled = false;

    protected abstract ListenableFuture<T> callDependencyMethod();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ListenableFuture<T> get() {
        Set<ListenableFuture<T>> set = this.futures;
        synchronized (set) {
            if (this.cancelled) {
                return Futures.immediateCancelledFuture();
            }
            final ListenableFuture<T> future = this.callDependencyMethod();
            if (!future.isDone() && this.futures.add(future)) {
                future.addListener(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Set set = DependencyMethodProducer.this.futures;
                        synchronized (set) {
                            DependencyMethodProducer.this.futures.remove(future);
                        }
                    }
                }, MoreExecutors.directExecutor());
            }
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancel(boolean mayInterruptIfRunning) {
        Set<ListenableFuture<T>> set = this.futures;
        synchronized (set) {
            this.cancelled = true;
            for (ListenableFuture<T> future : this.futures) {
                future.cancel(mayInterruptIfRunning);
            }
        }
    }

    @Override
    public final Producer<T> newDependencyView() {
        return this;
    }

    @Override
    public final Producer<T> newEntryPointView(final CancellationListener cancellationListener) {
        return new Producer<T>(){
            private final Set<ListenableFuture<T>> entryPointFutures = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());

            @Override
            public ListenableFuture<T> get() {
                final ListenableFuture future = DependencyMethodProducer.this.get();
                if (!future.isDone() && this.entryPointFutures.add(future)) {
                    future.addListener(new Runnable(){

                        @Override
                        public void run() {
                            entryPointFutures.remove(future);
                            if (future.isCancelled()) {
                                cancellationListener.onProducerFutureCancelled(true);
                            }
                        }
                    }, MoreExecutors.directExecutor());
                }
                return future;
            }
        };
    }
}

