/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import dagger.producers.internal.Producers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.inject.Provider;

public final class MapProducer<K, V>
extends AbstractProducer<Map<K, V>> {
    private final ImmutableMap<K, Producer<V>> contributingMap;

    private MapProducer(ImmutableMap<K, Producer<V>> contributingMap) {
        this.contributingMap = contributingMap;
    }

    public static <K, V> Builder<K, V> builder(int size) {
        return new Builder(size);
    }

    @Override
    protected ListenableFuture<Map<K, V>> compute() {
        ArrayList<ListenableFuture> listOfEntries = new ArrayList<ListenableFuture>();
        for (final Map.Entry entry : this.contributingMap.entrySet()) {
            listOfEntries.add(Futures.transform(((Producer)entry.getValue()).get(), (Function)new Function<V, Map.Entry<K, V>>(){

                public Map.Entry<K, V> apply(V computedValue) {
                    return Maps.immutableEntry(entry.getKey(), computedValue);
                }
            }, (Executor)MoreExecutors.directExecutor()));
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(listOfEntries), (Function)new Function<List<Map.Entry<K, V>>, Map<K, V>>(){

            public Map<K, V> apply(List<Map.Entry<K, V>> entries) {
                return ImmutableMap.copyOf(entries);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public static final class Builder<K, V> {
        private final ImmutableMap.Builder<K, Producer<V>> mapBuilder;

        private Builder(int size) {
            this.mapBuilder = ImmutableMap.builderWithExpectedSize((int)size);
        }

        public Builder<K, V> put(K key, Producer<V> producerOfValue) {
            Preconditions.checkNotNull(key, (Object)"key");
            Preconditions.checkNotNull(producerOfValue, (Object)"producer of value");
            this.mapBuilder.put(key, producerOfValue);
            return this;
        }

        public Builder<K, V> put(K key, Provider<V> providerOfValue) {
            Preconditions.checkNotNull(key, (Object)"key");
            Preconditions.checkNotNull(providerOfValue, (Object)"provider of value");
            this.mapBuilder.put(key, Producers.producerFromProvider(providerOfValue));
            return this;
        }

        public Builder<K, V> putAll(Producer<Map<K, V>> mapProducer) {
            this.mapBuilder.putAll((Map)((MapProducer)mapProducer).contributingMap);
            return this;
        }

        public MapProducer<K, V> build() {
            return new MapProducer(this.mapBuilder.build());
        }
    }
}

