/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import dagger.producers.internal.Producers;
import java.util.Map;
import javax.inject.Provider;

public final class MapOfProducerProducer<K, V>
extends AbstractProducer<Map<K, Producer<V>>> {
    private final ImmutableMap<K, Producer<V>> contributingMap;

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    private MapOfProducerProducer(ImmutableMap<K, Producer<V>> contributingMap) {
        this.contributingMap = contributingMap;
    }

    @Override
    public ListenableFuture<Map<K, Producer<V>>> compute() {
        return Futures.immediateFuture(this.contributingMap);
    }

    public static final class Builder<K, V> {
        private final ImmutableMap.Builder<K, Producer<V>> mapBuilder = ImmutableMap.builder();

        public Builder<K, V> put(K key, Producer<V> producerOfValue) {
            Preconditions.checkNotNull(key, (Object)"key");
            Preconditions.checkNotNull(producerOfValue, (Object)"producer of value");
            this.mapBuilder.put(key, producerOfValue);
            return this;
        }

        public Builder<K, V> put(K key, Provider<V> providerOfValue) {
            Preconditions.checkNotNull(key, (Object)"key");
            Preconditions.checkNotNull(providerOfValue, (Object)"provider of value");
            this.mapBuilder.put(key, Producers.producerFromProvider(providerOfValue));
            return this;
        }

        public MapOfProducerProducer<K, V> build() {
            return new MapOfProducerProducer(this.mapBuilder.build());
        }
    }
}

