/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutionException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
public abstract class Produced<T> {
    public abstract T get() throws ExecutionException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static <T> Produced<T> successful(@Nullable T value) {
        return new Successful(value);
    }

    public static <T> Produced<T> failed(Throwable throwable) {
        return new Failed((Throwable)Preconditions.checkNotNull((Object)throwable));
    }

    private Produced() {
    }

    private static final class Failed<T>
    extends Produced<T> {
        private final Throwable throwable;

        private Failed(Throwable throwable) {
            this.throwable = (Throwable)Preconditions.checkNotNull((Object)throwable);
        }

        @Override
        public T get() throws ExecutionException {
            throw new ExecutionException(this.throwable);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Failed) {
                Failed that = (Failed)o;
                return this.throwable.equals(that.throwable);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.throwable.hashCode();
        }
    }

    private static final class Successful<T>
    extends Produced<T> {
        @Nullable
        private final T value;

        private Successful(@Nullable T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Successful) {
                Successful that = (Successful)o;
                return Objects.equal(this.value, that.value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }
    }
}

