/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.ComponentProcessor;
import dagger.internal.codegen.SourceFileGenerationException;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;

abstract class SourceFileGenerator<T> {
    private static final String GENERATED_COMMENTS = "https://google.github.io/dagger";
    private static final AnnotationSpec GENERATED = AnnotationSpec.builder(Generated.class).addMember("value", "$S", ComponentProcessor.class.getName()).addMember("comments", "$S", "https://google.github.io/dagger").build();
    private final Filer filer;
    private final boolean generatedAnnotationAvailable;

    SourceFileGenerator(Filer filer, Elements elements) {
        this.filer = (Filer)Preconditions.checkNotNull((Object)filer);
        this.generatedAnnotationAvailable = elements.getTypeElement("javax.annotation.Generated") != null;
    }

    void generate(T input, Messager messager) {
        try {
            this.generate(input);
        }
        catch (SourceFileGenerationException e) {
            e.printMessageTo(messager);
        }
    }

    void generate(T input) throws SourceFileGenerationException {
        ClassName generatedTypeName = this.nameGeneratedType(input);
        Optional<TypeSpec.Builder> type = this.write(generatedTypeName, input);
        if (!type.isPresent()) {
            return;
        }
        try {
            this.buildJavaFile(generatedTypeName, (TypeSpec.Builder)type.get()).writeTo(this.filer);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, SourceFileGenerationException.class);
            throw new SourceFileGenerationException((Optional<ClassName>)Optional.absent(), e, this.getElementForErrorReporting(input));
        }
    }

    private JavaFile buildJavaFile(ClassName generatedTypeName, TypeSpec.Builder typeSpecBuilder) {
        if (this.generatedAnnotationAvailable) {
            typeSpecBuilder.addAnnotation(GENERATED);
        }
        JavaFile.Builder javaFileBuilder = JavaFile.builder(generatedTypeName.packageName(), typeSpecBuilder.build()).skipJavaLangImports(true);
        if (!this.generatedAnnotationAvailable) {
            javaFileBuilder.addFileComment("Generated by $L ($L).", ComponentProcessor.class.getName(), GENERATED_COMMENTS);
        }
        return javaFileBuilder.build();
    }

    abstract ClassName nameGeneratedType(T var1);

    abstract Optional<? extends Element> getElementForErrorReporting(T var1);

    abstract Optional<TypeSpec.Builder> write(ClassName var1, T var2);
}

