/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeTraverser;
import dagger.internal.codegen.AutoValue_BindingGraph;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.InjectBindingRegistry;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.MultibindingDeclaration;
import dagger.internal.codegen.OptionalBindingDeclaration;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.Scope;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.internal.codegen.Util;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

abstract class BindingGraph {
    private static final TreeTraverser<BindingGraph> SUBGRAPH_TRAVERSER = new TreeTraverser<BindingGraph>(){

        public Iterable<BindingGraph> children(BindingGraph node) {
            return node.subgraphs();
        }
    };

    BindingGraph() {
    }

    abstract ComponentDescriptor componentDescriptor();

    abstract ImmutableMap<BindingKey, ResolvedBindings> resolvedBindings();

    abstract ImmutableSet<BindingGraph> subgraphs();

    ImmutableSet<ResolvedBindings> resolvedDependencies(ContributionBinding binding) {
        return binding.dependencies().stream().map(dependencyRequest -> (ResolvedBindings)this.resolvedBindings().getOrDefault((Object)dependencyRequest.bindingKey(), (Object)ResolvedBindings.noBindings(dependencyRequest.bindingKey(), this.componentDescriptor()))).collect(Util.toImmutableSet());
    }

    TypeElement componentType() {
        return this.componentDescriptor().componentDefinitionType();
    }

    abstract ImmutableSet<ModuleDescriptor> ownedModules();

    ImmutableSet<TypeElement> ownedModuleTypes() {
        return FluentIterable.from(this.ownedModules()).transform(ModuleDescriptor::moduleElement).toSet();
    }

    ImmutableSet<TypeElement> componentRequirements() {
        return SUBGRAPH_TRAVERSER.preOrderTraversal((Object)this).transformAndConcat(graph -> graph.resolvedBindings().values()).transformAndConcat(ResolvedBindings::contributionBindings).filter(ContributionBinding::requiresModuleInstance).transformAndConcat(bindingDeclaration -> bindingDeclaration.contributingModule().asSet()).filter(Predicates.in(this.ownedModuleTypes())).append(this.componentDescriptor().dependencies()).toSet();
    }

    ImmutableSet<ComponentDescriptor> componentDescriptors() {
        return SUBGRAPH_TRAVERSER.preOrderTraversal((Object)this).transform(BindingGraph::componentDescriptor).toSet();
    }

    ImmutableSet<TypeElement> availableDependencies() {
        return FluentIterable.from(this.componentDescriptor().transitiveModuleTypes()).filter(Predicates.not(MoreElements.hasModifiers(Modifier.ABSTRACT))).append(this.componentDescriptor().dependencies()).toSet();
    }

    static final class Factory {
        private final Elements elements;
        private final InjectBindingRegistry injectBindingRegistry;
        private final Key.Factory keyFactory;
        private final ProvisionBinding.Factory provisionBindingFactory;
        private final ProductionBinding.Factory productionBindingFactory;

        Factory(Elements elements, InjectBindingRegistry injectBindingRegistry, Key.Factory keyFactory, ProvisionBinding.Factory provisionBindingFactory, ProductionBinding.Factory productionBindingFactory) {
            this.elements = elements;
            this.injectBindingRegistry = injectBindingRegistry;
            this.keyFactory = keyFactory;
            this.provisionBindingFactory = provisionBindingFactory;
            this.productionBindingFactory = productionBindingFactory;
        }

        BindingGraph create(ComponentDescriptor componentDescriptor) {
            return this.create((Optional<Resolver>)Optional.absent(), componentDescriptor);
        }

        private BindingGraph create(Optional<Resolver> parentResolver, ComponentDescriptor componentDescriptor) {
            ImmutableSet.Builder explicitBindingsBuilder = ImmutableSet.builder();
            ImmutableSet.Builder delegatesBuilder = ImmutableSet.builder();
            ImmutableSet.Builder optionalsBuilder = ImmutableSet.builder();
            explicitBindingsBuilder.add((Object)this.provisionBindingFactory.forComponent(componentDescriptor.componentDefinitionType()));
            for (TypeElement componentDependency : componentDescriptor.dependencies()) {
                explicitBindingsBuilder.add((Object)this.provisionBindingFactory.forComponent(componentDependency));
                List<ExecutableElement> dependencyMethods = ElementFilter.methodsIn(this.elements.getAllMembers(componentDependency));
                for (ExecutableElement method : dependencyMethods) {
                    if (!ComponentDescriptor.isComponentContributionMethod(this.elements, method)) continue;
                    explicitBindingsBuilder.add((Object)(componentDescriptor.kind().equals((Object)ComponentDescriptor.Kind.PRODUCTION_COMPONENT) && ComponentDescriptor.isComponentProductionMethod(this.elements, method) ? this.productionBindingFactory.forComponentMethod(method) : this.provisionBindingFactory.forComponentMethod(method)));
                }
            }
            for (Map.Entry componentMethodAndSubcomponent : componentDescriptor.subcomponentsByBuilderMethod().entrySet()) {
                ComponentDescriptor.ComponentMethodDescriptor componentMethod = (ComponentDescriptor.ComponentMethodDescriptor)componentMethodAndSubcomponent.getKey();
                ComponentDescriptor subcomponentDescriptor = (ComponentDescriptor)componentMethodAndSubcomponent.getValue();
                if (componentDescriptor.subcomponentsFromModules().contains((Object)subcomponentDescriptor)) continue;
                explicitBindingsBuilder.add((Object)this.provisionBindingFactory.forSubcomponentBuilderMethod(componentMethod.methodElement(), componentDescriptor.componentDefinitionType()));
            }
            ImmutableSet.Builder multibindingDeclarations = ImmutableSet.builder();
            ImmutableSet.Builder subcomponentDeclarations = ImmutableSet.builder();
            for (ModuleDescriptor moduleDescriptor : componentDescriptor.transitiveModules()) {
                explicitBindingsBuilder.addAll(moduleDescriptor.bindings());
                multibindingDeclarations.addAll(moduleDescriptor.multibindingDeclarations());
                subcomponentDeclarations.addAll(moduleDescriptor.subcomponentDeclarations());
                delegatesBuilder.addAll(moduleDescriptor.delegateDeclarations());
                optionalsBuilder.addAll(moduleDescriptor.optionalDeclarations());
            }
            for (Scope scope : componentDescriptor.releasableReferencesScopes()) {
                explicitBindingsBuilder.add((Object)this.provisionBindingFactory.provideReleasableReferenceManager(scope));
                explicitBindingsBuilder.add((Object)this.provisionBindingFactory.provideSetOfReleasableReferenceManagers());
                for (AnnotationMirror metadata : scope.releasableReferencesMetadata()) {
                    explicitBindingsBuilder.add((Object)this.provisionBindingFactory.provideTypedReleasableReferenceManager(scope, metadata.getAnnotationType()));
                    explicitBindingsBuilder.add((Object)this.provisionBindingFactory.provideSetOfTypedReleasableReferenceManagers(metadata.getAnnotationType()));
                }
            }
            Resolver requestResolver = new Resolver(parentResolver, componentDescriptor, Key.indexByKey(explicitBindingsBuilder.build()), Key.indexByKey(multibindingDeclarations.build()), Key.indexByKey(subcomponentDeclarations.build()), Key.indexByKey(delegatesBuilder.build()), Key.indexByKey(optionalsBuilder.build()));
            for (ComponentDescriptor.ComponentMethodDescriptor componentMethod : componentDescriptor.componentMethods()) {
                Optional<DependencyRequest> componentMethodRequest = componentMethod.dependencyRequest();
                if (!componentMethodRequest.isPresent()) continue;
                requestResolver.resolve(((DependencyRequest)componentMethodRequest.get()).bindingKey());
            }
            HashSet<ComponentDescriptor> resolvedSubcomponents = new HashSet<ComponentDescriptor>();
            ImmutableSet.Builder subgraphs = ImmutableSet.builder();
            for (ComponentDescriptor subcomponent : Iterables.consumingIterable(requestResolver.subcomponentsToResolve)) {
                if (!resolvedSubcomponents.add(subcomponent)) continue;
                subgraphs.add((Object)this.create((Optional<Resolver>)Optional.of((Object)requestResolver), subcomponent));
            }
            for (ResolvedBindings resolvedBindings : requestResolver.getResolvedBindings().values()) {
                Verify.verify((boolean)resolvedBindings.owningComponent().equals(componentDescriptor), (String)"%s is not owned by %s", (Object[])new Object[]{resolvedBindings, componentDescriptor});
            }
            return new AutoValue_BindingGraph(componentDescriptor, requestResolver.getResolvedBindings(), (ImmutableSet<BindingGraph>)subgraphs.build(), requestResolver.getOwnedModules());
        }

        static <T extends Key.HasKey> ImmutableSetMultimap<Key, T> multibindingContributionsByMultibindingKey(Iterable<T> declarations) {
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (Key.HasKey declaration : declarations) {
                if (!declaration.key().multibindingContributionIdentifier().isPresent()) continue;
                builder.put((Object)declaration.key().withoutMultibindingContributionIdentifier(), (Object)declaration);
            }
            return builder.build();
        }

        private final class Resolver {
            final Optional<Resolver> parentResolver;
            final ComponentDescriptor componentDescriptor;
            final ImmutableSetMultimap<Key, ContributionBinding> explicitBindings;
            final ImmutableSet<ContributionBinding> explicitBindingsSet;
            final ImmutableSetMultimap<Key, ContributionBinding> explicitMultibindings;
            final ImmutableSetMultimap<Key, MultibindingDeclaration> multibindingDeclarations;
            final ImmutableSetMultimap<Key, SubcomponentDeclaration> subcomponentDeclarations;
            final ImmutableSetMultimap<Key, DelegateDeclaration> delegateDeclarations;
            final ImmutableSetMultimap<Key, OptionalBindingDeclaration> optionalBindingDeclarations;
            final ImmutableSetMultimap<Key, DelegateDeclaration> delegateMultibindingDeclarations;
            final Map<BindingKey, ResolvedBindings> resolvedBindings;
            final Deque<BindingKey> cycleStack = new ArrayDeque<BindingKey>();
            final Cache<BindingKey, Boolean> bindingKeyDependsOnLocalBindingsCache = CacheBuilder.newBuilder().build();
            final Cache<Binding, Boolean> bindingDependsOnLocalBindingsCache = CacheBuilder.newBuilder().build();
            final Queue<ComponentDescriptor> subcomponentsToResolve = new ArrayDeque<ComponentDescriptor>();

            Resolver(Optional<Resolver> parentResolver, ComponentDescriptor componentDescriptor, ImmutableSetMultimap<Key, ContributionBinding> explicitBindings, ImmutableSetMultimap<Key, MultibindingDeclaration> multibindingDeclarations, ImmutableSetMultimap<Key, SubcomponentDeclaration> subcomponentDeclarations, ImmutableSetMultimap<Key, DelegateDeclaration> delegateDeclarations, ImmutableSetMultimap<Key, OptionalBindingDeclaration> optionalBindingDeclarations) {
                this.parentResolver = (Optional)Preconditions.checkNotNull(parentResolver);
                this.componentDescriptor = (ComponentDescriptor)Preconditions.checkNotNull((Object)componentDescriptor);
                this.explicitBindings = (ImmutableSetMultimap)Preconditions.checkNotNull(explicitBindings);
                this.explicitBindingsSet = ImmutableSet.copyOf((Collection)explicitBindings.values());
                this.multibindingDeclarations = (ImmutableSetMultimap)Preconditions.checkNotNull(multibindingDeclarations);
                this.subcomponentDeclarations = (ImmutableSetMultimap)Preconditions.checkNotNull(subcomponentDeclarations);
                this.delegateDeclarations = (ImmutableSetMultimap)Preconditions.checkNotNull(delegateDeclarations);
                this.optionalBindingDeclarations = (ImmutableSetMultimap)Preconditions.checkNotNull(optionalBindingDeclarations);
                this.resolvedBindings = Maps.newLinkedHashMap();
                this.explicitMultibindings = Factory.multibindingContributionsByMultibindingKey(this.explicitBindingsSet);
                this.delegateMultibindingDeclarations = Factory.multibindingContributionsByMultibindingKey(delegateDeclarations.values());
                this.subcomponentsToResolve.addAll((Collection<ComponentDescriptor>)componentDescriptor.subcomponentsFromEntryPoints());
            }

            ResolvedBindings lookUpBindings(BindingKey bindingKey) {
                Key requestKey = bindingKey.key();
                switch (bindingKey.kind()) {
                    case CONTRIBUTION: {
                        LinkedHashSet<Object> contributionBindings = new LinkedHashSet<Object>();
                        ImmutableSet.Builder multibindingContributionsBuilder = ImmutableSet.builder();
                        ImmutableSet.Builder multibindingDeclarationsBuilder = ImmutableSet.builder();
                        ImmutableSet.Builder subcomponentDeclarationsBuilder = ImmutableSet.builder();
                        ImmutableSet.Builder optionalBindingDeclarationsBuilder = ImmutableSet.builder();
                        for (Key key : this.keysMatchingRequest(requestKey)) {
                            contributionBindings.addAll((Collection<Object>)this.getExplicitBindings(key));
                            multibindingContributionsBuilder.addAll(this.getExplicitMultibindings(key));
                            multibindingDeclarationsBuilder.addAll(this.getMultibindingDeclarations(key));
                            subcomponentDeclarationsBuilder.addAll(this.getSubcomponentDeclarations(key));
                            optionalBindingDeclarationsBuilder.addAll(this.getOptionalBindingDeclarations(key));
                        }
                        ImmutableSet multibindingContributions = multibindingContributionsBuilder.build();
                        ImmutableSet multibindingDeclarations = multibindingDeclarationsBuilder.build();
                        ImmutableSet subcomponentDeclarations = subcomponentDeclarationsBuilder.build();
                        ImmutableSet optionalBindingDeclarations = optionalBindingDeclarationsBuilder.build();
                        contributionBindings.addAll(this.syntheticMapOfValuesBinding(requestKey).asSet());
                        contributionBindings.addAll(this.syntheticMultibinding(requestKey, (Iterable<ContributionBinding>)multibindingContributions, (Iterable<MultibindingDeclaration>)multibindingDeclarations).asSet());
                        Optional<ProvisionBinding> subcomponentBuilderBinding = this.syntheticSubcomponentBuilderBinding((ImmutableSet<SubcomponentDeclaration>)subcomponentDeclarations);
                        if (subcomponentBuilderBinding.isPresent()) {
                            contributionBindings.add(subcomponentBuilderBinding.get());
                            this.addSubcomponentToOwningResolver((ProvisionBinding)subcomponentBuilderBinding.get());
                        }
                        contributionBindings.addAll(this.syntheticOptionalBinding(requestKey, (ImmutableSet<OptionalBindingDeclaration>)optionalBindingDeclarations).asSet());
                        if (contributionBindings.isEmpty()) {
                            contributionBindings.addAll(Factory.this.injectBindingRegistry.getOrFindProvisionBinding(requestKey).asSet());
                        }
                        return ResolvedBindings.forContributionBindings(bindingKey, this.componentDescriptor, this.indexBindingsByOwningComponent(bindingKey, (Iterable<? extends ContributionBinding>)ImmutableSet.copyOf(contributionBindings)), (Iterable<MultibindingDeclaration>)multibindingDeclarations, (Iterable<SubcomponentDeclaration>)subcomponentDeclarations, (Iterable<OptionalBindingDeclaration>)optionalBindingDeclarations);
                    }
                    case MEMBERS_INJECTION: {
                        Optional<MembersInjectionBinding> binding = Factory.this.injectBindingRegistry.getOrFindMembersInjectionBinding(requestKey);
                        return binding.isPresent() ? ResolvedBindings.forMembersInjectionBinding(bindingKey, this.componentDescriptor, (MembersInjectionBinding)binding.get()) : ResolvedBindings.noBindings(bindingKey, this.componentDescriptor);
                    }
                }
                throw new AssertionError();
            }

            private void addSubcomponentToOwningResolver(ProvisionBinding subcomponentBuilderBinding) {
                Preconditions.checkArgument((boolean)subcomponentBuilderBinding.bindingKind().equals((Object)ContributionBinding.Kind.SUBCOMPONENT_BUILDER));
                Resolver owningResolver = (Resolver)this.getOwningResolver(subcomponentBuilderBinding).get();
                TypeElement builderType = MoreTypes.asTypeElement(subcomponentBuilderBinding.key().type());
                owningResolver.subcomponentsToResolve.add((ComponentDescriptor)owningResolver.componentDescriptor.subcomponentsByBuilderType().get((Object)builderType));
            }

            private Iterable<Key> keysMatchingRequest(Key requestKey) {
                return ImmutableSet.builder().add((Object)requestKey).addAll((Iterable)Factory.this.keyFactory.unwrapSetKey(requestKey, Produced.class).asSet()).addAll((Iterable)Factory.this.keyFactory.rewrapMapKey(requestKey, Producer.class, Provider.class).asSet()).addAll((Iterable)Factory.this.keyFactory.rewrapMapKey(requestKey, Provider.class, Producer.class).asSet()).build();
            }

            private Optional<ContributionBinding> syntheticMapOfValuesBinding(Key key) {
                return this.syntheticMultibinding(key, (Iterable<ContributionBinding>)this.multibindingContributionsForValueMap(key), (Iterable<MultibindingDeclaration>)this.multibindingDeclarationsForValueMap(key)).transform(syntheticMultibinding -> {
                    switch (syntheticMultibinding.bindingType()) {
                        case PROVISION: {
                            return Factory.this.provisionBindingFactory.syntheticMapOfValuesBinding(key);
                        }
                        case PRODUCTION: {
                            return Factory.this.productionBindingFactory.syntheticMapOfValuesOrProducedBinding(key);
                        }
                    }
                    throw new VerifyException(syntheticMultibinding.toString());
                });
            }

            private FluentIterable<ContributionBinding> multibindingContributionsForValueMap(Key key) {
                return Factory.this.keyFactory.implicitFrameworkMapKeys(key).transformAndConcat(this::getExplicitMultibindings);
            }

            private FluentIterable<MultibindingDeclaration> multibindingDeclarationsForValueMap(Key key) {
                return Factory.this.keyFactory.implicitFrameworkMapKeys(key).transformAndConcat(this::getMultibindingDeclarations);
            }

            private Optional<? extends ContributionBinding> syntheticMultibinding(Key key, Iterable<ContributionBinding> multibindingContributions, Iterable<MultibindingDeclaration> multibindingDeclarations) {
                if (Iterables.isEmpty(multibindingContributions) && Iterables.isEmpty(multibindingDeclarations)) {
                    return Optional.absent();
                }
                if (this.multibindingsRequireProduction(multibindingContributions, key)) {
                    return Optional.of((Object)Factory.this.productionBindingFactory.syntheticMultibinding(key, multibindingContributions));
                }
                return Optional.of((Object)Factory.this.provisionBindingFactory.syntheticMultibinding(key, multibindingContributions));
            }

            private boolean multibindingsRequireProduction(Iterable<ContributionBinding> multibindingContributions, Key key) {
                MapType mapType;
                if (MapType.isMap(key) ? (mapType = MapType.from(key)).valuesAreTypeOf(Producer.class) || mapType.valuesAreTypeOf(Produced.class) : SetType.isSet(key) && SetType.from(key).elementsAreTypeOf(Produced.class)) {
                    return true;
                }
                return Iterables.any(multibindingContributions, hasBindingType -> hasBindingType.bindingType().equals((Object)BindingType.PRODUCTION));
            }

            private Optional<ProvisionBinding> syntheticSubcomponentBuilderBinding(ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations) {
                return subcomponentDeclarations.isEmpty() ? Optional.absent() : Optional.of((Object)Factory.this.provisionBindingFactory.syntheticSubcomponentBuilder(subcomponentDeclarations));
            }

            private Optional<? extends ContributionBinding> syntheticOptionalBinding(Key key, ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations) {
                if (optionalBindingDeclarations.isEmpty()) {
                    return Optional.absent();
                }
                ResolvedBindings underlyingKeyBindings = this.lookUpBindings(BindingKey.contribution((Key)Factory.this.keyFactory.unwrapOptional(key).get()));
                if (underlyingKeyBindings.isEmpty()) {
                    return Optional.of((Object)Factory.this.provisionBindingFactory.syntheticAbsentBinding(key));
                }
                if (underlyingKeyBindings.bindingTypes().contains((Object)BindingType.PRODUCTION)) {
                    return Optional.of((Object)Factory.this.productionBindingFactory.syntheticPresentBinding(key));
                }
                return Optional.of((Object)Factory.this.provisionBindingFactory.syntheticPresentBinding(key));
            }

            private ImmutableSet<ContributionBinding> createDelegateBindings(ImmutableSet<DelegateDeclaration> delegateDeclarations) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (DelegateDeclaration delegateDeclaration : delegateDeclarations) {
                    builder.add((Object)this.createDelegateBinding(delegateDeclaration));
                }
                return builder.build();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private ContributionBinding createDelegateBinding(DelegateDeclaration delegateDeclaration) {
                ResolvedBindings resolvedDelegate;
                BindingKey delegateBindingKey = delegateDeclaration.delegateRequest().bindingKey();
                if (this.cycleStack.contains(delegateBindingKey)) {
                    return Factory.this.provisionBindingFactory.missingDelegate(delegateDeclaration);
                }
                try {
                    this.cycleStack.push(delegateBindingKey);
                    resolvedDelegate = this.lookUpBindings(delegateBindingKey);
                }
                finally {
                    this.cycleStack.pop();
                }
                if (resolvedDelegate.contributionBindings().isEmpty()) {
                    return Factory.this.provisionBindingFactory.missingDelegate(delegateDeclaration);
                }
                ContributionBinding explicitDelegate = (ContributionBinding)resolvedDelegate.contributionBindings().iterator().next();
                switch (explicitDelegate.bindingType()) {
                    case PRODUCTION: {
                        return Factory.this.productionBindingFactory.delegate(delegateDeclaration, (ProductionBinding)explicitDelegate);
                    }
                    case PROVISION: {
                        return Factory.this.provisionBindingFactory.delegate(delegateDeclaration, (ProvisionBinding)explicitDelegate);
                    }
                }
                throw new AssertionError((Object)("bindingType: " + explicitDelegate));
            }

            private ImmutableSetMultimap<ComponentDescriptor, ContributionBinding> indexBindingsByOwningComponent(BindingKey bindingKey, Iterable<? extends ContributionBinding> bindings) {
                ImmutableSetMultimap.Builder index = ImmutableSetMultimap.builder();
                for (ContributionBinding contributionBinding : bindings) {
                    index.put((Object)this.getOwningComponent(bindingKey, contributionBinding), (Object)contributionBinding);
                }
                return index.build();
            }

            private ComponentDescriptor getOwningComponent(BindingKey bindingKey, ContributionBinding binding) {
                if (this.isResolvedInParent(bindingKey, binding) && !new LocalDependencyChecker().dependsOnLocalBindings(binding)) {
                    ResolvedBindings parentResolvedBindings = ((Resolver)this.parentResolver.get()).resolvedBindings.get(bindingKey);
                    return parentResolvedBindings.owningComponent(binding);
                }
                return this.componentDescriptor;
            }

            private boolean isResolvedInParent(BindingKey bindingKey, ContributionBinding binding) {
                Optional<Resolver> owningResolver = this.getOwningResolver(binding);
                if (owningResolver.isPresent() && !((Resolver)owningResolver.get()).equals(this)) {
                    ((Resolver)this.parentResolver.get()).resolve(bindingKey);
                    return true;
                }
                return false;
            }

            private Optional<Resolver> getOwningResolver(ContributionBinding binding) {
                if (binding.scope().isPresent() && ((Scope)binding.scope().get()).equals(Scope.reusableScope(Factory.this.elements))) {
                    for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                        if (!requestResolver.resolvedBindings.containsKey(BindingKey.contribution(binding.key()))) continue;
                        return Optional.of((Object)requestResolver);
                    }
                    return Optional.absent();
                }
                for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                    if (!requestResolver.explicitBindingsSet.contains((Object)binding) && !requestResolver.subcomponentDeclarations.containsKey((Object)binding.key())) continue;
                    return Optional.of((Object)requestResolver);
                }
                Optional<Scope> bindingScope = binding.scope();
                if (bindingScope.isPresent()) {
                    for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                        if (!requestResolver.componentDescriptor.scopes().contains(bindingScope.get())) continue;
                        return Optional.of((Object)requestResolver);
                    }
                }
                return Optional.absent();
            }

            private ImmutableList<Resolver> getResolverLineage() {
                ArrayList resolverList = Lists.newArrayList();
                Optional<Resolver> currentResolver = Optional.of((Object)this);
                while (currentResolver.isPresent()) {
                    resolverList.add(currentResolver.get());
                    currentResolver = ((Resolver)currentResolver.get()).parentResolver;
                }
                return ImmutableList.copyOf((Collection)Lists.reverse((List)resolverList));
            }

            private ImmutableSet<ContributionBinding> getExplicitBindings(Key key) {
                ImmutableSet.Builder bindings = ImmutableSet.builder();
                for (Resolver resolver : this.getResolverLineage()) {
                    bindings.addAll(resolver.getLocalExplicitBindings(key));
                }
                return bindings.build();
            }

            private ImmutableSet<ContributionBinding> getLocalExplicitBindings(Key key) {
                return new ImmutableSet.Builder().addAll((Iterable)this.explicitBindings.get((Object)key)).addAll(this.createDelegateBindings((ImmutableSet<DelegateDeclaration>)this.delegateDeclarations.get((Object)Factory.this.keyFactory.convertToDelegateKey(key)))).build();
            }

            private ImmutableSet<ContributionBinding> getExplicitMultibindings(Key key) {
                ImmutableSet.Builder multibindings = ImmutableSet.builder();
                for (Resolver resolver : this.getResolverLineage()) {
                    multibindings.addAll(resolver.getLocalExplicitMultibindings(key));
                }
                return multibindings.build();
            }

            private ImmutableSet<ContributionBinding> getLocalExplicitMultibindings(Key key) {
                ImmutableSet.Builder multibindings = ImmutableSet.builder();
                multibindings.addAll((Iterable)this.explicitMultibindings.get((Object)key));
                if (!MapType.isMap(key) || MapType.from(key).valuesAreFrameworkType()) {
                    multibindings.addAll(this.createDelegateBindings((ImmutableSet<DelegateDeclaration>)this.delegateMultibindingDeclarations.get((Object)Factory.this.keyFactory.convertToDelegateKey(key))));
                }
                return multibindings.build();
            }

            private ImmutableSet<MultibindingDeclaration> getMultibindingDeclarations(Key key) {
                ImmutableSet.Builder multibindingDeclarations = ImmutableSet.builder();
                for (Resolver resolver : this.getResolverLineage()) {
                    multibindingDeclarations.addAll((Iterable)resolver.multibindingDeclarations.get((Object)key));
                }
                return multibindingDeclarations.build();
            }

            private ImmutableSet<SubcomponentDeclaration> getSubcomponentDeclarations(Key key) {
                ImmutableSet.Builder subcomponentDeclarations = ImmutableSet.builder();
                for (Resolver resolver : this.getResolverLineage()) {
                    subcomponentDeclarations.addAll((Iterable)resolver.subcomponentDeclarations.get((Object)key));
                }
                return subcomponentDeclarations.build();
            }

            private ImmutableSet<OptionalBindingDeclaration> getOptionalBindingDeclarations(Key key) {
                Optional<Key> unwrapped = Factory.this.keyFactory.unwrapOptional(key);
                if (!unwrapped.isPresent()) {
                    return ImmutableSet.of();
                }
                ImmutableSet.Builder declarations = ImmutableSet.builder();
                for (Resolver resolver : this.getResolverLineage()) {
                    declarations.addAll((Iterable)resolver.optionalBindingDeclarations.get(unwrapped.get()));
                }
                return declarations.build();
            }

            private Optional<ResolvedBindings> getPreviouslyResolvedBindings(BindingKey bindingKey) {
                Optional result = Optional.fromNullable((Object)this.resolvedBindings.get(bindingKey));
                if (result.isPresent()) {
                    return result;
                }
                if (this.parentResolver.isPresent()) {
                    return ((Resolver)this.parentResolver.get()).getPreviouslyResolvedBindings(bindingKey);
                }
                return Optional.absent();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void resolve(BindingKey bindingKey) {
                if (this.cycleStack.contains(bindingKey)) {
                    return;
                }
                if (this.resolvedBindings.containsKey(bindingKey)) {
                    return;
                }
                if (this.getPreviouslyResolvedBindings(bindingKey).isPresent()) {
                    ((Resolver)this.parentResolver.get()).resolve(bindingKey);
                    if (!new LocalDependencyChecker().dependsOnLocalBindings(bindingKey) && this.getLocalExplicitBindings(bindingKey.key()).isEmpty()) {
                        ResolvedBindings inheritedBindings = ((ResolvedBindings)this.getPreviouslyResolvedBindings(bindingKey).get()).asInheritedIn(this.componentDescriptor);
                        this.resolvedBindings.put(bindingKey, inheritedBindings);
                        return;
                    }
                }
                this.cycleStack.push(bindingKey);
                try {
                    ResolvedBindings bindings = this.lookUpBindings(bindingKey);
                    for (Binding binding : bindings.ownedBindings()) {
                        for (DependencyRequest dependency : binding.dependencies()) {
                            this.resolve(dependency.bindingKey());
                        }
                    }
                    this.resolvedBindings.put(bindingKey, bindings);
                }
                finally {
                    this.cycleStack.pop();
                }
            }

            ImmutableMap<BindingKey, ResolvedBindings> getResolvedBindings() {
                ImmutableMap.Builder resolvedBindingsBuilder = ImmutableMap.builder();
                resolvedBindingsBuilder.putAll(this.resolvedBindings);
                if (this.parentResolver.isPresent()) {
                    Collection bindingsResolvedInParent = Maps.difference(((Resolver)this.parentResolver.get()).getResolvedBindings(), this.resolvedBindings).entriesOnlyOnLeft().values();
                    for (ResolvedBindings resolvedInParent : bindingsResolvedInParent) {
                        resolvedBindingsBuilder.put((Object)resolvedInParent.bindingKey(), (Object)resolvedInParent.asInheritedIn(this.componentDescriptor));
                    }
                }
                return resolvedBindingsBuilder.build();
            }

            ImmutableSet<ModuleDescriptor> getInheritedModules() {
                return this.parentResolver.isPresent() ? Sets.union(((Resolver)this.parentResolver.get()).getInheritedModules(), ((Resolver)this.parentResolver.get()).componentDescriptor.transitiveModules()).immutableCopy() : ImmutableSet.of();
            }

            ImmutableSet<ModuleDescriptor> getOwnedModules() {
                return Sets.difference(this.componentDescriptor.transitiveModules(), this.getInheritedModules()).immutableCopy();
            }

            private final class LocalDependencyChecker {
                private final Set<Object> cycleChecker = new HashSet<Object>();

                private LocalDependencyChecker() {
                }

                boolean dependsOnLocalBindings(BindingKey bindingKey) {
                    Preconditions.checkArgument((boolean)Resolver.this.getPreviouslyResolvedBindings(bindingKey).isPresent(), (String)"no previously resolved bindings in %s for %s", (Object)Resolver.this, (Object)bindingKey);
                    if (!this.cycleChecker.add(bindingKey)) {
                        return false;
                    }
                    try {
                        return (Boolean)Resolver.this.bindingKeyDependsOnLocalBindingsCache.get((Object)bindingKey, () -> {
                            ResolvedBindings previouslyResolvedBindings = (ResolvedBindings)Resolver.this.getPreviouslyResolvedBindings(bindingKey).get();
                            if (this.hasLocalMultibindingContributions(previouslyResolvedBindings) || this.hasLocallyPresentOptionalBinding(previouslyResolvedBindings)) {
                                return true;
                            }
                            for (Binding binding : previouslyResolvedBindings.bindings()) {
                                if (!this.dependsOnLocalBindings(binding)) continue;
                                return true;
                            }
                            return false;
                        });
                    }
                    catch (ExecutionException e) {
                        throw new AssertionError((Object)e);
                    }
                }

                boolean dependsOnLocalBindings(Binding binding) {
                    if (!this.cycleChecker.add(binding)) {
                        return false;
                    }
                    try {
                        return (Boolean)Resolver.this.bindingDependsOnLocalBindingsCache.get((Object)binding, () -> {
                            if (!(binding.scope().isPresent() && !((Scope)binding.scope().get()).equals(Scope.reusableScope(Factory.this.elements)) || binding.bindingType().equals((Object)BindingType.PRODUCTION))) {
                                for (DependencyRequest dependency : binding.dependencies()) {
                                    if (!this.dependsOnLocalBindings(dependency.bindingKey())) continue;
                                    return true;
                                }
                            }
                            return false;
                        });
                    }
                    catch (ExecutionException e) {
                        throw new AssertionError((Object)e);
                    }
                }

                private boolean hasLocalMultibindingContributions(ResolvedBindings resolvedBindings) {
                    return resolvedBindings.contributionBindings().stream().map(ContributionBinding::bindingKind).anyMatch(arg_0 -> ContributionBinding.Kind.SYNTHETIC_MULTIBOUND_KINDS.contains(arg_0)) && !Resolver.this.getLocalExplicitMultibindings(resolvedBindings.key()).isEmpty();
                }

                private boolean hasLocallyPresentOptionalBinding(ResolvedBindings resolvedBindings) {
                    return resolvedBindings.contributionBindings().stream().map(ContributionBinding::bindingKind).anyMatch(Predicate.isEqual((Object)ContributionBinding.Kind.SYNTHETIC_OPTIONAL_BINDING)) && !Resolver.this.getLocalExplicitBindings((Key)Factory.this.keyFactory.unwrapOptional(resolvedBindings.key()).get()).isEmpty();
                }
            }
        }
    }
}

