/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XAnnotationValues;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.internal.shaded.com.google.auto.common.AnnotationMirrors;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;

public final class XAnnotations {
    private static final Equivalence<XAnnotation> XANNOTATION_EQUIVALENCE = new Equivalence<XAnnotation>(){

        protected boolean doEquivalent(XAnnotation left, XAnnotation right) {
            return XTypes.equivalence().equivalent((Object)left.getType(), (Object)right.getType()) && XAnnotationValues.equivalence().pairwise().equivalent(left.getAnnotationValues(), right.getAnnotationValues());
        }

        protected int doHash(XAnnotation annotation) {
            return Arrays.hashCode(new int[]{XTypes.equivalence().hash((Object)annotation.getType()), XAnnotationValues.equivalence().pairwise().hash(annotation.getAnnotationValues())});
        }

        public String toString() {
            return "XAnnotation.equivalence()";
        }
    };

    public static AnnotationSpec getAnnotationSpec(XAnnotation annotation) {
        return JavaPoetExtKt.toAnnotationSpec(annotation, false);
    }

    public static String toString(XAnnotation annotation) {
        return XConverters.getProcessingEnv(annotation).getBackend() == XProcessingEnv.Backend.JAVAC ? AnnotationMirrors.toString((AnnotationMirror)XConverters.toJavac(annotation)) : XAnnotations.toStableString(annotation);
    }

    public static ClassName getClassName(XAnnotation annotation) {
        return annotation.getType().getTypeElement().getClassName();
    }

    public static XClassName asClassName(XAnnotation annotation) {
        return annotation.getType().getTypeElement().asClassName();
    }

    public static Equivalence<XAnnotation> equivalence() {
        return XANNOTATION_EQUIVALENCE;
    }

    public static String toStableString(XAnnotation annotation) {
        try {
            if (annotation.getType().isError()) {
                return "@" + annotation.getName();
            }
            return annotation.getAnnotationValues().isEmpty() ? String.format("@%s", XAnnotations.getClassName(annotation).canonicalName()) : String.format("@%s(%s)", XAnnotations.getClassName(annotation).canonicalName(), annotation.getAnnotationValues().stream().map(value -> {
                String name = value.getName();
                String valueAsString = XAnnotationValues.toStableString(value);
                return annotation.getAnnotationValues().size() == 1 && name.contentEquals("value") ? valueAsString : String.format("%s=%s", name, valueAsString);
            }).collect(Collectors.joining(", ")));
        }
        catch (TypeNotPresentException e) {
            return e.typeName();
        }
    }

    public static XTypeElement getAsTypeElement(XAnnotation annotation, String key) {
        return annotation.getAsType(key).getTypeElement();
    }

    public static ImmutableList<XTypeElement> getAsTypeElementList(XAnnotation annotation, String key) {
        return (ImmutableList)annotation.getAsTypeList(key).stream().map(XType::getTypeElement).collect(DaggerStreams.toImmutableList());
    }

    private XAnnotations() {
    }
}

