/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.processingstep.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.InjectValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.HashSet;
import javax.inject.Inject;

final class AssistedInjectProcessingStep
extends TypeCheckingProcessingStep<XConstructorElement> {
    private final InjectValidator injectValidator;

    @Inject
    AssistedInjectProcessingStep(InjectValidator injectValidator) {
        this.injectValidator = injectValidator;
    }

    public ImmutableSet<XClassName> annotationClassNames() {
        return ImmutableSet.of((Object)XTypeNames.ASSISTED_INJECT);
    }

    @Override
    protected void process(XConstructorElement assistedInjectElement, ImmutableSet<XClassName> annotations) {
        if (this.injectValidator.validate(assistedInjectElement.getEnclosingElement()).isClean()) {
            new AssistedInjectValidator().validate(assistedInjectElement).printMessagesTo(this.messager);
        }
    }

    private final class AssistedInjectValidator {
        private AssistedInjectValidator() {
        }

        ValidationReport validate(XConstructorElement constructor) {
            ValidationReport.Builder report = ValidationReport.about(constructor);
            XType assistedInjectType = constructor.getEnclosingElement().getType();
            ImmutableList<AssistedInjectionAnnotations.AssistedParameter> assistedParameters = AssistedInjectionAnnotations.assistedInjectAssistedParameters(assistedInjectType);
            HashSet<AssistedInjectionAnnotations.AssistedParameter> uniqueAssistedParameters = new HashSet<AssistedInjectionAnnotations.AssistedParameter>();
            for (AssistedInjectionAnnotations.AssistedParameter assistedParameter : assistedParameters) {
                if (uniqueAssistedParameters.add(assistedParameter)) continue;
                report.addError(String.format("@AssistedInject constructor has duplicate @Assisted type: %s. Consider setting an identifier on the parameter by using @Assisted(\"identifier\") in both the factory and @AssistedInject constructor", assistedParameter), assistedParameter.element());
            }
            return report.build();
        }
    }
}

