/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
final class SuperficialValidator
implements ClearableCache {
    private final DaggerSuperficialValidation superficialValidation;
    private final Map<XTypeElement, Optional<DaggerSuperficialValidation.ValidationException>> validationExceptions = new HashMap<XTypeElement, Optional<DaggerSuperficialValidation.ValidationException>>();

    @Inject
    SuperficialValidator(DaggerSuperficialValidation superficialValidation) {
        this.superficialValidation = superficialValidation;
    }

    void throwIfNearestEnclosingTypeNotValid(XElement element) {
        Optional validationException = this.validationExceptions.computeIfAbsent(XElements.closestEnclosingTypeElement(element), this::validationExceptionsUncached);
        if (validationException.isPresent()) {
            throw (DaggerSuperficialValidation.ValidationException)validationException.get();
        }
    }

    private Optional<DaggerSuperficialValidation.ValidationException> validationExceptionsUncached(XTypeElement element) {
        try {
            this.superficialValidation.validateElement(element);
        }
        catch (DaggerSuperficialValidation.ValidationException validationException) {
            return Optional.of(validationException);
        }
        return Optional.empty();
    }

    @Override
    public void clearCache() {
        this.validationExceptions.clear();
    }
}

